/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A liveBroadcast resource represents an event that will be streamed, via live video, on YouTube.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveBroadcast extends com.google.api.client.json.GenericJson {

  /**
   * The contentDetails object contains information about the event's video content, such as whether
   * the content can be shown in an embedded video player or if it will be archived and therefore
   * available for viewing after the event has concluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveBroadcastContentDetails contentDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube assigns to uniquely identify the broadcast.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveBroadcast".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the event, including its title, description,
   * start time, and end time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveBroadcastSnippet snippet;

  /**
   * The statistics object contains info about the event's current stats. These include concurrent
   * viewers and total chat count. Statistics can change (in either direction) during the lifetime
   * of an event. Statistics are only returned while the event is live.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveBroadcastStatistics statistics;

  /**
   * The status object contains information about the event's status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveBroadcastStatus status;

  /**
   * The contentDetails object contains information about the event's video content, such as whether
   * the content can be shown in an embedded video player or if it will be archived and therefore
   * available for viewing after the event has concluded.
   * @return value or {@code null} for none
   */
  public LiveBroadcastContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The contentDetails object contains information about the event's video content, such as whether
   * the content can be shown in an embedded video player or if it will be archived and therefore
   * available for viewing after the event has concluded.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public LiveBroadcast setContentDetails(LiveBroadcastContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public LiveBroadcast setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the broadcast.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the broadcast.
   * @param id id or {@code null} for none
   */
  public LiveBroadcast setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveBroadcast".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveBroadcast".
   * @param kind kind or {@code null} for none
   */
  public LiveBroadcast setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the event, including its title, description,
   * start time, and end time.
   * @return value or {@code null} for none
   */
  public LiveBroadcastSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the event, including its title, description,
   * start time, and end time.
   * @param snippet snippet or {@code null} for none
   */
  public LiveBroadcast setSnippet(LiveBroadcastSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The statistics object contains info about the event's current stats. These include concurrent
   * viewers and total chat count. Statistics can change (in either direction) during the lifetime
   * of an event. Statistics are only returned while the event is live.
   * @return value or {@code null} for none
   */
  public LiveBroadcastStatistics getStatistics() {
    return statistics;
  }

  /**
   * The statistics object contains info about the event's current stats. These include concurrent
   * viewers and total chat count. Statistics can change (in either direction) during the lifetime
   * of an event. Statistics are only returned while the event is live.
   * @param statistics statistics or {@code null} for none
   */
  public LiveBroadcast setStatistics(LiveBroadcastStatistics statistics) {
    this.statistics = statistics;
    return this;
  }

  /**
   * The status object contains information about the event's status.
   * @return value or {@code null} for none
   */
  public LiveBroadcastStatus getStatus() {
    return status;
  }

  /**
   * The status object contains information about the event's status.
   * @param status status or {@code null} for none
   */
  public LiveBroadcast setStatus(LiveBroadcastStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public LiveBroadcast set(String fieldName, Object value) {
    return (LiveBroadcast) super.set(fieldName, value);
  }

  @Override
  public LiveBroadcast clone() {
    return (LiveBroadcast) super.clone();
  }

}
