/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes an invideo promotion campaign consisting of multiple promoted items. A campaign belongs
 * to a single channel_id.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InvideoPromotion extends com.google.api.client.json.GenericJson {

  /**
   * The default temporal position within the video where the promoted item will be displayed. Can
   * be overriden by more specific timing in the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InvideoTiming defaultTiming;

  /**
   * List of promoted items in decreasing priority.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PromotedItem> items;

  /**
   * The spatial position within the video where the promoted item will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InvideoPosition position;

  /**
   * Indicates whether the channel's promotional campaign uses "smart timing." This feature attempts
   * to show promotions at a point in the video when they are more likely to be clicked and less
   * likely to disrupt the viewing experience. This feature also picks up a single promotion to show
   * on each video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useSmartTiming;

  /**
   * The default temporal position within the video where the promoted item will be displayed. Can
   * be overriden by more specific timing in the item.
   * @return value or {@code null} for none
   */
  public InvideoTiming getDefaultTiming() {
    return defaultTiming;
  }

  /**
   * The default temporal position within the video where the promoted item will be displayed. Can
   * be overriden by more specific timing in the item.
   * @param defaultTiming defaultTiming or {@code null} for none
   */
  public InvideoPromotion setDefaultTiming(InvideoTiming defaultTiming) {
    this.defaultTiming = defaultTiming;
    return this;
  }

  /**
   * List of promoted items in decreasing priority.
   * @return value or {@code null} for none
   */
  public java.util.List<PromotedItem> getItems() {
    return items;
  }

  /**
   * List of promoted items in decreasing priority.
   * @param items items or {@code null} for none
   */
  public InvideoPromotion setItems(java.util.List<PromotedItem> items) {
    this.items = items;
    return this;
  }

  /**
   * The spatial position within the video where the promoted item will be displayed.
   * @return value or {@code null} for none
   */
  public InvideoPosition getPosition() {
    return position;
  }

  /**
   * The spatial position within the video where the promoted item will be displayed.
   * @param position position or {@code null} for none
   */
  public InvideoPromotion setPosition(InvideoPosition position) {
    this.position = position;
    return this;
  }

  /**
   * Indicates whether the channel's promotional campaign uses "smart timing." This feature attempts
   * to show promotions at a point in the video when they are more likely to be clicked and less
   * likely to disrupt the viewing experience. This feature also picks up a single promotion to show
   * on each video.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseSmartTiming() {
    return useSmartTiming;
  }

  /**
   * Indicates whether the channel's promotional campaign uses "smart timing." This feature attempts
   * to show promotions at a point in the video when they are more likely to be clicked and less
   * likely to disrupt the viewing experience. This feature also picks up a single promotion to show
   * on each video.
   * @param useSmartTiming useSmartTiming or {@code null} for none
   */
  public InvideoPromotion setUseSmartTiming(java.lang.Boolean useSmartTiming) {
    this.useSmartTiming = useSmartTiming;
    return this;
  }

  @Override
  public InvideoPromotion set(String fieldName, Object value) {
    return (InvideoPromotion) super.set(fieldName, value);
  }

  @Override
  public InvideoPromotion clone() {
    return (InvideoPromotion) super.clone();
  }

}
