/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes information necessary for ingesting an RTMP or an HTTP stream.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IngestionInfo extends com.google.api.client.json.GenericJson {

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupIngestionAddress;

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL.
   *
   * Depending on which application or tool you use to encode your video stream, you may need to
   * enter the stream URL and stream name separately or you may need to concatenate them in the
   * following format:
   *
   * STREAM_URL/STREAM_NAME
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ingestionAddress;

  /**
   * The HTTP or RTMP stream name that YouTube assigns to the video stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streamName;

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupIngestionAddress() {
    return backupIngestionAddress;
  }

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * @param backupIngestionAddress backupIngestionAddress or {@code null} for none
   */
  public IngestionInfo setBackupIngestionAddress(java.lang.String backupIngestionAddress) {
    this.backupIngestionAddress = backupIngestionAddress;
    return this;
  }

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL.
   *
   * Depending on which application or tool you use to encode your video stream, you may need to
   * enter the stream URL and stream name separately or you may need to concatenate them in the
   * following format:
   *
   * STREAM_URL/STREAM_NAME
   * @return value or {@code null} for none
   */
  public java.lang.String getIngestionAddress() {
    return ingestionAddress;
  }

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL.
   *
   * Depending on which application or tool you use to encode your video stream, you may need to
   * enter the stream URL and stream name separately or you may need to concatenate them in the
   * following format:
   *
   * STREAM_URL/STREAM_NAME
   * @param ingestionAddress ingestionAddress or {@code null} for none
   */
  public IngestionInfo setIngestionAddress(java.lang.String ingestionAddress) {
    this.ingestionAddress = ingestionAddress;
    return this;
  }

  /**
   * The HTTP or RTMP stream name that YouTube assigns to the video stream.
   * @return value or {@code null} for none
   */
  public java.lang.String getStreamName() {
    return streamName;
  }

  /**
   * The HTTP or RTMP stream name that YouTube assigns to the video stream.
   * @param streamName streamName or {@code null} for none
   */
  public IngestionInfo setStreamName(java.lang.String streamName) {
    this.streamName = streamName;
    return this;
  }

  @Override
  public IngestionInfo set(String fieldName, Object value) {
    return (IngestionInfo) super.set(fieldName, value);
  }

  @Override
  public IngestionInfo clone() {
    return (IngestionInfo) super.clone();
  }

}
