/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Branding properties for the channel view.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelSettings extends com.google.api.client.json.GenericJson {

  /**
   * The country of the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultLanguage;

  /**
   * Which content tab users should see when viewing the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultTab;

  /**
   * Specifies the channel description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Title for the featured channels tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String featuredChannelsTitle;

  /**
   * The list of featured channels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> featuredChannelsUrls;

  /**
   * Lists keywords associated with the channel, comma-separated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keywords;

  /**
   * Whether user-submitted comments left on the channel page need to be approved by the channel
   * owner to be publicly visible.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean moderateComments;

  /**
   * A prominent color that can be rendered on this channel page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileColor;

  /**
   * Whether the tab to browse the videos should be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showBrowseView;

  /**
   * Whether related channels should be proposed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean showRelatedChannels;

  /**
   * Specifies the channel title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The ID for a Google Analytics account to track and measure traffic to the channels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingAnalyticsAccountId;

  /**
   * The trailer of the channel, for users that are not subscribers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unsubscribedTrailer;

  /**
   * The country of the channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The country of the channel.
   * @param country country or {@code null} for none
   */
  public ChannelSettings setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultLanguage() {
    return defaultLanguage;
  }

  /**
   * @param defaultLanguage defaultLanguage or {@code null} for none
   */
  public ChannelSettings setDefaultLanguage(java.lang.String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
    return this;
  }

  /**
   * Which content tab users should see when viewing the channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultTab() {
    return defaultTab;
  }

  /**
   * Which content tab users should see when viewing the channel.
   * @param defaultTab defaultTab or {@code null} for none
   */
  public ChannelSettings setDefaultTab(java.lang.String defaultTab) {
    this.defaultTab = defaultTab;
    return this;
  }

  /**
   * Specifies the channel description.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Specifies the channel description.
   * @param description description or {@code null} for none
   */
  public ChannelSettings setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Title for the featured channels tab.
   * @return value or {@code null} for none
   */
  public java.lang.String getFeaturedChannelsTitle() {
    return featuredChannelsTitle;
  }

  /**
   * Title for the featured channels tab.
   * @param featuredChannelsTitle featuredChannelsTitle or {@code null} for none
   */
  public ChannelSettings setFeaturedChannelsTitle(java.lang.String featuredChannelsTitle) {
    this.featuredChannelsTitle = featuredChannelsTitle;
    return this;
  }

  /**
   * The list of featured channels.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFeaturedChannelsUrls() {
    return featuredChannelsUrls;
  }

  /**
   * The list of featured channels.
   * @param featuredChannelsUrls featuredChannelsUrls or {@code null} for none
   */
  public ChannelSettings setFeaturedChannelsUrls(java.util.List<java.lang.String> featuredChannelsUrls) {
    this.featuredChannelsUrls = featuredChannelsUrls;
    return this;
  }

  /**
   * Lists keywords associated with the channel, comma-separated.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeywords() {
    return keywords;
  }

  /**
   * Lists keywords associated with the channel, comma-separated.
   * @param keywords keywords or {@code null} for none
   */
  public ChannelSettings setKeywords(java.lang.String keywords) {
    this.keywords = keywords;
    return this;
  }

  /**
   * Whether user-submitted comments left on the channel page need to be approved by the channel
   * owner to be publicly visible.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getModerateComments() {
    return moderateComments;
  }

  /**
   * Whether user-submitted comments left on the channel page need to be approved by the channel
   * owner to be publicly visible.
   * @param moderateComments moderateComments or {@code null} for none
   */
  public ChannelSettings setModerateComments(java.lang.Boolean moderateComments) {
    this.moderateComments = moderateComments;
    return this;
  }

  /**
   * A prominent color that can be rendered on this channel page.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileColor() {
    return profileColor;
  }

  /**
   * A prominent color that can be rendered on this channel page.
   * @param profileColor profileColor or {@code null} for none
   */
  public ChannelSettings setProfileColor(java.lang.String profileColor) {
    this.profileColor = profileColor;
    return this;
  }

  /**
   * Whether the tab to browse the videos should be displayed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowBrowseView() {
    return showBrowseView;
  }

  /**
   * Whether the tab to browse the videos should be displayed.
   * @param showBrowseView showBrowseView or {@code null} for none
   */
  public ChannelSettings setShowBrowseView(java.lang.Boolean showBrowseView) {
    this.showBrowseView = showBrowseView;
    return this;
  }

  /**
   * Whether related channels should be proposed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShowRelatedChannels() {
    return showRelatedChannels;
  }

  /**
   * Whether related channels should be proposed.
   * @param showRelatedChannels showRelatedChannels or {@code null} for none
   */
  public ChannelSettings setShowRelatedChannels(java.lang.Boolean showRelatedChannels) {
    this.showRelatedChannels = showRelatedChannels;
    return this;
  }

  /**
   * Specifies the channel title.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Specifies the channel title.
   * @param title title or {@code null} for none
   */
  public ChannelSettings setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The ID for a Google Analytics account to track and measure traffic to the channels.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingAnalyticsAccountId() {
    return trackingAnalyticsAccountId;
  }

  /**
   * The ID for a Google Analytics account to track and measure traffic to the channels.
   * @param trackingAnalyticsAccountId trackingAnalyticsAccountId or {@code null} for none
   */
  public ChannelSettings setTrackingAnalyticsAccountId(java.lang.String trackingAnalyticsAccountId) {
    this.trackingAnalyticsAccountId = trackingAnalyticsAccountId;
    return this;
  }

  /**
   * The trailer of the channel, for users that are not subscribers.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnsubscribedTrailer() {
    return unsubscribedTrailer;
  }

  /**
   * The trailer of the channel, for users that are not subscribers.
   * @param unsubscribedTrailer unsubscribedTrailer or {@code null} for none
   */
  public ChannelSettings setUnsubscribedTrailer(java.lang.String unsubscribedTrailer) {
    this.unsubscribedTrailer = unsubscribedTrailer;
    return this;
  }

  @Override
  public ChannelSettings set(String fieldName, Object value) {
    return (ChannelSettings) super.set(fieldName, value);
  }

  @Override
  public ChannelSettings clone() {
    return (ChannelSettings) super.clone();
  }

}
