/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * ChannelSection targeting setting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelSectionTargeting extends com.google.api.client.json.GenericJson {

  /**
   * The country the channel section is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> countries;

  /**
   * The language the channel section is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> languages;

  /**
   * The region the channel section is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> regions;

  /**
   * The country the channel section is targeting.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCountries() {
    return countries;
  }

  /**
   * The country the channel section is targeting.
   * @param countries countries or {@code null} for none
   */
  public ChannelSectionTargeting setCountries(java.util.List<java.lang.String> countries) {
    this.countries = countries;
    return this;
  }

  /**
   * The language the channel section is targeting.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLanguages() {
    return languages;
  }

  /**
   * The language the channel section is targeting.
   * @param languages languages or {@code null} for none
   */
  public ChannelSectionTargeting setLanguages(java.util.List<java.lang.String> languages) {
    this.languages = languages;
    return this;
  }

  /**
   * The region the channel section is targeting.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRegions() {
    return regions;
  }

  /**
   * The region the channel section is targeting.
   * @param regions regions or {@code null} for none
   */
  public ChannelSectionTargeting setRegions(java.util.List<java.lang.String> regions) {
    this.regions = regions;
    return this;
  }

  @Override
  public ChannelSectionTargeting set(String fieldName, Object value) {
    return (ChannelSectionTargeting) super.set(fieldName, value);
  }

  @Override
  public ChannelSectionTargeting clone() {
    return (ChannelSectionTargeting) super.clone();
  }

}
