/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about a channel section, including title, style and position.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelSectionSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The ID that YouTube uses to uniquely identify the channel that published the channel section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * The language of the channel section's default title and description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultLanguage;

  /**
   * Localized title, read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelSectionLocalization localized;

  /**
   * The position of the channel section in the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long position;

  /**
   * The style of the channel section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String style;

  /**
   * The channel section's title for multiple_playlists and multiple_channels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The type of the channel section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The ID that YouTube uses to uniquely identify the channel that published the channel section.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The ID that YouTube uses to uniquely identify the channel that published the channel section.
   * @param channelId channelId or {@code null} for none
   */
  public ChannelSectionSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * The language of the channel section's default title and description.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultLanguage() {
    return defaultLanguage;
  }

  /**
   * The language of the channel section's default title and description.
   * @param defaultLanguage defaultLanguage or {@code null} for none
   */
  public ChannelSectionSnippet setDefaultLanguage(java.lang.String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
    return this;
  }

  /**
   * Localized title, read-only.
   * @return value or {@code null} for none
   */
  public ChannelSectionLocalization getLocalized() {
    return localized;
  }

  /**
   * Localized title, read-only.
   * @param localized localized or {@code null} for none
   */
  public ChannelSectionSnippet setLocalized(ChannelSectionLocalization localized) {
    this.localized = localized;
    return this;
  }

  /**
   * The position of the channel section in the channel.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPosition() {
    return position;
  }

  /**
   * The position of the channel section in the channel.
   * @param position position or {@code null} for none
   */
  public ChannelSectionSnippet setPosition(java.lang.Long position) {
    this.position = position;
    return this;
  }

  /**
   * The style of the channel section.
   * @return value or {@code null} for none
   */
  public java.lang.String getStyle() {
    return style;
  }

  /**
   * The style of the channel section.
   * @param style style or {@code null} for none
   */
  public ChannelSectionSnippet setStyle(java.lang.String style) {
    this.style = style;
    return this;
  }

  /**
   * The channel section's title for multiple_playlists and multiple_channels.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The channel section's title for multiple_playlists and multiple_channels.
   * @param title title or {@code null} for none
   */
  public ChannelSectionSnippet setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The type of the channel section.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the channel section.
   * @param type type or {@code null} for none
   */
  public ChannelSectionSnippet setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ChannelSectionSnippet set(String fieldName, Object value) {
    return (ChannelSectionSnippet) super.set(fieldName, value);
  }

  @Override
  public ChannelSectionSnippet clone() {
    return (ChannelSectionSnippet) super.clone();
  }

}
