/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Details about the content of a channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelContentDetails extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RelatedPlaylists relatedPlaylists;

  /**
   * @return value or {@code null} for none
   */
  public RelatedPlaylists getRelatedPlaylists() {
    return relatedPlaylists;
  }

  /**
   * @param relatedPlaylists relatedPlaylists or {@code null} for none
   */
  public ChannelContentDetails setRelatedPlaylists(RelatedPlaylists relatedPlaylists) {
    this.relatedPlaylists = relatedPlaylists;
    return this;
  }

  @Override
  public ChannelContentDetails set(String fieldName, Object value) {
    return (ChannelContentDetails) super.set(fieldName, value);
  }

  @Override
  public ChannelContentDetails clone() {
    return (ChannelContentDetails) super.clone();
  }

  /**
   * Model definition for ChannelContentDetailsRelatedPlaylists.
   */
  public static final class RelatedPlaylists extends com.google.api.client.json.GenericJson {

    /**
     * The ID of the playlist that contains the channel"s favorite videos. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String favorites;

    /**
     * The ID of the playlist that contains the channel"s liked videos. Use the   playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String likes;

    /**
     * The ID of the playlist that contains the channel"s uploaded videos. Use the  videos.insert
     * method to upload new videos and the videos.delete method to delete previously uploaded videos.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String uploads;

    /**
     * The ID of the playlist that contains the channel"s watch history. Use the  playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String watchHistory;

    /**
     * The ID of the playlist that contains the channel"s watch later playlist. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String watchLater;

    /**
     * The ID of the playlist that contains the channel"s favorite videos. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * @return value or {@code null} for none
     */
    public java.lang.String getFavorites() {
      return favorites;
    }

    /**
     * The ID of the playlist that contains the channel"s favorite videos. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * @param favorites favorites or {@code null} for none
     */
    public RelatedPlaylists setFavorites(java.lang.String favorites) {
      this.favorites = favorites;
      return this;
    }

    /**
     * The ID of the playlist that contains the channel"s liked videos. Use the   playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * @return value or {@code null} for none
     */
    public java.lang.String getLikes() {
      return likes;
    }

    /**
     * The ID of the playlist that contains the channel"s liked videos. Use the   playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * @param likes likes or {@code null} for none
     */
    public RelatedPlaylists setLikes(java.lang.String likes) {
      this.likes = likes;
      return this;
    }

    /**
     * The ID of the playlist that contains the channel"s uploaded videos. Use the  videos.insert
     * method to upload new videos and the videos.delete method to delete previously uploaded videos.
     * @return value or {@code null} for none
     */
    public java.lang.String getUploads() {
      return uploads;
    }

    /**
     * The ID of the playlist that contains the channel"s uploaded videos. Use the  videos.insert
     * method to upload new videos and the videos.delete method to delete previously uploaded videos.
     * @param uploads uploads or {@code null} for none
     */
    public RelatedPlaylists setUploads(java.lang.String uploads) {
      this.uploads = uploads;
      return this;
    }

    /**
     * The ID of the playlist that contains the channel"s watch history. Use the  playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * @return value or {@code null} for none
     */
    public java.lang.String getWatchHistory() {
      return watchHistory;
    }

    /**
     * The ID of the playlist that contains the channel"s watch history. Use the  playlistItems.insert
     * and  playlistItems.delete to add or remove items from that list.
     * @param watchHistory watchHistory or {@code null} for none
     */
    public RelatedPlaylists setWatchHistory(java.lang.String watchHistory) {
      this.watchHistory = watchHistory;
      return this;
    }

    /**
     * The ID of the playlist that contains the channel"s watch later playlist. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * @return value or {@code null} for none
     */
    public java.lang.String getWatchLater() {
      return watchLater;
    }

    /**
     * The ID of the playlist that contains the channel"s watch later playlist. Use the
     * playlistItems.insert and  playlistItems.delete to add or remove items from that list.
     * @param watchLater watchLater or {@code null} for none
     */
    public RelatedPlaylists setWatchLater(java.lang.String watchLater) {
      this.watchLater = watchLater;
      return this;
    }

    @Override
    public RelatedPlaylists set(String fieldName, Object value) {
      return (RelatedPlaylists) super.set(fieldName, value);
    }

    @Override
    public RelatedPlaylists clone() {
      return (RelatedPlaylists) super.clone();
    }

  }
}
