/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Information about a new playlist item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActivityContentDetailsPlaylistItem extends com.google.api.client.json.GenericJson {

  /**
   * The value that YouTube uses to uniquely identify the playlist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playlistId;

  /**
   * ID of the item within the playlist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playlistItemId;

  /**
   * The resourceId object contains information about the resource that was added to the playlist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceId resourceId;

  /**
   * The value that YouTube uses to uniquely identify the playlist.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaylistId() {
    return playlistId;
  }

  /**
   * The value that YouTube uses to uniquely identify the playlist.
   * @param playlistId playlistId or {@code null} for none
   */
  public ActivityContentDetailsPlaylistItem setPlaylistId(java.lang.String playlistId) {
    this.playlistId = playlistId;
    return this;
  }

  /**
   * ID of the item within the playlist.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaylistItemId() {
    return playlistItemId;
  }

  /**
   * ID of the item within the playlist.
   * @param playlistItemId playlistItemId or {@code null} for none
   */
  public ActivityContentDetailsPlaylistItem setPlaylistItemId(java.lang.String playlistItemId) {
    this.playlistItemId = playlistItemId;
    return this;
  }

  /**
   * The resourceId object contains information about the resource that was added to the playlist.
   * @return value or {@code null} for none
   */
  public ResourceId getResourceId() {
    return resourceId;
  }

  /**
   * The resourceId object contains information about the resource that was added to the playlist.
   * @param resourceId resourceId or {@code null} for none
   */
  public ActivityContentDetailsPlaylistItem setResourceId(ResourceId resourceId) {
    this.resourceId = resourceId;
    return this;
  }

  @Override
  public ActivityContentDetailsPlaylistItem set(String fieldName, Object value) {
    return (ActivityContentDetailsPlaylistItem) super.set(fieldName, value);
  }

  @Override
  public ActivityContentDetailsPlaylistItem clone() {
    return (ActivityContentDetailsPlaylistItem) super.clone();
  }

}
