/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.translate;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.translate.TranslateRequest;
import com.google.api.services.translate.TranslateRequestInitializer;
import com.google.api.services.translate.model.DetectLanguageRequest;
import com.google.api.services.translate.model.DetectionsListResponse;
import com.google.api.services.translate.model.LanguagesListResponse;
import com.google.api.services.translate.model.TranslateTextRequest;
import com.google.api.services.translate.model.TranslationsListResponse;
import java.io.IOException;
import java.util.List;

public class Translate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://translation.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "language/translate/";
    public static final String DEFAULT_BATCH_PATH = "batch/translate";
    public static final String DEFAULT_BASE_URL = "https://translation.googleapis.com/language/translate/";

    public Translate(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Translate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Detections detections() {
        return new Detections();
    }

    public Languages languages() {
        return new Languages();
    }

    public Translations translations() {
        return new Translations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Google Cloud Translation API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Translate.DEFAULT_ROOT_URL, Translate.DEFAULT_SERVICE_PATH, httpRequestInitializer, true);
            this.setBatchPath(Translate.DEFAULT_BATCH_PATH);
        }

        public Translate build() {
            return new Translate(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setTranslateRequestInitializer(TranslateRequestInitializer translateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)translateRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Translations {
        public List list(java.util.List<String> q, String target) throws IOException {
            List result = new List(q, target);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TranslateOperation translate(TranslateTextRequest content) throws IOException {
            TranslateOperation result = new TranslateOperation(content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TranslateOperation
        extends TranslateRequest<TranslationsListResponse> {
            private static final String REST_PATH = "v2";

            protected TranslateOperation(TranslateTextRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, TranslationsListResponse.class);
            }

            public TranslateOperation set$Xgafv(String $Xgafv) {
                return (TranslateOperation)super.set$Xgafv($Xgafv);
            }

            public TranslateOperation setAccessToken(String accessToken) {
                return (TranslateOperation)super.setAccessToken(accessToken);
            }

            public TranslateOperation setAlt(String alt) {
                return (TranslateOperation)super.setAlt(alt);
            }

            public TranslateOperation setBearerToken(String bearerToken) {
                return (TranslateOperation)super.setBearerToken(bearerToken);
            }

            public TranslateOperation setCallback(String callback) {
                return (TranslateOperation)super.setCallback(callback);
            }

            public TranslateOperation setFields(String fields) {
                return (TranslateOperation)super.setFields(fields);
            }

            public TranslateOperation setKey(String key) {
                return (TranslateOperation)super.setKey(key);
            }

            public TranslateOperation setOauthToken(String oauthToken) {
                return (TranslateOperation)super.setOauthToken(oauthToken);
            }

            public TranslateOperation setPp(Boolean pp) {
                return (TranslateOperation)super.setPp(pp);
            }

            public TranslateOperation setPrettyPrint(Boolean prettyPrint) {
                return (TranslateOperation)super.setPrettyPrint(prettyPrint);
            }

            public TranslateOperation setQuotaUser(String quotaUser) {
                return (TranslateOperation)super.setQuotaUser(quotaUser);
            }

            public TranslateOperation setUploadType(String uploadType) {
                return (TranslateOperation)super.setUploadType(uploadType);
            }

            public TranslateOperation setUploadProtocol(String uploadProtocol) {
                return (TranslateOperation)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public TranslateOperation set(String parameterName, Object value) {
                return (TranslateOperation)super.set(parameterName, value);
            }
        }

        public class List
        extends TranslateRequest<TranslationsListResponse> {
            private static final String REST_PATH = "v2";
            @Key
            private java.util.List<String> q;
            @Key
            private String target;
            @Key
            private java.util.List<String> cid;
            @Key
            private String format;
            @Key
            private String model;
            @Key
            private String source;

            protected List(java.util.List<String> q, String target) {
                super(Translate.this, "GET", REST_PATH, null, TranslationsListResponse.class);
                this.q = (java.util.List)Preconditions.checkNotNull(q, (Object)"Required parameter q must be specified.");
                this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"Required parameter target must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setBearerToken(String bearerToken) {
                return (List)super.setBearerToken(bearerToken);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPp(Boolean pp) {
                return (List)super.setPp(pp);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getQ() {
                return this.q;
            }

            public List setQ(java.util.List<String> q) {
                this.q = q;
                return this;
            }

            public String getTarget() {
                return this.target;
            }

            public List setTarget(String target) {
                this.target = target;
                return this;
            }

            public java.util.List<String> getCid() {
                return this.cid;
            }

            public List setCid(java.util.List<String> cid) {
                this.cid = cid;
                return this;
            }

            public String getFormat() {
                return this.format;
            }

            public List setFormat(String format) {
                this.format = format;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public List setModel(String model) {
                this.model = model;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Languages {
        public List list() throws IOException {
            List result = new List();
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends TranslateRequest<LanguagesListResponse> {
            private static final String REST_PATH = "v2/languages";
            @Key
            private String model;
            @Key
            private String target;

            protected List() {
                super(Translate.this, "GET", REST_PATH, null, LanguagesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setBearerToken(String bearerToken) {
                return (List)super.setBearerToken(bearerToken);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPp(Boolean pp) {
                return (List)super.setPp(pp);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getModel() {
                return this.model;
            }

            public List setModel(String model) {
                this.model = model;
                return this;
            }

            public String getTarget() {
                return this.target;
            }

            public List setTarget(String target) {
                this.target = target;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Detections {
        public Detect detect(DetectLanguageRequest content) throws IOException {
            Detect result = new Detect(content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> q) throws IOException {
            List result = new List(q);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends TranslateRequest<DetectionsListResponse> {
            private static final String REST_PATH = "v2/detect";
            @Key
            private java.util.List<String> q;

            protected List(java.util.List<String> q) {
                super(Translate.this, "GET", REST_PATH, null, DetectionsListResponse.class);
                this.q = (java.util.List)Preconditions.checkNotNull(q, (Object)"Required parameter q must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setBearerToken(String bearerToken) {
                return (List)super.setBearerToken(bearerToken);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPp(Boolean pp) {
                return (List)super.setPp(pp);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getQ() {
                return this.q;
            }

            public List setQ(java.util.List<String> q) {
                this.q = q;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Detect
        extends TranslateRequest<DetectionsListResponse> {
            private static final String REST_PATH = "v2/detect";

            protected Detect(DetectLanguageRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, DetectionsListResponse.class);
            }

            public Detect set$Xgafv(String $Xgafv) {
                return (Detect)super.set$Xgafv($Xgafv);
            }

            public Detect setAccessToken(String accessToken) {
                return (Detect)super.setAccessToken(accessToken);
            }

            public Detect setAlt(String alt) {
                return (Detect)super.setAlt(alt);
            }

            public Detect setBearerToken(String bearerToken) {
                return (Detect)super.setBearerToken(bearerToken);
            }

            public Detect setCallback(String callback) {
                return (Detect)super.setCallback(callback);
            }

            public Detect setFields(String fields) {
                return (Detect)super.setFields(fields);
            }

            public Detect setKey(String key) {
                return (Detect)super.setKey(key);
            }

            public Detect setOauthToken(String oauthToken) {
                return (Detect)super.setOauthToken(oauthToken);
            }

            public Detect setPp(Boolean pp) {
                return (Detect)super.setPp(pp);
            }

            public Detect setPrettyPrint(Boolean prettyPrint) {
                return (Detect)super.setPrettyPrint(prettyPrint);
            }

            public Detect setQuotaUser(String quotaUser) {
                return (Detect)super.setQuotaUser(quotaUser);
            }

            public Detect setUploadType(String uploadType) {
                return (Detect)super.setUploadType(uploadType);
            }

            public Detect setUploadProtocol(String uploadProtocol) {
                return (Detect)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Detect set(String parameterName, Object value) {
                return (Detect)super.set(parameterName, value);
            }
        }
    }
}

