/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdaptiveMtFileName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_FILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String file;

    @Deprecated
    protected AdaptiveMtFileName() {
        this.project = null;
        this.location = null;
        this.dataset = null;
        this.file = null;
    }

    private AdaptiveMtFileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.file = (String)Preconditions.checkNotNull((Object)builder.getFile());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getFile() {
        return this.file;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdaptiveMtFileName of(String project, String location, String dataset, String file) {
        return AdaptiveMtFileName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setFile(file).build();
    }

    public static String format(String project, String location, String dataset, String file) {
        return AdaptiveMtFileName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setFile(file).build().toString();
    }

    public static AdaptiveMtFileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_FILE.validatedMatch(formattedString, "AdaptiveMtFileName.parse: formattedString not in valid format");
        return AdaptiveMtFileName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("file"));
    }

    public static List<AdaptiveMtFileName> parseList(List<String> formattedStrings) {
        ArrayList<AdaptiveMtFileName> list = new ArrayList<AdaptiveMtFileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdaptiveMtFileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdaptiveMtFileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdaptiveMtFileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_FILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdaptiveMtFileName adaptiveMtFileName = this;
            synchronized (adaptiveMtFileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.file != null) {
                        fieldMapBuilder.put((Object)"file", (Object)this.file);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_FILE.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "file", this.file});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdaptiveMtFileName that = (AdaptiveMtFileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.file, that.file);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.file);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String file;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getFile() {
            return this.file;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setFile(String file) {
            this.file = file;
            return this;
        }

        private Builder(AdaptiveMtFileName adaptiveMtFileName) {
            this.project = adaptiveMtFileName.project;
            this.location = adaptiveMtFileName.location;
            this.dataset = adaptiveMtFileName.dataset;
            this.file = adaptiveMtFileName.file;
        }

        public AdaptiveMtFileName build() {
            return new AdaptiveMtFileName(this);
        }
    }
}

