/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Provides "hints" to the speech recognizer to favor specific words and phrases
 * in the results. Phrase sets can be specified as an inline resource, or a
 * reference to an existing phrase set resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.SpeechAdaptation}
 */
public final class SpeechAdaptation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.SpeechAdaptation)
    SpeechAdaptationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpeechAdaptation.newBuilder() to construct.
  private SpeechAdaptation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeechAdaptation() {
    phraseSets_ = java.util.Collections.emptyList();
    customClasses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeechAdaptation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_SpeechAdaptation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_SpeechAdaptation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.SpeechAdaptation.class,
            com.google.cloud.speech.v2.SpeechAdaptation.Builder.class);
  }

  public interface AdaptationPhraseSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the phraseSet field is set.
     */
    boolean hasPhraseSet();
    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The phraseSet.
     */
    java.lang.String getPhraseSet();
    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for phraseSet.
     */
    com.google.protobuf.ByteString getPhraseSetBytes();

    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     *
     * @return Whether the inlinePhraseSet field is set.
     */
    boolean hasInlinePhraseSet();
    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     *
     * @return The inlinePhraseSet.
     */
    com.google.cloud.speech.v2.PhraseSet getInlinePhraseSet();
    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     */
    com.google.cloud.speech.v2.PhraseSetOrBuilder getInlinePhraseSetOrBuilder();

    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.ValueCase getValueCase();
  }
  /**
   *
   *
   * <pre>
   * A biasing phrase set, which can be either a string referencing the name of
   * an existing phrase set resource, or an inline definition of a phrase set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet}
   */
  public static final class AdaptationPhraseSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)
      AdaptationPhraseSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AdaptationPhraseSet.newBuilder() to construct.
    private AdaptationPhraseSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AdaptationPhraseSet() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AdaptationPhraseSet();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechAdaptation_AdaptationPhraseSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechAdaptation_AdaptationPhraseSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.class,
              com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder.class);
    }

    private int valueCase_ = 0;
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PHRASE_SET(1),
      INLINE_PHRASE_SET(2),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 1:
            return PHRASE_SET;
          case 2:
            return INLINE_PHRASE_SET;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int PHRASE_SET_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the phraseSet field is set.
     */
    public boolean hasPhraseSet() {
      return valueCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The phraseSet.
     */
    public java.lang.String getPhraseSet() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 1) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of an existing phrase set resource. The user must have read
     * access to the resource and it must not be deleted.
     * </pre>
     *
     * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for phraseSet.
     */
    public com.google.protobuf.ByteString getPhraseSetBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 1) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INLINE_PHRASE_SET_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     *
     * @return Whether the inlinePhraseSet field is set.
     */
    @java.lang.Override
    public boolean hasInlinePhraseSet() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     *
     * @return The inlinePhraseSet.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.PhraseSet getInlinePhraseSet() {
      if (valueCase_ == 2) {
        return (com.google.cloud.speech.v2.PhraseSet) value_;
      }
      return com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * An inline defined phrase set.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.PhraseSetOrBuilder getInlinePhraseSetOrBuilder() {
      if (valueCase_ == 2) {
        return (com.google.cloud.speech.v2.PhraseSet) value_;
      }
      return com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (valueCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (valueCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.speech.v2.PhraseSet) value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (valueCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.speech.v2.PhraseSet) value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)) {
        return super.equals(obj);
      }
      com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet other =
          (com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet) obj;

      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 1:
          if (!getPhraseSet().equals(other.getPhraseSet())) return false;
          break;
        case 2:
          if (!getInlinePhraseSet().equals(other.getInlinePhraseSet())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (valueCase_) {
        case 1:
          hash = (37 * hash) + PHRASE_SET_FIELD_NUMBER;
          hash = (53 * hash) + getPhraseSet().hashCode();
          break;
        case 2:
          hash = (37 * hash) + INLINE_PHRASE_SET_FIELD_NUMBER;
          hash = (53 * hash) + getInlinePhraseSet().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A biasing phrase set, which can be either a string referencing the name of
     * an existing phrase set resource, or an inline definition of a phrase set.
     * </pre>
     *
     * Protobuf type {@code google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.speech.v2.CloudSpeechProto
            .internal_static_google_cloud_speech_v2_SpeechAdaptation_AdaptationPhraseSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.speech.v2.CloudSpeechProto
            .internal_static_google_cloud_speech_v2_SpeechAdaptation_AdaptationPhraseSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.class,
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder.class);
      }

      // Construct using
      // com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (inlinePhraseSetBuilder_ != null) {
          inlinePhraseSetBuilder_.clear();
        }
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.speech.v2.CloudSpeechProto
            .internal_static_google_cloud_speech_v2_SpeechAdaptation_AdaptationPhraseSet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
          getDefaultInstanceForType() {
        return com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet build() {
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet buildPartial() {
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet result =
            new com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
        if (valueCase_ == 2 && inlinePhraseSetBuilder_ != null) {
          result.value_ = inlinePhraseSetBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet) {
          return mergeFrom((com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet other) {
        if (other
            == com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.getDefaultInstance())
          return this;
        switch (other.getValueCase()) {
          case PHRASE_SET:
            {
              valueCase_ = 1;
              value_ = other.value_;
              onChanged();
              break;
            }
          case INLINE_PHRASE_SET:
            {
              mergeInlinePhraseSet(other.getInlinePhraseSet());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  valueCase_ = 1;
                  value_ = s;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getInlinePhraseSetFieldBuilder().getBuilder(), extensionRegistry);
                  valueCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the phraseSet field is set.
       */
      @java.lang.Override
      public boolean hasPhraseSet() {
        return valueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The phraseSet.
       */
      @java.lang.Override
      public java.lang.String getPhraseSet() {
        java.lang.Object ref = "";
        if (valueCase_ == 1) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 1) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for phraseSet.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPhraseSetBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 1) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (valueCase_ == 1) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The phraseSet to set.
       * @return This builder for chaining.
       */
      public Builder setPhraseSet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhraseSet() {
        if (valueCase_ == 1) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of an existing phrase set resource. The user must have read
       * access to the resource and it must not be deleted.
       * </pre>
       *
       * <code>string phrase_set = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for phraseSet to set.
       * @return This builder for chaining.
       */
      public Builder setPhraseSetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.speech.v2.PhraseSet,
              com.google.cloud.speech.v2.PhraseSet.Builder,
              com.google.cloud.speech.v2.PhraseSetOrBuilder>
          inlinePhraseSetBuilder_;
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       *
       * @return Whether the inlinePhraseSet field is set.
       */
      @java.lang.Override
      public boolean hasInlinePhraseSet() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       *
       * @return The inlinePhraseSet.
       */
      @java.lang.Override
      public com.google.cloud.speech.v2.PhraseSet getInlinePhraseSet() {
        if (inlinePhraseSetBuilder_ == null) {
          if (valueCase_ == 2) {
            return (com.google.cloud.speech.v2.PhraseSet) value_;
          }
          return com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
        } else {
          if (valueCase_ == 2) {
            return inlinePhraseSetBuilder_.getMessage();
          }
          return com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      public Builder setInlinePhraseSet(com.google.cloud.speech.v2.PhraseSet value) {
        if (inlinePhraseSetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          inlinePhraseSetBuilder_.setMessage(value);
        }
        valueCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      public Builder setInlinePhraseSet(
          com.google.cloud.speech.v2.PhraseSet.Builder builderForValue) {
        if (inlinePhraseSetBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          inlinePhraseSetBuilder_.setMessage(builderForValue.build());
        }
        valueCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      public Builder mergeInlinePhraseSet(com.google.cloud.speech.v2.PhraseSet value) {
        if (inlinePhraseSetBuilder_ == null) {
          if (valueCase_ == 2
              && value_ != com.google.cloud.speech.v2.PhraseSet.getDefaultInstance()) {
            value_ =
                com.google.cloud.speech.v2.PhraseSet.newBuilder(
                        (com.google.cloud.speech.v2.PhraseSet) value_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          if (valueCase_ == 2) {
            inlinePhraseSetBuilder_.mergeFrom(value);
          } else {
            inlinePhraseSetBuilder_.setMessage(value);
          }
        }
        valueCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      public Builder clearInlinePhraseSet() {
        if (inlinePhraseSetBuilder_ == null) {
          if (valueCase_ == 2) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
        } else {
          if (valueCase_ == 2) {
            valueCase_ = 0;
            value_ = null;
          }
          inlinePhraseSetBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      public com.google.cloud.speech.v2.PhraseSet.Builder getInlinePhraseSetBuilder() {
        return getInlinePhraseSetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.speech.v2.PhraseSetOrBuilder getInlinePhraseSetOrBuilder() {
        if ((valueCase_ == 2) && (inlinePhraseSetBuilder_ != null)) {
          return inlinePhraseSetBuilder_.getMessageOrBuilder();
        } else {
          if (valueCase_ == 2) {
            return (com.google.cloud.speech.v2.PhraseSet) value_;
          }
          return com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An inline defined phrase set.
       * </pre>
       *
       * <code>.google.cloud.speech.v2.PhraseSet inline_phrase_set = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.speech.v2.PhraseSet,
              com.google.cloud.speech.v2.PhraseSet.Builder,
              com.google.cloud.speech.v2.PhraseSetOrBuilder>
          getInlinePhraseSetFieldBuilder() {
        if (inlinePhraseSetBuilder_ == null) {
          if (!(valueCase_ == 2)) {
            value_ = com.google.cloud.speech.v2.PhraseSet.getDefaultInstance();
          }
          inlinePhraseSetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.speech.v2.PhraseSet,
                  com.google.cloud.speech.v2.PhraseSet.Builder,
                  com.google.cloud.speech.v2.PhraseSetOrBuilder>(
                  (com.google.cloud.speech.v2.PhraseSet) value_, getParentForChildren(), isClean());
          value_ = null;
        }
        valueCase_ = 2;
        onChanged();
        return inlinePhraseSetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet)
    private static final com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet();
    }

    public static com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AdaptationPhraseSet> PARSER =
        new com.google.protobuf.AbstractParser<AdaptationPhraseSet>() {
          @java.lang.Override
          public AdaptationPhraseSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AdaptationPhraseSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AdaptationPhraseSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PHRASE_SETS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>
      phraseSets_;
  /**
   *
   *
   * <pre>
   * A list of inline or referenced phrase sets.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>
      getPhraseSetsList() {
    return phraseSets_;
  }
  /**
   *
   *
   * <pre>
   * A list of inline or referenced phrase sets.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder>
      getPhraseSetsOrBuilderList() {
    return phraseSets_;
  }
  /**
   *
   *
   * <pre>
   * A list of inline or referenced phrase sets.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
   * </code>
   */
  @java.lang.Override
  public int getPhraseSetsCount() {
    return phraseSets_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of inline or referenced phrase sets.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet getPhraseSets(int index) {
    return phraseSets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of inline or referenced phrase sets.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder
      getPhraseSetsOrBuilder(int index) {
    return phraseSets_.get(index);
  }

  public static final int CUSTOM_CLASSES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v2.CustomClass> customClasses_;
  /**
   *
   *
   * <pre>
   * A list of inline custom classes. Existing custom class resources can be
   * referenced directly in a phrase set.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v2.CustomClass> getCustomClassesList() {
    return customClasses_;
  }
  /**
   *
   *
   * <pre>
   * A list of inline custom classes. Existing custom class resources can be
   * referenced directly in a phrase set.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v2.CustomClassOrBuilder>
      getCustomClassesOrBuilderList() {
    return customClasses_;
  }
  /**
   *
   *
   * <pre>
   * A list of inline custom classes. Existing custom class resources can be
   * referenced directly in a phrase set.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
   */
  @java.lang.Override
  public int getCustomClassesCount() {
    return customClasses_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of inline custom classes. Existing custom class resources can be
   * referenced directly in a phrase set.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CustomClass getCustomClasses(int index) {
    return customClasses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of inline custom classes. Existing custom class resources can be
   * referenced directly in a phrase set.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CustomClassOrBuilder getCustomClassesOrBuilder(int index) {
    return customClasses_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < phraseSets_.size(); i++) {
      output.writeMessage(1, phraseSets_.get(i));
    }
    for (int i = 0; i < customClasses_.size(); i++) {
      output.writeMessage(2, customClasses_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < phraseSets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, phraseSets_.get(i));
    }
    for (int i = 0; i < customClasses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, customClasses_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.SpeechAdaptation)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.SpeechAdaptation other =
        (com.google.cloud.speech.v2.SpeechAdaptation) obj;

    if (!getPhraseSetsList().equals(other.getPhraseSetsList())) return false;
    if (!getCustomClassesList().equals(other.getCustomClassesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPhraseSetsCount() > 0) {
      hash = (37 * hash) + PHRASE_SETS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseSetsList().hashCode();
    }
    if (getCustomClassesCount() > 0) {
      hash = (37 * hash) + CUSTOM_CLASSES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomClassesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.SpeechAdaptation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides "hints" to the speech recognizer to favor specific words and phrases
   * in the results. Phrase sets can be specified as an inline resource, or a
   * reference to an existing phrase set resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.SpeechAdaptation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.SpeechAdaptation)
      com.google.cloud.speech.v2.SpeechAdaptationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechAdaptation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechAdaptation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.SpeechAdaptation.class,
              com.google.cloud.speech.v2.SpeechAdaptation.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.SpeechAdaptation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (phraseSetsBuilder_ == null) {
        phraseSets_ = java.util.Collections.emptyList();
      } else {
        phraseSets_ = null;
        phraseSetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (customClassesBuilder_ == null) {
        customClasses_ = java.util.Collections.emptyList();
      } else {
        customClasses_ = null;
        customClassesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_SpeechAdaptation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechAdaptation getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechAdaptation build() {
      com.google.cloud.speech.v2.SpeechAdaptation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.SpeechAdaptation buildPartial() {
      com.google.cloud.speech.v2.SpeechAdaptation result =
          new com.google.cloud.speech.v2.SpeechAdaptation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.speech.v2.SpeechAdaptation result) {
      if (phraseSetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          phraseSets_ = java.util.Collections.unmodifiableList(phraseSets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.phraseSets_ = phraseSets_;
      } else {
        result.phraseSets_ = phraseSetsBuilder_.build();
      }
      if (customClassesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          customClasses_ = java.util.Collections.unmodifiableList(customClasses_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.customClasses_ = customClasses_;
      } else {
        result.customClasses_ = customClassesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v2.SpeechAdaptation result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.SpeechAdaptation) {
        return mergeFrom((com.google.cloud.speech.v2.SpeechAdaptation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.SpeechAdaptation other) {
      if (other == com.google.cloud.speech.v2.SpeechAdaptation.getDefaultInstance()) return this;
      if (phraseSetsBuilder_ == null) {
        if (!other.phraseSets_.isEmpty()) {
          if (phraseSets_.isEmpty()) {
            phraseSets_ = other.phraseSets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePhraseSetsIsMutable();
            phraseSets_.addAll(other.phraseSets_);
          }
          onChanged();
        }
      } else {
        if (!other.phraseSets_.isEmpty()) {
          if (phraseSetsBuilder_.isEmpty()) {
            phraseSetsBuilder_.dispose();
            phraseSetsBuilder_ = null;
            phraseSets_ = other.phraseSets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            phraseSetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhraseSetsFieldBuilder()
                    : null;
          } else {
            phraseSetsBuilder_.addAllMessages(other.phraseSets_);
          }
        }
      }
      if (customClassesBuilder_ == null) {
        if (!other.customClasses_.isEmpty()) {
          if (customClasses_.isEmpty()) {
            customClasses_ = other.customClasses_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCustomClassesIsMutable();
            customClasses_.addAll(other.customClasses_);
          }
          onChanged();
        }
      } else {
        if (!other.customClasses_.isEmpty()) {
          if (customClassesBuilder_.isEmpty()) {
            customClassesBuilder_.dispose();
            customClassesBuilder_ = null;
            customClasses_ = other.customClasses_;
            bitField0_ = (bitField0_ & ~0x00000002);
            customClassesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCustomClassesFieldBuilder()
                    : null;
          } else {
            customClassesBuilder_.addAllMessages(other.customClasses_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet m =
                    input.readMessage(
                        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.parser(),
                        extensionRegistry);
                if (phraseSetsBuilder_ == null) {
                  ensurePhraseSetsIsMutable();
                  phraseSets_.add(m);
                } else {
                  phraseSetsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.speech.v2.CustomClass m =
                    input.readMessage(
                        com.google.cloud.speech.v2.CustomClass.parser(), extensionRegistry);
                if (customClassesBuilder_ == null) {
                  ensureCustomClassesIsMutable();
                  customClasses_.add(m);
                } else {
                  customClassesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>
        phraseSets_ = java.util.Collections.emptyList();

    private void ensurePhraseSetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        phraseSets_ =
            new java.util.ArrayList<
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>(phraseSets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet,
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder,
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder>
        phraseSetsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>
        getPhraseSetsList() {
      if (phraseSetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phraseSets_);
      } else {
        return phraseSetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public int getPhraseSetsCount() {
      if (phraseSetsBuilder_ == null) {
        return phraseSets_.size();
      } else {
        return phraseSetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet getPhraseSets(
        int index) {
      if (phraseSetsBuilder_ == null) {
        return phraseSets_.get(index);
      } else {
        return phraseSetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder setPhraseSets(
        int index, com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet value) {
      if (phraseSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseSetsIsMutable();
        phraseSets_.set(index, value);
        onChanged();
      } else {
        phraseSetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder setPhraseSets(
        int index,
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder builderForValue) {
      if (phraseSetsBuilder_ == null) {
        ensurePhraseSetsIsMutable();
        phraseSets_.set(index, builderForValue.build());
        onChanged();
      } else {
        phraseSetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder addPhraseSets(
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet value) {
      if (phraseSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseSetsIsMutable();
        phraseSets_.add(value);
        onChanged();
      } else {
        phraseSetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder addPhraseSets(
        int index, com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet value) {
      if (phraseSetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseSetsIsMutable();
        phraseSets_.add(index, value);
        onChanged();
      } else {
        phraseSetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder addPhraseSets(
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder builderForValue) {
      if (phraseSetsBuilder_ == null) {
        ensurePhraseSetsIsMutable();
        phraseSets_.add(builderForValue.build());
        onChanged();
      } else {
        phraseSetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder addPhraseSets(
        int index,
        com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder builderForValue) {
      if (phraseSetsBuilder_ == null) {
        ensurePhraseSetsIsMutable();
        phraseSets_.add(index, builderForValue.build());
        onChanged();
      } else {
        phraseSetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder addAllPhraseSets(
        java.lang.Iterable<
                ? extends com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet>
            values) {
      if (phraseSetsBuilder_ == null) {
        ensurePhraseSetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseSets_);
        onChanged();
      } else {
        phraseSetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder clearPhraseSets() {
      if (phraseSetsBuilder_ == null) {
        phraseSets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        phraseSetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public Builder removePhraseSets(int index) {
      if (phraseSetsBuilder_ == null) {
        ensurePhraseSetsIsMutable();
        phraseSets_.remove(index);
        onChanged();
      } else {
        phraseSetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder
        getPhraseSetsBuilder(int index) {
      return getPhraseSetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder
        getPhraseSetsOrBuilder(int index) {
      if (phraseSetsBuilder_ == null) {
        return phraseSets_.get(index);
      } else {
        return phraseSetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder>
        getPhraseSetsOrBuilderList() {
      if (phraseSetsBuilder_ != null) {
        return phraseSetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phraseSets_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder
        addPhraseSetsBuilder() {
      return getPhraseSetsFieldBuilder()
          .addBuilder(
              com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder
        addPhraseSetsBuilder(int index) {
      return getPhraseSetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of inline or referenced phrase sets.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet phrase_sets = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder>
        getPhraseSetsBuilderList() {
      return getPhraseSetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet,
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder,
            com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder>
        getPhraseSetsFieldBuilder() {
      if (phraseSetsBuilder_ == null) {
        phraseSetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet,
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.Builder,
                com.google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSetOrBuilder>(
                phraseSets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        phraseSets_ = null;
      }
      return phraseSetsBuilder_;
    }

    private java.util.List<com.google.cloud.speech.v2.CustomClass> customClasses_ =
        java.util.Collections.emptyList();

    private void ensureCustomClassesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        customClasses_ =
            new java.util.ArrayList<com.google.cloud.speech.v2.CustomClass>(customClasses_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.CustomClass,
            com.google.cloud.speech.v2.CustomClass.Builder,
            com.google.cloud.speech.v2.CustomClassOrBuilder>
        customClassesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.CustomClass> getCustomClassesList() {
      if (customClassesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(customClasses_);
      } else {
        return customClassesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public int getCustomClassesCount() {
      if (customClassesBuilder_ == null) {
        return customClasses_.size();
      } else {
        return customClassesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public com.google.cloud.speech.v2.CustomClass getCustomClasses(int index) {
      if (customClassesBuilder_ == null) {
        return customClasses_.get(index);
      } else {
        return customClassesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder setCustomClasses(int index, com.google.cloud.speech.v2.CustomClass value) {
      if (customClassesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomClassesIsMutable();
        customClasses_.set(index, value);
        onChanged();
      } else {
        customClassesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder setCustomClasses(
        int index, com.google.cloud.speech.v2.CustomClass.Builder builderForValue) {
      if (customClassesBuilder_ == null) {
        ensureCustomClassesIsMutable();
        customClasses_.set(index, builderForValue.build());
        onChanged();
      } else {
        customClassesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder addCustomClasses(com.google.cloud.speech.v2.CustomClass value) {
      if (customClassesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomClassesIsMutable();
        customClasses_.add(value);
        onChanged();
      } else {
        customClassesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder addCustomClasses(int index, com.google.cloud.speech.v2.CustomClass value) {
      if (customClassesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomClassesIsMutable();
        customClasses_.add(index, value);
        onChanged();
      } else {
        customClassesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder addCustomClasses(
        com.google.cloud.speech.v2.CustomClass.Builder builderForValue) {
      if (customClassesBuilder_ == null) {
        ensureCustomClassesIsMutable();
        customClasses_.add(builderForValue.build());
        onChanged();
      } else {
        customClassesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder addCustomClasses(
        int index, com.google.cloud.speech.v2.CustomClass.Builder builderForValue) {
      if (customClassesBuilder_ == null) {
        ensureCustomClassesIsMutable();
        customClasses_.add(index, builderForValue.build());
        onChanged();
      } else {
        customClassesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder addAllCustomClasses(
        java.lang.Iterable<? extends com.google.cloud.speech.v2.CustomClass> values) {
      if (customClassesBuilder_ == null) {
        ensureCustomClassesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customClasses_);
        onChanged();
      } else {
        customClassesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder clearCustomClasses() {
      if (customClassesBuilder_ == null) {
        customClasses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        customClassesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public Builder removeCustomClasses(int index) {
      if (customClassesBuilder_ == null) {
        ensureCustomClassesIsMutable();
        customClasses_.remove(index);
        onChanged();
      } else {
        customClassesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public com.google.cloud.speech.v2.CustomClass.Builder getCustomClassesBuilder(int index) {
      return getCustomClassesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public com.google.cloud.speech.v2.CustomClassOrBuilder getCustomClassesOrBuilder(int index) {
      if (customClassesBuilder_ == null) {
        return customClasses_.get(index);
      } else {
        return customClassesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v2.CustomClassOrBuilder>
        getCustomClassesOrBuilderList() {
      if (customClassesBuilder_ != null) {
        return customClassesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(customClasses_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public com.google.cloud.speech.v2.CustomClass.Builder addCustomClassesBuilder() {
      return getCustomClassesFieldBuilder()
          .addBuilder(com.google.cloud.speech.v2.CustomClass.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public com.google.cloud.speech.v2.CustomClass.Builder addCustomClassesBuilder(int index) {
      return getCustomClassesFieldBuilder()
          .addBuilder(index, com.google.cloud.speech.v2.CustomClass.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of inline custom classes. Existing custom class resources can be
     * referenced directly in a phrase set.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.CustomClass custom_classes = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.CustomClass.Builder>
        getCustomClassesBuilderList() {
      return getCustomClassesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.CustomClass,
            com.google.cloud.speech.v2.CustomClass.Builder,
            com.google.cloud.speech.v2.CustomClassOrBuilder>
        getCustomClassesFieldBuilder() {
      if (customClassesBuilder_ == null) {
        customClassesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v2.CustomClass,
                com.google.cloud.speech.v2.CustomClass.Builder,
                com.google.cloud.speech.v2.CustomClassOrBuilder>(
                customClasses_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        customClasses_ = null;
      }
      return customClassesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.SpeechAdaptation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.SpeechAdaptation)
  private static final com.google.cloud.speech.v2.SpeechAdaptation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.SpeechAdaptation();
  }

  public static com.google.cloud.speech.v2.SpeechAdaptation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeechAdaptation> PARSER =
      new com.google.protobuf.AbstractParser<SpeechAdaptation>() {
        @java.lang.Override
        public SpeechAdaptation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeechAdaptation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeechAdaptation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechAdaptation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
