/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

public interface OperationMetadataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.speech.v2.OperationMetadata)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The resource path for the target of the operation.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The resource.
   */
  java.lang.String getResource();
  /**
   *
   *
   * <pre>
   * The resource path for the target of the operation.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The bytes for resource.
   */
  com.google.protobuf.ByteString getResourceBytes();

  /**
   *
   *
   * <pre>
   * The method that triggered the operation.
   * </pre>
   *
   * <code>string method = 4;</code>
   *
   * @return The method.
   */
  java.lang.String getMethod();
  /**
   *
   *
   * <pre>
   * The method that triggered the operation.
   * </pre>
   *
   * <code>string method = 4;</code>
   *
   * @return The bytes for method.
   */
  com.google.protobuf.ByteString getMethodBytes();

  /**
   *
   *
   * <pre>
   * The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();
  /**
   *
   *
   * <pre>
   * The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyVersionName.
   */
  java.lang.String getKmsKeyVersionName();
  /**
   *
   *
   * <pre>
   * The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  com.google.protobuf.ByteString getKmsKeyVersionNameBytes();

  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   *
   * @return Whether the batchRecognizeRequest field is set.
   */
  boolean hasBatchRecognizeRequest();
  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   *
   * @return The batchRecognizeRequest.
   */
  com.google.cloud.speech.v2.BatchRecognizeRequest getBatchRecognizeRequest();
  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   */
  com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder getBatchRecognizeRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   *
   * @return Whether the createRecognizerRequest field is set.
   */
  boolean hasCreateRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   *
   * @return The createRecognizerRequest.
   */
  com.google.cloud.speech.v2.CreateRecognizerRequest getCreateRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   */
  com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder getCreateRecognizerRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   *
   * @return Whether the updateRecognizerRequest field is set.
   */
  boolean hasUpdateRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   *
   * @return The updateRecognizerRequest.
   */
  com.google.cloud.speech.v2.UpdateRecognizerRequest getUpdateRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   */
  com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder getUpdateRecognizerRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   *
   * @return Whether the deleteRecognizerRequest field is set.
   */
  boolean hasDeleteRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   *
   * @return The deleteRecognizerRequest.
   */
  com.google.cloud.speech.v2.DeleteRecognizerRequest getDeleteRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   */
  com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder getDeleteRecognizerRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   *
   * @return Whether the undeleteRecognizerRequest field is set.
   */
  boolean hasUndeleteRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   *
   * @return The undeleteRecognizerRequest.
   */
  com.google.cloud.speech.v2.UndeleteRecognizerRequest getUndeleteRecognizerRequest();
  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   */
  com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder
      getUndeleteRecognizerRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   *
   * @return Whether the createCustomClassRequest field is set.
   */
  boolean hasCreateCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   *
   * @return The createCustomClassRequest.
   */
  com.google.cloud.speech.v2.CreateCustomClassRequest getCreateCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   */
  com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder
      getCreateCustomClassRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   *
   * @return Whether the updateCustomClassRequest field is set.
   */
  boolean hasUpdateCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   *
   * @return The updateCustomClassRequest.
   */
  com.google.cloud.speech.v2.UpdateCustomClassRequest getUpdateCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   */
  com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder
      getUpdateCustomClassRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   *
   * @return Whether the deleteCustomClassRequest field is set.
   */
  boolean hasDeleteCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   *
   * @return The deleteCustomClassRequest.
   */
  com.google.cloud.speech.v2.DeleteCustomClassRequest getDeleteCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   */
  com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder
      getDeleteCustomClassRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   *
   * @return Whether the undeleteCustomClassRequest field is set.
   */
  boolean hasUndeleteCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   *
   * @return The undeleteCustomClassRequest.
   */
  com.google.cloud.speech.v2.UndeleteCustomClassRequest getUndeleteCustomClassRequest();
  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   */
  com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder
      getUndeleteCustomClassRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   *
   * @return Whether the createPhraseSetRequest field is set.
   */
  boolean hasCreatePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   *
   * @return The createPhraseSetRequest.
   */
  com.google.cloud.speech.v2.CreatePhraseSetRequest getCreatePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   */
  com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder getCreatePhraseSetRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   *
   * @return Whether the updatePhraseSetRequest field is set.
   */
  boolean hasUpdatePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   *
   * @return The updatePhraseSetRequest.
   */
  com.google.cloud.speech.v2.UpdatePhraseSetRequest getUpdatePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   */
  com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder getUpdatePhraseSetRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   *
   * @return Whether the deletePhraseSetRequest field is set.
   */
  boolean hasDeletePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   *
   * @return The deletePhraseSetRequest.
   */
  com.google.cloud.speech.v2.DeletePhraseSetRequest getDeletePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   */
  com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder getDeletePhraseSetRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   *
   * @return Whether the undeletePhraseSetRequest field is set.
   */
  boolean hasUndeletePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   *
   * @return The undeletePhraseSetRequest.
   */
  com.google.cloud.speech.v2.UndeletePhraseSetRequest getUndeletePhraseSetRequest();
  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   */
  com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder
      getUndeletePhraseSetRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21;</code>
   *
   * @return Whether the updateConfigRequest field is set.
   */
  boolean hasUpdateConfigRequest();
  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21;</code>
   *
   * @return The updateConfigRequest.
   */
  com.google.cloud.speech.v2.UpdateConfigRequest getUpdateConfigRequest();
  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21;</code>
   */
  com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder getUpdateConfigRequestOrBuilder();

  /**
   *
   *
   * <pre>
   * The percent progress of the Operation. Values can range from 0-100. If the
   * value is 100, then the operation is finished.
   * </pre>
   *
   * <code>int32 progress_percent = 22;</code>
   *
   * @return The progressPercent.
   */
  int getProgressPercent();

  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   *
   * @return Whether the batchRecognizeMetadata field is set.
   */
  boolean hasBatchRecognizeMetadata();
  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   *
   * @return The batchRecognizeMetadata.
   */
  com.google.cloud.speech.v2.BatchRecognizeMetadata getBatchRecognizeMetadata();
  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   */
  com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder getBatchRecognizeMetadataOrBuilder();

  public com.google.cloud.speech.v2.OperationMetadata.RequestCase getRequestCase();

  public com.google.cloud.speech.v2.OperationMetadata.MetadataCase getMetadataCase();
}
