/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

package com.google.cloud.speech.v2;

public interface PhraseSetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.speech.v2.PhraseSet)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PhraseSet.
   * Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PhraseSet.
   * Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. System-assigned unique identifier for the PhraseSet.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. System-assigned unique identifier for the PhraseSet.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.PhraseSet.Phrase phrases = 3;</code>
   */
  java.util.List<com.google.cloud.speech.v2.PhraseSet.Phrase> getPhrasesList();
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.PhraseSet.Phrase phrases = 3;</code>
   */
  com.google.cloud.speech.v2.PhraseSet.Phrase getPhrases(int index);
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.PhraseSet.Phrase phrases = 3;</code>
   */
  int getPhrasesCount();
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.PhraseSet.Phrase phrases = 3;</code>
   */
  java.util.List<? extends com.google.cloud.speech.v2.PhraseSet.PhraseOrBuilder>
      getPhrasesOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of word and phrases.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.PhraseSet.Phrase phrases = 3;</code>
   */
  com.google.cloud.speech.v2.PhraseSet.PhraseOrBuilder getPhrasesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Hint Boost. Positive value will increase the probability that a specific
   * phrase will be recognized over other similar sounding phrases. The higher
   * the boost, the higher the chance of false positive recognition as well.
   * Valid `boost` values are between 0 (exclusive) and 20. We recommend using a
   * binary search approach to finding the optimal value for your use case as
   * well as adding phrases both with and without boost to your requests.
   * </pre>
   *
   * <code>float boost = 4;</code>
   *
   * @return The boost.
   */
  float getBoost();

  /**
   *
   *
   * <pre>
   * User-settable, human-readable name for the PhraseSet. Must be 63
   * characters or less.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * User-settable, human-readable name for the PhraseSet. Must be 63
   * characters or less.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The PhraseSet lifecycle state.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.PhraseSet.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The PhraseSet lifecycle state.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.PhraseSet.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.speech.v2.PhraseSet.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The most recent time this resource was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this resource was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this resource was modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource was requested for deletion.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which this resource will be purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 10;</code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 10;</code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 10;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 10;</code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Allows users to store small amounts of arbitrary data.
   * Both the key and the value must be 63 characters or less each.
   * At most 100 annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 10;</code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields. This may be sent on update, undelete, and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields. This may be sent on update, undelete, and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Output only. Whether or not this PhraseSet is in the process of being
   * updated.
   * </pre>
   *
   * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  boolean getReconciling();

  /**
   *
   *
   * <pre>
   * Output only. The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the PhraseSet is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>
   * string kms_key_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the PhraseSet is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>
   * string kms_key_name = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which the PhraseSet is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>
   * string kms_key_version_name = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyVersionName.
   */
  java.lang.String getKmsKeyVersionName();
  /**
   *
   *
   * <pre>
   * Output only. The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which the PhraseSet is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>
   * string kms_key_version_name = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  com.google.protobuf.ByteString getKmsKeyVersionNameBytes();
}
