/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.util.ArrayValueMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Types;
import com.google.api.client.xml.GenericXml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml {
    static final String TEXT_CONTENT = "text()";
    private static XmlPullParserFactory factory;

    private static synchronized XmlPullParserFactory getParserFactory() throws XmlPullParserException {
        if (factory == null) {
            factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            factory.setNamespaceAware(true);
        }
        return factory;
    }

    public static XmlSerializer createSerializer() {
        try {
            return Xml.getParserFactory().newSerializer();
        }
        catch (XmlPullParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XmlPullParser createParser() throws XmlPullParserException {
        return Xml.getParserFactory().newPullParser();
    }

    public static String toStringOf(Object element) {
        return new XmlNamespaceDictionary().toStringOf(null, element);
    }

    private static void parseAttributeOrTextContent(String stringValue, Field field, Type valueType, List<Type> context, Object destination, GenericXml genericXml, Map<String, Object> destinationMap, String name) {
        if (field != null || genericXml != null || destinationMap != null) {
            valueType = field == null ? valueType : field.getGenericType();
            Object value = Xml.parseValue(valueType, context, stringValue);
            Xml.setValue(value, field, destination, genericXml, destinationMap, name);
        }
    }

    private static void setValue(Object value, Field field, Object destination, GenericXml genericXml, Map<String, Object> destinationMap, String name) {
        if (field != null) {
            FieldInfo.setFieldValue(field, destination, value);
        } else if (genericXml != null) {
            genericXml.set(name, value);
        } else {
            destinationMap.put(name, value);
        }
    }

    public static void parseElement(XmlPullParser parser, Object destination, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        ArrayList<Type> context = new ArrayList<Type>();
        context.add(destination.getClass());
        Xml.parseElementInternal(parser, context, destination, null, namespaceDictionary, customizeParser);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean parseElementInternal(XmlPullParser parser, ArrayList<Type> context, Object destination, Type valueType, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        genericXml = destination instanceof GenericXml != false ? (GenericXml)destination : null;
        destinationMap = genericXml == null && destination instanceof Map != false ? (Map)Map.class.cast(destination) : null;
        classInfo = destinationMap != null || destination == null ? null : ClassInfo.of(destination.getClass());
        eventType = parser.getEventType();
        if (parser.getEventType() == 0) {
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new IllegalArgumentException("expected start of XML element, but got something else (event type " + eventType + ")");
        }
        depth = parser.getDepth();
        nsStart = parser.getNamespaceCount(depth - 1);
        nsEnd = parser.getNamespaceCount(depth);
        for (i = nsStart; i < nsEnd; ++i) {
            namespace = parser.getNamespaceUri(i);
            if (namespaceDictionary.getAliasForUri(namespace) != null) continue;
            prefix = parser.getNamespacePrefix(i);
            alias = originalAlias = prefix == null ? "" : prefix;
            suffix = 1;
            while (namespaceDictionary.getUriForAlias(alias) != null) {
                alias = originalAlias + ++suffix;
            }
            namespaceDictionary.set(alias, namespace);
        }
        if (genericXml != null) {
            genericXml.namespaceDictionary = namespaceDictionary;
            name = parser.getName();
            namespace = parser.getNamespace();
            alias = namespaceDictionary.getAliasForUri(namespace);
            v0 = genericXml.name = alias.length() == 0 ? name : alias + ":" + name;
        }
        if (destination != null) {
            attributeCount = parser.getAttributeCount();
            for (i = 0; i < attributeCount; ++i) {
                attributeName = parser.getAttributeName(i);
                attributeNamespace = parser.getAttributeNamespace(i);
                attributeAlias = attributeNamespace.length() == 0 ? "" : namespaceDictionary.getAliasForUri(attributeNamespace);
                fieldName = Xml.getFieldName(true, attributeAlias, attributeNamespace, attributeName);
                field = classInfo == null ? null : classInfo.getField(fieldName);
                Xml.parseAttributeOrTextContent(parser.getAttributeValue(i), field, valueType, context, destination, genericXml, destinationMap, fieldName);
            }
        }
        arrayValueMap = new ArrayValueMap(destination);
        isStopped = false;
        block15: while (true) {
            event = parser.next();
            switch (event) {
                case 1: {
                    isStopped = true;
                    break block15;
                }
                case 3: {
                    isStopped = customizeParser != null && customizeParser.stopAfterEndTag(parser.getNamespace(), parser.getName()) != false;
                    break block15;
                }
                case 4: {
                    if (destination == null) ** GOTO lbl190
                    field = classInfo == null ? null : classInfo.getField("text()");
                    Xml.parseAttributeOrTextContent(parser.getText(), field, valueType, context, destination, genericXml, destinationMap, "text()");
                    ** GOTO lbl190
                }
                case 2: {
                    if (customizeParser != null && customizeParser.stopBeforeStartTag(parser.getNamespace(), parser.getName())) {
                        isStopped = true;
                        break block15;
                    }
                    if (destination == null) {
                        Xml.parseTextContentForElement(parser, context, true, null);
                    } else {
                        namespace = parser.getNamespace();
                        alias = namespaceDictionary.getAliasForUri(namespace);
                        fieldName = Xml.getFieldName(false, alias, namespace, parser.getName());
                        field = classInfo == null ? null : classInfo.getField(fieldName);
                        fieldType = field == null ? valueType : field.getGenericType();
                        fieldType = Data.resolveWildcardTypeOrTypeVariable(context, fieldType);
                        v1 = fieldClass = fieldType instanceof Class != false ? (Class<?>)fieldType : null;
                        if (fieldType instanceof ParameterizedType) {
                            fieldClass = Types.getRawClass((ParameterizedType)fieldType);
                        }
                        isArray = Types.isArray(fieldType);
                        v2 = ignore = field == null && destinationMap == null && genericXml == null;
                        if (ignore || Data.isPrimitive(fieldType)) {
                            level = 1;
                            while (level != 0) {
                                switch (parser.next()) {
                                    case 1: {
                                        isStopped = true;
                                        break block15;
                                    }
                                    case 2: {
                                        ++level;
                                        break;
                                    }
                                    case 3: {
                                        --level;
                                        break;
                                    }
                                    case 4: {
                                        if (ignore || level != 1) break;
                                        Xml.parseAttributeOrTextContent(parser.getText(), field, valueType, context, destination, genericXml, destinationMap, fieldName);
                                    }
                                }
                            }
                        } else if (fieldType == null || fieldClass != null && Types.isAssignableToOrFrom(fieldClass, Map.class)) {
                            mapValue = Data.newMapInstance(fieldClass);
                            contextSize = context.size();
                            if (fieldType != null) {
                                context.add(fieldType);
                            }
                            subValueType = fieldType != null && Map.class.isAssignableFrom(fieldClass) != false ? Types.getMapValueParameter(fieldType) : null;
                            subValueType = Data.resolveWildcardTypeOrTypeVariable(context, subValueType);
                            isStopped = Xml.parseElementInternal(parser, context, mapValue, subValueType, namespaceDictionary, customizeParser);
                            if (fieldType != null) {
                                context.remove(contextSize);
                            }
                            if (destinationMap != null) {
                                list = (ArrayList<Map<String, Object>>)destinationMap.get(fieldName);
                                if (list == null) {
                                    list = new ArrayList<Map<String, Object>>(1);
                                    destinationMap.put(fieldName, list);
                                }
                                list.add(mapValue);
                            } else if (field != null) {
                                fieldInfo = FieldInfo.of(field);
                                if (fieldClass == Object.class) {
                                    list /* !! */  = (Collection)fieldInfo.getValue(destination);
                                    if (list /* !! */  == null) {
                                        list /* !! */  = new ArrayList<E>(1);
                                        fieldInfo.setValue(destination, list /* !! */ );
                                    }
                                    list /* !! */ .add(mapValue);
                                } else {
                                    fieldInfo.setValue(destination, mapValue);
                                }
                            } else {
                                atom = (GenericXml)destination;
                                list /* !! */  = (ArrayList<Map<String, Object>>)atom.get(fieldName);
                                if (list /* !! */  == null) {
                                    list /* !! */  = new ArrayList<Map<String, Object>>(1);
                                    atom.set(fieldName, list /* !! */ );
                                }
                                list /* !! */ .add(mapValue);
                            }
                        } else if (isArray || Types.isAssignableToOrFrom(fieldClass, Collection.class)) {
                            fieldInfo = FieldInfo.of(field);
                            elementValue = null;
                            subFieldType = isArray != false ? Types.getArrayComponentType(fieldType) : Types.getIterableParameter(fieldType);
                            rawArrayComponentType = Types.getRawArrayComponentType(context, subFieldType);
                            subFieldType = Data.resolveWildcardTypeOrTypeVariable(context, subFieldType);
                            v3 = subFieldClass = subFieldType instanceof Class != false ? (Class<?>)subFieldType : null;
                            if (subFieldType instanceof ParameterizedType) {
                                subFieldClass = Types.getRawClass((ParameterizedType)subFieldType);
                            }
                            if (Data.isPrimitive(subFieldType)) {
                                elementValue = Xml.parseTextContentForElement(parser, context, false, subFieldType);
                            } else if (subFieldType == null || subFieldClass != null && Types.isAssignableToOrFrom(subFieldClass, Map.class)) {
                                elementValue = Data.newMapInstance(subFieldClass);
                                contextSize = context.size();
                                if (subFieldType != null) {
                                    context.add(subFieldType);
                                }
                                subValueType = subFieldType != null && Map.class.isAssignableFrom(subFieldClass) != false ? Types.getMapValueParameter(subFieldType) : null;
                                subValueType = Data.resolveWildcardTypeOrTypeVariable(context, subValueType);
                                isStopped = Xml.parseElementInternal(parser, context, elementValue, subValueType, namespaceDictionary, customizeParser);
                                if (subFieldType != null) {
                                    context.remove(contextSize);
                                }
                            } else {
                                elementValue = Types.newInstance(rawArrayComponentType);
                                contextSize = context.size();
                                context.add(fieldType);
                                isStopped = Xml.parseElementInternal(parser, context, elementValue, null, namespaceDictionary, customizeParser);
                                context.remove(contextSize);
                            }
                            if (isArray) {
                                if (field == null) {
                                    arrayValueMap.put(fieldName, rawArrayComponentType, elementValue);
                                } else {
                                    arrayValueMap.put(field, rawArrayComponentType, elementValue);
                                }
                            } else {
                                collectionValue = (Collection<Object>)(field == null ? destinationMap.get(fieldName) : fieldInfo.getValue(destination));
                                if (collectionValue == null) {
                                    collectionValue = Data.newCollectionInstance(fieldType);
                                    Xml.setValue(collectionValue, field, destination, genericXml, destinationMap, fieldName);
                                }
                                collectionValue.add(elementValue);
                            }
                        } else {
                            value = Types.newInstance(fieldClass);
                            contextSize = context.size();
                            context.add(fieldType);
                            isStopped = Xml.parseElementInternal(parser, context, value, null, namespaceDictionary, customizeParser);
                            context.remove(contextSize);
                            Xml.setValue(value, field, destination, genericXml, destinationMap, fieldName);
                        }
                    }
                    if (isStopped || parser.getEventType() == 1) {
                        isStopped = true;
                        break block15;
                    }
                }
lbl190:
                // 5 sources

                default: {
                    continue block15;
                }
            }
            break;
        }
        arrayValueMap.setValues();
        return isStopped;
    }

    private static String getFieldName(boolean isAttribute, String alias, String namespace, String name) {
        if (!isAttribute && alias.length() == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder(2 + alias.length() + name.length());
        if (isAttribute) {
            buf.append('@');
        }
        if (alias != "") {
            buf.append(alias).append(':');
        }
        return buf.append(name).toString();
    }

    private static Object parseTextContentForElement(XmlPullParser parser, List<Type> context, boolean ignoreTextContent, Type textContentType) throws XmlPullParserException, IOException {
        Object result = null;
        int level = 1;
        while (level != 0) {
            switch (parser.next()) {
                case 1: {
                    level = 0;
                    break;
                }
                case 2: {
                    ++level;
                    break;
                }
                case 3: {
                    --level;
                    break;
                }
                case 4: {
                    if (ignoreTextContent || level != 1) break;
                    result = Xml.parseValue(textContentType, context, parser.getText());
                }
            }
        }
        return result;
    }

    private static Object parseValue(Type valueType, List<Type> context, String value) {
        if ((valueType = Data.resolveWildcardTypeOrTypeVariable(context, valueType)) == Double.class || valueType == Double.TYPE) {
            if (value.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        if (valueType == Float.class || valueType == Float.TYPE) {
            if (value.equals("INF")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return Data.parsePrimitiveValue(valueType, value);
    }

    private Xml() {
    }

    public static class CustomizeParser {
        public boolean stopBeforeStartTag(String namespace, String localName) {
            return false;
        }

        public boolean stopAfterEndTag(String namespace, String localName) {
            return false;
        }
    }
}

