/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.rpc2.JsonRpcRequest;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleJsonRpcHttpTransport {
    public GenericUrl rpcServerUrl;
    public HttpTransport transport;
    public JsonFactory jsonFactory;
    public String contentType;
    public String accept;

    public GoogleJsonRpcHttpTransport() {
        this.accept = this.contentType = "application/json-rpc";
    }

    public HttpRequest buildPostRequest(JsonRpcRequest request) {
        return this.internalExecute(request);
    }

    public HttpRequest buildPostRequest(List<JsonRpcRequest> requests) {
        return this.internalExecute(requests);
    }

    private HttpRequest internalExecute(Object data) {
        JsonHttpContent content = new JsonHttpContent();
        content.jsonFactory = this.jsonFactory;
        content.contentType = this.contentType;
        content.data = data;
        try {
            HttpRequest httpRequest = this.transport.createRequestFactory().buildPostRequest(this.rpcServerUrl, (HttpContent)content);
            httpRequest.headers.accept = this.accept;
            return httpRequest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

