/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.GoogleUrl;
import com.google.api.client.googleapis.json.DiscoveryDocument;
import com.google.api.client.googleapis.json.JsonCParser;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.common.base.Preconditions;
import java.io.IOException;

@Deprecated
public final class GoogleApi {
    public String name;
    public String version;
    public HttpTransport transport;
    public DiscoveryDocument.ServiceDefinition serviceDefinition;
    public GoogleUrl discoveryUrl = new GoogleUrl("https://www.googleapis.com/discovery/0.1/describe");
    public HttpTransport discoveryTransport;
    public JsonFactory jsonFactory;

    public void load() throws IOException {
        GoogleUrl url = this.discoveryUrl.clone();
        url.put("api", this.name);
        HttpRequest request = this.discoveryTransport.createRequestFactory().buildGetRequest((GenericUrl)url);
        JsonParser parser = JsonCParser.parserForResponse(this.jsonFactory, request.execute());
        parser.skipToKey(this.name);
        DiscoveryDocument doc = new DiscoveryDocument();
        DiscoveryDocument.APIDefinition apiDefinition = doc.apiDefinition;
        parser.parseAndClose((Object)apiDefinition, null);
        this.serviceDefinition = (DiscoveryDocument.ServiceDefinition)doc.apiDefinition.get(this.version);
        Preconditions.checkNotNull((Object)this.serviceDefinition, (String)"version not found: %s", (Object[])new Object[]{this.version});
    }

    public HttpRequest buildRequest(String fullyQualifiedMethodName, Object parameters) throws IOException {
        Preconditions.checkNotNull((Object)this.name);
        Preconditions.checkNotNull((Object)this.version);
        Preconditions.checkNotNull((Object)this.discoveryTransport);
        Preconditions.checkNotNull((Object)fullyQualifiedMethodName);
        if (this.serviceDefinition == null) {
            this.load();
        }
        DiscoveryDocument.ServiceMethod method = this.serviceDefinition.getResourceMethod(fullyQualifiedMethodName);
        Preconditions.checkNotNull((Object)method, (String)"method not found: %s", (Object[])new Object[]{fullyQualifiedMethodName});
        HttpRequest request = this.discoveryTransport.buildRequest();
        request.method = HttpMethod.valueOf((String)method.httpMethod);
        request.url = GoogleUrl.create(this.serviceDefinition.baseUrl, method.pathUrl, parameters);
        return request;
    }
}

