/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodOverride
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    private final EnumSet<HttpMethod> override;

    public MethodOverride() {
        this.override = EnumSet.noneOf(HttpMethod.class);
    }

    public MethodOverride(EnumSet<HttpMethod> override) {
        this.override = override.clone();
    }

    public void initialize(HttpRequest request) {
        request.interceptor = this;
    }

    public void intercept(HttpRequest request) throws IOException {
        if (this.overrideThisMethod(request)) {
            HttpMethod method = request.method;
            request.method = HttpMethod.POST;
            request.headers.set("X-HTTP-Method-Override", (Object)method.name());
            if (request.content == null || request.content.getLength() == 0L) {
                request.content = new ByteArrayContent(" ");
            }
        }
    }

    private boolean overrideThisMethod(HttpRequest request) {
        HttpMethod method = request.method;
        if (method != HttpMethod.GET && method != HttpMethod.POST && this.override.contains(method)) {
            return true;
        }
        switch (method) {
            case PATCH: {
                return !request.transport.supportsPatch();
            }
            case HEAD: {
                return !request.transport.supportsHead();
            }
        }
        return false;
    }
}

