/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import java.net.URI;
import java.net.URISyntaxException;

public class AuthorizationResponse
extends GenericData {
    @Key
    public String code;
    @Key(value="access_token")
    public String accessToken;
    @Key(value="expires_in")
    public Long expiresIn;
    @Key
    public String scope;
    @Key
    public String error;
    @Key(value="error_description")
    public String errorDescription;
    @Key(value="error_uri")
    public String errorUri;
    @Key
    public String state;

    public AuthorizationResponse(String redirectUrl) {
        try {
            URI uri = new URI(redirectUrl);
            UrlEncodedParser.parse((String)uri.getRawQuery(), (Object)((Object)this));
            UrlEncodedParser.parse((String)uri.getRawFragment(), (Object)((Object)this));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final KnownError getErrorCodeIfKnown() {
        if (this.error != null) {
            try {
                return KnownError.valueOf(this.error.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnownError {
        INVALID_REQUEST,
        INVALID_CLIENT,
        UNAUTHORIZED_CLIENT,
        REDIRECT_URI_MISMATCH,
        ACCESS_DENIED,
        UNSUPPORTED_RESPONSE_TYPE,
        INVALID_SCOPE;

    }
}

