/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.model.objects.additional.carousel;

import api.longpoll.bots.model.objects.additional.buttons.Button;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;

public class Element {
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="photo_id")
    private String photoId;
    @SerializedName(value="buttons")
    private List<Button> buttons;
    @SerializedName(value="action")
    private Action action;

    public String getTitle() {
        return this.title;
    }

    public Element setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Element setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPhotoId() {
        return this.photoId;
    }

    public Element setPhotoId(int ownerId, int mediaId) {
        this.photoId = ownerId + "_" + mediaId;
        return this;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public Element setButtons(Button ... buttons) {
        return this.setButtons(Arrays.asList(buttons));
    }

    public Element setButtons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    public Action getAction() {
        return this.action;
    }

    public Element setAction(Action action) {
        this.action = action;
        return this;
    }

    public String toString() {
        return "Element{title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", photoId='" + this.photoId + '\'' + ", buttons=" + this.buttons + ", action=" + this.action + '}';
    }

    public static abstract class Action {
        @SerializedName(value="type")
        private final String type;

        public Action(String type) {
            this.type = type;
        }

        public String toString() {
            return "Action{type='" + this.type + '\'' + '}';
        }
    }

    public static class OpenPhoto
    extends Action {
        public OpenPhoto() {
            super("open_photo");
        }
    }

    public static class OpenLink
    extends Action {
        @SerializedName(value="link")
        private String link;

        public OpenLink(String link) {
            super("open_link");
            this.link = link;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        @Override
        public String toString() {
            return "OpenLink{link='" + this.link + '\'' + "} " + super.toString();
        }
    }
}

