/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.methods.impl.upload;

import api.longpoll.bots.http.InputStreamRequestBody;
import api.longpoll.bots.http.PathRequestBody;
import api.longpoll.bots.methods.impl.VkMethod;
import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Path;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class UploadMethod<VkResponse>
extends VkMethod<VkResponse> {
    private final MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);

    public UploadMethod(String uploadUrl, String name, String filename, InputStream inputStream) {
        this(uploadUrl, name, filename, new InputStreamRequestBody(filename, inputStream));
    }

    public UploadMethod(String uploadUrl, String name, String filename, byte[] file) {
        this(uploadUrl, name, filename, RequestBody.create((byte[])file, (MediaType)MediaType.get((String)URLConnection.guessContentTypeFromName(filename))));
    }

    public UploadMethod(String uploadUrl, String name, File file) {
        this(uploadUrl, name, file.getName(), RequestBody.create((File)file, (MediaType)MediaType.get((String)URLConnection.guessContentTypeFromName(file.getName()))));
    }

    public UploadMethod(String uploadUrl, String name, Path file) {
        this(uploadUrl, name, file.getFileName().toString(), new PathRequestBody(file));
    }

    private UploadMethod(String uploadUrl, String name, String filename, RequestBody file) {
        super(uploadUrl);
        this.multipartBodyBuilder.addFormDataPart(name, filename, file);
    }

    @Override
    protected RequestBody newRequestBody() {
        return this.multipartBodyBuilder.build();
    }
}

