/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.methods.impl.messages;

import api.longpoll.bots.adapters.deserializers.SendResponseBodyDeserializer;
import api.longpoll.bots.exceptions.VkApiException;
import api.longpoll.bots.helpers.attachments.UploadableDoc;
import api.longpoll.bots.helpers.attachments.UploadableFile;
import api.longpoll.bots.helpers.attachments.UploadableFilesSupplier;
import api.longpoll.bots.helpers.attachments.UploadablePhoto;
import api.longpoll.bots.methods.impl.VkMethod;
import api.longpoll.bots.methods.impl.upload.UploadDoc;
import api.longpoll.bots.methods.impl.upload.UploadPhoto;
import api.longpoll.bots.model.objects.additional.Forward;
import api.longpoll.bots.model.objects.additional.Keyboard;
import api.longpoll.bots.model.objects.additional.Template;
import api.longpoll.bots.model.objects.additional.UploadedFile;
import api.longpoll.bots.model.response.GenericResponseBody;
import api.longpoll.bots.utils.ParamUtils;
import api.longpoll.bots.utils.VkMethods;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class Send
extends VkMethod<ResponseBody> {
    private final Gson gson = new Gson();
    private final String accessToken;
    private final UploadableFilesSupplier uploadableFilesSupplier = new UploadableFilesSupplier();

    public Send(String accessToken) {
        super(VkMethods.get("messages.send"), accessToken);
        this.accessToken = accessToken;
        this.addParam("random_id", (int)System.currentTimeMillis());
    }

    @Override
    protected Class<ResponseBody> getResponseClass() {
        return ResponseBody.class;
    }

    @Override
    public ResponseBody execute() throws VkApiException {
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        Iterator iterator = this.uploadableFilesSupplier.get().iterator();
        while (iterator.hasNext()) {
            UploadableFile messageFileUploader = (UploadableFile)iterator.next();
            uploadedFiles.add(messageFileUploader.upload());
        }
        if (!uploadedFiles.isEmpty()) {
            this.setAttachment(uploadedFiles);
        }
        return (ResponseBody)super.execute();
    }

    @Override
    public CompletableFuture<ResponseBody> executeAsync() {
        ArrayList<CompletableFuture<UploadedFile>> uploadedFiles = new ArrayList<CompletableFuture<UploadedFile>>();
        Iterator iterator = this.uploadableFilesSupplier.get().iterator();
        while (iterator.hasNext()) {
            UploadableFile messageFileUploader = (UploadableFile)iterator.next();
            uploadedFiles.add(messageFileUploader.uploadAsync());
        }
        return ((CompletableFuture)CompletableFuture.allOf(uploadedFiles.toArray(new CompletableFuture[0])).thenApply(unused -> uploadedFiles.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenCompose(attachments -> {
            if (!attachments.isEmpty()) {
                this.setAttachment((Iterable<UploadedFile>)attachments);
            }
            return super.executeAsync();
        });
    }

    public Send addPhoto(File photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, photo)));
        return this;
    }

    public Send addPhoto(Path photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, photo)));
        return this;
    }

    public Send addPhoto(String filename, InputStream photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, filename, photo)));
        return this;
    }

    public Send addPhoto(String filename, byte[] photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, filename, photo)));
        return this;
    }

    public Send addDoc(File doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, doc)));
        return this;
    }

    public Send addDoc(Path doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, doc)));
        return this;
    }

    public Send addDoc(String filename, InputStream doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, filename, doc)));
        return this;
    }

    public Send addDoc(String filename, byte[] doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, filename, doc)));
        return this;
    }

    public Send setAttachment(UploadedFile ... uploadedFiles) {
        return this.setAttachment(Arrays.asList(uploadedFiles));
    }

    public Send setAttachment(Iterable<UploadedFile> uploadedFiles) {
        return this.setAttachment(ParamUtils.csv(uploadedFiles));
    }

    public Send setAttachment(String attachment) {
        return this.addParam("attachment", attachment);
    }

    public Send setUserId(int userId) {
        this.uploadableFilesSupplier.addPeerId(userId);
        return this.addParam("user_id", userId);
    }

    public Send setRandomId(int randomId) {
        return this.addParam("random_id", randomId);
    }

    public Send setPeerId(int peerId) {
        this.uploadableFilesSupplier.addPeerId(peerId);
        return this.addParam("peer_id", peerId);
    }

    public Send setPeerIds(Integer ... peerIds) {
        return this.setPeerIds(Arrays.asList(peerIds));
    }

    public Send setPeerIds(Iterable<Integer> peerIds) {
        this.uploadableFilesSupplier.addPeerIds(peerIds);
        return this.addParam("peer_ids", ParamUtils.csv(peerIds));
    }

    public Send setDomain(String domain) {
        return this.addParam("domain", domain);
    }

    public Send setChatId(int chatId) {
        return this.addParam("chat_id", chatId);
    }

    public Send setUserIds(Integer ... userIds) {
        return this.setUserIds(Arrays.asList(userIds));
    }

    public Send setUserIds(Iterable<Integer> userIds) {
        this.uploadableFilesSupplier.addPeerIds(userIds);
        return this.addParam("user_ids", ParamUtils.csv(userIds));
    }

    public Send setMessage(String message) {
        return this.addParam("message", message);
    }

    public Send setLatitude(float latitude) {
        return this.addParam("lat", Float.valueOf(latitude));
    }

    public Send setLongitude(float longitude) {
        return this.addParam("long", Float.valueOf(longitude));
    }

    public Send setReplyTo(int replyTo) {
        return this.addParam("reply_to", replyTo);
    }

    public Send setForwardMessages(Integer ... forwardMessages) {
        return this.setForwardMessages(Arrays.asList(forwardMessages));
    }

    public Send setForwardMessages(Iterable<Integer> forwardMessages) {
        return this.addParam("forward_messages", ParamUtils.csv(forwardMessages));
    }

    public Send setStickerId(int stickerId) {
        return this.addParam("sticker_id", stickerId);
    }

    public Send setDontParseLinks(boolean dontParseLinks) {
        return this.addParam("dont_parse_links", dontParseLinks ? 1 : 0);
    }

    public Send setDisableMentions(boolean disableMentions) {
        return this.addParam("disable_mentions", disableMentions ? 1 : 0);
    }

    public Send setKeyboard(Keyboard keyboard) {
        return this.addParam("keyboard", keyboard);
    }

    public Send setTemplate(Template template) {
        return this.addParam("template", this.gson.toJson((Object)template));
    }

    public Send setForward(Forward forward) {
        return this.addParam("forward", this.gson.toJson((Object)forward));
    }

    public Send setPayload(JsonElement payload) {
        return this.addParam("payload", this.gson.toJson(payload));
    }

    public Send addParam(String key, Object value) {
        return (Send)super.addParam(key, value);
    }

    @JsonAdapter(value=SendResponseBodyDeserializer.class)
    public static class ResponseBody
    extends GenericResponseBody<Object> {

        public static class Response {
            @SerializedName(value="peer_id")
            private Integer peerId;
            @SerializedName(value="message_id")
            private Integer messageId;
            @SerializedName(value="conversation_message_id")
            private Integer conversationMessageId;
            @SerializedName(value="error")
            private JsonObject error;

            public Integer getPeerId() {
                return this.peerId;
            }

            public void setPeerId(Integer peerId) {
                this.peerId = peerId;
            }

            public Integer getMessageId() {
                return this.messageId;
            }

            public void setMessageId(Integer messageId) {
                this.messageId = messageId;
            }

            public Integer getConversationMessageId() {
                return this.conversationMessageId;
            }

            public void setConversationMessageId(Integer conversationMessageId) {
                this.conversationMessageId = conversationMessageId;
            }

            public JsonObject getError() {
                return this.error;
            }

            public void setError(JsonObject error) {
                this.error = error;
            }

            public String toString() {
                return "Response{peerId=" + this.peerId + ", messageId=" + this.messageId + ", conversationMessageId=" + this.conversationMessageId + ", error=" + this.error + '}';
            }
        }
    }
}

