/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.methods.impl.messages;

import api.longpoll.bots.exceptions.VkApiException;
import api.longpoll.bots.helpers.attachments.UploadableDoc;
import api.longpoll.bots.helpers.attachments.UploadableFile;
import api.longpoll.bots.helpers.attachments.UploadableFilesSupplier;
import api.longpoll.bots.helpers.attachments.UploadablePhoto;
import api.longpoll.bots.methods.impl.VkMethod;
import api.longpoll.bots.methods.impl.upload.UploadDoc;
import api.longpoll.bots.methods.impl.upload.UploadPhoto;
import api.longpoll.bots.model.objects.additional.Keyboard;
import api.longpoll.bots.model.objects.additional.Template;
import api.longpoll.bots.model.objects.additional.UploadedFile;
import api.longpoll.bots.model.response.IntegerResponseBody;
import api.longpoll.bots.utils.ParamUtils;
import api.longpoll.bots.utils.VkMethods;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class Edit
extends VkMethod<IntegerResponseBody> {
    private final Gson gson = new Gson();
    private final String accessToken;
    private final UploadableFilesSupplier uploadableFilesSupplier = new UploadableFilesSupplier();

    public Edit(String accessToken) {
        super(VkMethods.get("messages.edit"), accessToken);
        this.accessToken = accessToken;
    }

    @Override
    protected Class<IntegerResponseBody> getResponseClass() {
        return IntegerResponseBody.class;
    }

    @Override
    public IntegerResponseBody execute() throws VkApiException {
        ArrayList<UploadedFile> attachments = new ArrayList<UploadedFile>();
        Iterator iterator = this.uploadableFilesSupplier.get().iterator();
        while (iterator.hasNext()) {
            UploadableFile uploadableFile = (UploadableFile)iterator.next();
            attachments.add(uploadableFile.upload());
        }
        if (!attachments.isEmpty()) {
            this.setAttachment(attachments);
        }
        return (IntegerResponseBody)super.execute();
    }

    @Override
    public CompletableFuture<IntegerResponseBody> executeAsync() {
        ArrayList<CompletableFuture<UploadedFile>> uploadedFiles = new ArrayList<CompletableFuture<UploadedFile>>();
        Iterator iterator = this.uploadableFilesSupplier.get().iterator();
        while (iterator.hasNext()) {
            UploadableFile uploadableFile = (UploadableFile)iterator.next();
            uploadedFiles.add(uploadableFile.uploadAsync());
        }
        return ((CompletableFuture)CompletableFuture.allOf(uploadedFiles.toArray(new CompletableFuture[0])).thenApply(unused -> uploadedFiles.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenCompose(attachments -> {
            if (!attachments.isEmpty()) {
                this.setAttachment((Iterable<UploadedFile>)attachments);
            }
            return super.executeAsync();
        });
    }

    public Edit addPhoto(File photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, photo)));
        return this;
    }

    public Edit addPhoto(Path photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, photo)));
        return this;
    }

    public Edit addPhoto(String filename, InputStream photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, filename, photo)));
        return this;
    }

    public Edit addPhoto(String filename, byte[] photo) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadablePhoto(this.accessToken, (int)peerId, uploadUrl -> new UploadPhoto((String)uploadUrl, filename, photo)));
        return this;
    }

    public Edit addDoc(File doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, doc)));
        return this;
    }

    public Edit addDoc(Path doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, doc)));
        return this;
    }

    public Edit addDoc(String filename, InputStream doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, filename, doc)));
        return this;
    }

    public Edit addDoc(String filename, byte[] doc) {
        this.uploadableFilesSupplier.addUploadbleFileFactory(peerId -> new UploadableDoc(this.accessToken, (int)peerId, uploadUrl -> new UploadDoc((String)uploadUrl, filename, doc)));
        return this;
    }

    public Edit setAttachment(UploadedFile ... uploadedFiles) {
        return this.setAttachment(Arrays.asList(uploadedFiles));
    }

    public Edit setAttachment(Iterable<UploadedFile> uploadedFiles) {
        return this.setAttachment(ParamUtils.csv(uploadedFiles));
    }

    public Edit setAttachment(String attachment) {
        return this.addParam("attachment", attachment);
    }

    public Edit setPeerId(int peerId) {
        this.uploadableFilesSupplier.addPeerId(peerId);
        return this.addParam("peer_id", peerId);
    }

    public Edit setMessage(String message) {
        return this.addParam("message", message);
    }

    public Edit setLatitude(float latitude) {
        return this.addParam("lat", Float.valueOf(latitude));
    }

    public Edit setLongitude(float longitude) {
        return this.addParam("long", Float.valueOf(longitude));
    }

    public Edit setKeepForwardMessages(boolean keepForwardMessages) {
        return this.addParam("keep_forward_messages", keepForwardMessages ? 1 : 0);
    }

    public Edit setKeepSnippets(boolean keepSnippets) {
        return this.addParam("keep_snippets", keepSnippets ? 1 : 0);
    }

    public Edit setGroupId(int groupId) {
        return this.addParam("group_id", groupId);
    }

    public Edit setDontParseLinks(boolean dontParseLinks) {
        return this.addParam("dont_parse_links", dontParseLinks ? 1 : 0);
    }

    public Edit setMessageId(int messageId) {
        return this.addParam("message_id", messageId);
    }

    public Edit setConversationMessageId(int conversationMessageId) {
        return this.addParam("conversation_message_id", conversationMessageId);
    }

    public Edit setKeyboard(Keyboard keyboard) {
        return this.addParam("keyboard", keyboard);
    }

    public Edit setTemplate(Template template) {
        return this.addParam("template", this.gson.toJson((Object)template));
    }

    public Edit setDisableMentions(boolean disableMentions) {
        return this.addParam("disable_mentions", disableMentions ? 1 : 0);
    }

    public Edit addParam(String key, Object value) {
        return (Edit)super.addParam(key, value);
    }
}

