/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.methods.impl.groups;

import api.longpoll.bots.adapters.deserializers.BoolIntDeserializer;
import api.longpoll.bots.adapters.deserializers.IsMemberResponseBodyDeserializer;
import api.longpoll.bots.methods.impl.VkMethod;
import api.longpoll.bots.model.response.GenericResponseBody;
import api.longpoll.bots.utils.ParamUtils;
import api.longpoll.bots.utils.VkMethods;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class IsMember
extends VkMethod<ResponseBody> {
    public IsMember(String accessToken) {
        super(VkMethods.get("groups.isMember"), accessToken);
    }

    @Override
    protected Class<ResponseBody> getResponseClass() {
        return ResponseBody.class;
    }

    public IsMember setGroupId(int groupId) {
        return this.addParam("group_id", groupId);
    }

    public IsMember setUserId(int userId) {
        return this.addParam("user_id", userId);
    }

    public IsMember setUserIds(Integer ... userIds) {
        return this.setUserIds(Arrays.asList(userIds));
    }

    public IsMember setUserIds(Iterable<Integer> userIds) {
        return this.addParam("user_ids", ParamUtils.csv(userIds));
    }

    public IsMember setExtended(boolean extended) {
        return this.addParam("extended", extended ? 1 : 0);
    }

    public IsMember addParam(String key, Object value) {
        return (IsMember)super.addParam(key, value);
    }

    @JsonAdapter(value=IsMemberResponseBodyDeserializer.class)
    public static class ResponseBody
    extends GenericResponseBody<Object> {

        public static class Response {
            @SerializedName(value="member")
            @JsonAdapter(value=BoolIntDeserializer.class)
            private Boolean member;
            @SerializedName(value="request")
            @JsonAdapter(value=BoolIntDeserializer.class)
            private Boolean request;
            @SerializedName(value="invitation")
            @JsonAdapter(value=BoolIntDeserializer.class)
            private Boolean invitation;
            @SerializedName(value="can_invite")
            @JsonAdapter(value=BoolIntDeserializer.class)
            private Boolean canInvite;
            @SerializedName(value="can_recall")
            @JsonAdapter(value=BoolIntDeserializer.class)
            private Boolean canRecall;
            @SerializedName(value="user_id")
            private Integer userId;

            public Boolean getMember() {
                return this.member;
            }

            public void setMember(Boolean member) {
                this.member = member;
            }

            public Boolean getRequest() {
                return this.request;
            }

            public void setRequest(Boolean request) {
                this.request = request;
            }

            public Boolean getInvitation() {
                return this.invitation;
            }

            public void setInvitation(Boolean invitation) {
                this.invitation = invitation;
            }

            public Boolean getCanInvite() {
                return this.canInvite;
            }

            public void setCanInvite(Boolean canInvite) {
                this.canInvite = canInvite;
            }

            public Boolean getCanRecall() {
                return this.canRecall;
            }

            public void setCanRecall(Boolean canRecall) {
                this.canRecall = canRecall;
            }

            public Integer getUserId() {
                return this.userId;
            }

            public void setUserId(Integer userId) {
                this.userId = userId;
            }

            public String toString() {
                return "Response{member=" + this.member + ", request=" + this.request + ", invitation=" + this.invitation + ", canInvite=" + this.canInvite + ", canRecall=" + this.canRecall + ", userId=" + this.userId + '}';
            }
        }
    }
}

