/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.methods.impl;

import api.longpoll.bots.exceptions.VkApiException;
import api.longpoll.bots.exceptions.VkResponseException;
import api.longpoll.bots.http.LoggerInterceptor;
import api.longpoll.bots.model.objects.additional.Lang;
import api.longpoll.bots.validator.VkResponseBodyValidator;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VkMethod<VkResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VkMethod.class);
    private static final int DEFAULT_TIMEOUT = 60;
    private final Predicate<String> responseBodyValidator = new VkResponseBodyValidator();
    private final Gson gson = new Gson();
    private final Request.Builder requestBuilder = new Request.Builder();
    private final FormBody.Builder formBodyBuilder = new FormBody.Builder();
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)new LoggerInterceptor(LOGGER)).build();

    public VkMethod(String url, String accessToken) {
        this(url);
        this.addParam("access_token", accessToken);
        this.addParam("v", "5.131");
    }

    public VkMethod(String url) {
        this.requestBuilder.url(url);
    }

    public CompletableFuture<VkResponse> executeAsync() {
        final CompletableFuture completableFuture = new CompletableFuture();
        this.okHttpClient.newCall(this.newRequest()).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                completableFuture.completeExceptionally(e);
                VkMethod.this.okHttpClient.dispatcher().executorService().shutdown();
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    completableFuture.complete(VkMethod.this.extractResponse(response));
                }
                catch (VkApiException e) {
                    completableFuture.completeExceptionally(e);
                }
                VkMethod.this.okHttpClient.dispatcher().executorService().shutdown();
            }
        });
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VkResponse execute() throws VkApiException {
        try (Response response = this.okHttpClient.newCall(this.newRequest()).execute();){
            VkResponse VkResponse = this.extractResponse(response);
            return VkResponse;
        }
        catch (IOException e) {
            throw new VkApiException(e);
        }
    }

    private VkResponse extractResponse(Response response) throws VkApiException, IOException {
        if (!response.isSuccessful()) {
            throw new VkApiException("Response code: " + response.code());
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new VkApiException("Response body is null.");
        }
        String stringBody = responseBody.string();
        if (this.responseBodyValidator.negate().test(stringBody)) {
            throw new VkResponseException(stringBody);
        }
        return (VkResponse)this.gson.fromJson(stringBody, this.getResponseClass());
    }

    protected abstract Class<VkResponse> getResponseClass();

    private Request newRequest() {
        return this.requestBuilder.post(this.newRequestBody()).build();
    }

    protected RequestBody newRequestBody() {
        return this.formBodyBuilder.build();
    }

    public VkMethod<VkResponse> addParam(String key, Object value) {
        this.formBodyBuilder.add(key, String.valueOf(value));
        return this;
    }

    public VkMethod<VkResponse> setLang(Lang lang) {
        return this.addParam("lang", (Object)lang);
    }
}

