/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathRequestBody
extends RequestBody {
    private final Path path;
    private final MediaType contentType;

    public PathRequestBody(Path path) {
        this.path = path;
        this.contentType = MediaType.get((String)HttpURLConnection.guessContentTypeFromName(path.getFileName().toString()));
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        try (Source source = Okio.source((Path)this.path, (OpenOption[])new OpenOption[0]);){
            bufferedSink.writeAll(source);
        }
    }
}

