/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.http;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LoggerInterceptor
implements Interceptor {
    private final Logger logger;

    public LoggerInterceptor(Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody body = request.body();
        this.logger.debug("--> {} {} {} {}", new Object[]{request.method(), request.url() + this.getQueryParams(body), body != null ? "Content-Type: " + body.contentType() : "", body != null ? "Content-Length: " + body.contentLength() : ""});
        long start = System.currentTimeMillis();
        Response response = chain.proceed(request);
        long end = System.currentTimeMillis();
        ResponseBody responseBody = response.body();
        String stringBody = responseBody != null ? responseBody.string() : "{}";
        this.logger.debug("<-- {}ms: {} {}", new Object[]{end - start, response.code(), stringBody});
        ResponseBody responseBodyCopy = responseBody != null ? ResponseBody.create((String)stringBody, (MediaType)responseBody.contentType()) : ResponseBody.create((byte[])new byte[0], null);
        response.close();
        return response.newBuilder().body(responseBodyCopy).build();
    }

    private String getQueryParams(RequestBody requestBody) {
        FormBody formBody;
        int size;
        if (requestBody instanceof FormBody && (size = (formBody = (FormBody)requestBody).size()) > 0) {
            return "?" + IntStream.range(0, size).mapToObj(i -> formBody.encodedName(i) + "=" + formBody.encodedValue(i)).collect(Collectors.joining());
        }
        return "";
    }
}

