/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputStreamRequestBody
extends RequestBody {
    private final MediaType contentType;
    private final InputStream file;

    public InputStreamRequestBody(String filename, InputStream file) {
        this.contentType = MediaType.get((String)URLConnection.guessContentTypeFromName(filename));
        this.file = file;
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        try (Source source = Okio.source((InputStream)this.file);){
            bufferedSink.writeAll(source);
        }
    }
}

