/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.helpers.attachments;

import api.longpoll.bots.exceptions.VkApiException;
import api.longpoll.bots.helpers.attachments.UploadableFile;
import api.longpoll.bots.methods.impl.VkMethod;
import api.longpoll.bots.methods.impl.photos.GetMessagesUploadServer;
import api.longpoll.bots.methods.impl.photos.SaveMessagesPhoto;
import api.longpoll.bots.methods.impl.upload.UploadPhoto;
import api.longpoll.bots.model.objects.additional.UploadedFile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class UploadablePhoto
implements UploadableFile {
    private final GetMessagesUploadServer getMessagesUploadServer;
    private final SaveMessagesPhoto saveMessagesPhoto;
    private final Function<String, UploadPhoto> uploadPhotoFactory;

    public UploadablePhoto(String accessToken, int peerId, Function<String, UploadPhoto> uploadPhotoFactory) {
        this.getMessagesUploadServer = new GetMessagesUploadServer(accessToken).setPeerId(peerId);
        this.saveMessagesPhoto = new SaveMessagesPhoto(accessToken);
        this.uploadPhotoFactory = uploadPhotoFactory;
    }

    @Override
    public UploadedFile upload() throws VkApiException {
        String uploadUrl = ((GetMessagesUploadServer.ResponseBody.Response)((GetMessagesUploadServer.ResponseBody)this.getMessagesUploadServer.execute()).getResponse()).getUploadUrl();
        UploadPhoto.ResponseBody upload = (UploadPhoto.ResponseBody)this.uploadPhotoFactory.apply(uploadUrl).execute();
        SaveMessagesPhoto.ResponseBody.Response photo = (SaveMessagesPhoto.ResponseBody.Response)((List)((SaveMessagesPhoto.ResponseBody)this.saveMessagesPhoto.setPhoto(upload.getPhoto()).setHash(upload.getHash()).setServer(upload.getServer()).execute()).getResponse()).get(0);
        return new UploadedFile("photo", photo.getOwnerId(), photo.getId(), photo.getAccessKey());
    }

    @Override
    public CompletableFuture<UploadedFile> uploadAsync() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getMessagesUploadServer.executeAsync().thenApply(uploadServer -> ((GetMessagesUploadServer.ResponseBody.Response)uploadServer.getResponse()).getUploadUrl())).thenCompose(uploadUrl -> this.uploadPhotoFactory.apply((String)uploadUrl).executeAsync())).thenApply(upload -> this.saveMessagesPhoto.setPhoto(upload.getPhoto()).setHash(upload.getHash()).setServer(upload.getServer()))).thenCompose(VkMethod::executeAsync)).thenApply(savedPhoto -> (SaveMessagesPhoto.ResponseBody.Response)((List)savedPhoto.getResponse()).get(0))).thenApply(photo -> new UploadedFile("photo", photo.getOwnerId(), photo.getId(), photo.getAccessKey()));
    }
}

