/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.helpers.attachments;

import api.longpoll.bots.helpers.attachments.UploadableFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UploadableFilesSupplier
implements Supplier<List<UploadableFile>> {
    private final Set<Integer> peerIds = new HashSet<Integer>();
    private final List<Function<Integer, UploadableFile>> uploadableFileFactories = new ArrayList<Function<Integer, UploadableFile>>();

    public void addPeerId(int peerId) {
        this.peerIds.add(peerId);
    }

    public void addPeerIds(Iterable<Integer> peerIds) {
        StreamSupport.stream(peerIds.spliterator(), false).forEach(this::addPeerId);
    }

    public void addUploadbleFileFactory(Function<Integer, UploadableFile> uploadableFileFactory) {
        this.uploadableFileFactories.add(uploadableFileFactory);
    }

    @Override
    public List<UploadableFile> get() {
        return this.peerIds.stream().flatMap(this::getUploadableFiles).collect(Collectors.toList());
    }

    private Stream<UploadableFile> getUploadableFiles(int peerId) {
        return this.uploadableFileFactories.stream().map(messageFileUploaderFactory -> (UploadableFile)messageFileUploaderFactory.apply(peerId));
    }
}

