/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots.adapters.deserializers;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class PayloadDeserializer
implements JsonDeserializer<JsonElement> {
    private static final Gson GSON = new Gson();

    public JsonElement deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        return jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString() ? this.parseString(jsonElement) : jsonElement;
    }

    private JsonElement parseString(JsonElement jsonElement) {
        try {
            return (JsonElement)GSON.fromJson(jsonElement.getAsString(), JsonElement.class);
        }
        catch (JsonSyntaxException e) {
            return jsonElement;
        }
    }
}

