/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots;

import api.longpoll.bots.methods.VkBotsMethods;
import api.longpoll.bots.model.events.Update;
import api.longpoll.bots.model.events.boards.BoardPost;
import api.longpoll.bots.model.events.boards.BoardPostDelete;
import api.longpoll.bots.model.events.likes.Like;
import api.longpoll.bots.model.events.market.MarketComment;
import api.longpoll.bots.model.events.market.MarketCommentDelete;
import api.longpoll.bots.model.events.messages.MessageAllow;
import api.longpoll.bots.model.events.messages.MessageDeny;
import api.longpoll.bots.model.events.messages.MessageEvent;
import api.longpoll.bots.model.events.messages.MessageNew;
import api.longpoll.bots.model.events.messages.MessageTypingState;
import api.longpoll.bots.model.events.other.AppPayload;
import api.longpoll.bots.model.events.other.GroupChangePhoto;
import api.longpoll.bots.model.events.other.GroupChangeSettings;
import api.longpoll.bots.model.events.other.VkpayTransaction;
import api.longpoll.bots.model.events.photos.PhotoComment;
import api.longpoll.bots.model.events.photos.PhotoCommentDelete;
import api.longpoll.bots.model.events.poll.PollVoteNew;
import api.longpoll.bots.model.events.users.GroupJoin;
import api.longpoll.bots.model.events.users.GroupLeave;
import api.longpoll.bots.model.events.users.UserBlock;
import api.longpoll.bots.model.events.users.UserUnblock;
import api.longpoll.bots.model.events.video.VideoComment;
import api.longpoll.bots.model.events.video.VideoCommentDelete;
import api.longpoll.bots.model.events.wall.comments.WallReply;
import api.longpoll.bots.model.events.wall.comments.WallReplyDelete;
import api.longpoll.bots.model.objects.basic.MarketOrder;
import api.longpoll.bots.model.objects.basic.Message;
import api.longpoll.bots.model.objects.basic.WallPost;
import api.longpoll.bots.model.objects.media.Audio;
import api.longpoll.bots.model.objects.media.Photo;
import api.longpoll.bots.model.objects.media.Video;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VkBot {
    private static final Logger LOGGER = LoggerFactory.getLogger(VkBot.class);
    protected VkBotsMethods vk = new VkBotsMethods(this::getAccessToken);

    public abstract String getAccessToken();

    public void handle(List<Update> updates) {
        updates.forEach(update -> {
            Update.Type updateType = update.getType();
            switch (updateType) {
                case MESSAGE_NEW: {
                    this.onMessageNew((MessageNew)update.getObject());
                    break;
                }
                case MESSAGE_REPLY: {
                    this.onMessageReply((Message)update.getObject());
                    break;
                }
                case MESSAGE_EDIT: {
                    this.onMessageEdit((Message)update.getObject());
                    break;
                }
                case MESSAGE_EVENT: {
                    this.onMessageEvent((MessageEvent)update.getObject());
                    break;
                }
                case PHOTO_NEW: {
                    this.onPhotoNew((Photo)update.getObject());
                    break;
                }
                case PHOTO_COMMENT_NEW: {
                    this.onPhotoCommentNew((PhotoComment)update.getObject());
                    break;
                }
                case PHOTO_COMMENT_EDIT: {
                    this.onPhotoCommentEdit((PhotoComment)update.getObject());
                    break;
                }
                case PHOTO_COMMENT_DELETE: {
                    this.onPhotoCommentDelete((PhotoCommentDelete)update.getObject());
                    break;
                }
                case PHOTO_COMMENT_RESTORE: {
                    this.onPhotoCommentRestore((PhotoComment)update.getObject());
                    break;
                }
                case AUDIO_NEW: {
                    this.onAudioNew((Audio)update.getObject());
                    break;
                }
                case VIDEO_NEW: {
                    this.onVideoNew((Video)update.getObject());
                    break;
                }
                case VIDEO_COMMENT_NEW: {
                    this.onVideoCommentNew((VideoComment)update.getObject());
                    break;
                }
                case VIDEO_COMMENT_EDIT: {
                    this.onVideoCommentEdit((VideoComment)update.getObject());
                    break;
                }
                case VIDEO_COMMENT_DELETE: {
                    this.onVideoCommentDelete((VideoCommentDelete)update.getObject());
                    break;
                }
                case VIDEO_COMMENT_RESTORE: {
                    this.onVideoCommentRestore((VideoComment)update.getObject());
                    break;
                }
                case WALL_POST_NEW: {
                    this.onWallPostNew((WallPost)update.getObject());
                    break;
                }
                case WALL_REPOST: {
                    this.onWallRepost((WallPost)update.getObject());
                    break;
                }
                case LIKE_ADD: {
                    this.onLikeAdd((Like)update.getObject());
                    break;
                }
                case LIKE_REMOVE: {
                    this.onLikeRemove((Like)update.getObject());
                    break;
                }
                case WALL_REPLY_NEW: {
                    this.onWallReplyNew((WallReply)update.getObject());
                    break;
                }
                case WALL_REPLY_EDIT: {
                    this.onWallReplyEdit((WallReply)update.getObject());
                    break;
                }
                case WALL_REPLY_DELETE: {
                    this.onWallReplyDelete((WallReplyDelete)update.getObject());
                    break;
                }
                case WALL_REPLY_RESTORE: {
                    this.onWallReplyRestore((WallReply)update.getObject());
                    break;
                }
                case BOARD_POST_NEW: {
                    this.onBoardPostNew((BoardPost)update.getObject());
                    break;
                }
                case BOARD_POST_EDIT: {
                    this.onBoardPostEdit((BoardPost)update.getObject());
                    break;
                }
                case BOARD_POST_DELETE: {
                    this.onBoardPostDelete((BoardPostDelete)update.getObject());
                    break;
                }
                case BOARD_POST_RESTORE: {
                    this.onBoardPostRestore((BoardPost)update.getObject());
                    break;
                }
                case MARKET_COMMENT_NEW: {
                    this.onMarketCommentNew((MarketComment)update.getObject());
                    break;
                }
                case MARKET_COMMENT_EDIT: {
                    this.onMarketCommentEdit((MarketComment)update.getObject());
                    break;
                }
                case MARKET_COMMENT_RESTORE: {
                    this.onMarketCommentRestore((MarketComment)update.getObject());
                    break;
                }
                case MARKET_COMMENT_DELETE: {
                    this.onMarketCommentDelete((MarketCommentDelete)update.getObject());
                    break;
                }
                case MARKET_ORDER_NEW: {
                    this.onMarketOrderNew((MarketOrder)update.getObject());
                    break;
                }
                case MARKET_ORDER_EDIT: {
                    this.onMarketOrderEdit((MarketOrder)update.getObject());
                    break;
                }
                case GROUP_LEAVE: {
                    this.onGroupLeave((GroupLeave)update.getObject());
                    break;
                }
                case GROUP_JOIN: {
                    this.onGroupJoin((GroupJoin)update.getObject());
                    break;
                }
                case USER_BLOCK: {
                    this.onUserBlock((UserBlock)update.getObject());
                    break;
                }
                case USER_UNBLOCK: {
                    this.onUserUnblock((UserUnblock)update.getObject());
                    break;
                }
                case GROUP_CHANGE_SETTINGS: {
                    this.onGroupChangeSettings((GroupChangeSettings)update.getObject());
                    break;
                }
                case GROUP_CHANGE_PHOTO: {
                    this.onGroupChangePhoto((GroupChangePhoto)update.getObject());
                    break;
                }
                case VKPAY_TRANSACTION: {
                    this.onVkpayTransaction((VkpayTransaction)update.getObject());
                    break;
                }
                case APP_PAYLOAD: {
                    this.onAppPayload((AppPayload)update.getObject());
                    break;
                }
                case MESSAGE_TYPING_STATE: {
                    this.onMessageTypingState((MessageTypingState)update.getObject());
                    break;
                }
                case MESSAGE_ALLOW: {
                    this.onMessageAllow((MessageAllow)update.getObject());
                    break;
                }
                case MESSAGE_DENY: {
                    this.onMessageDeny((MessageDeny)update.getObject());
                    break;
                }
                case POLL_VOTE_NEW: {
                    this.onPollVoteNew((PollVoteNew)update.getObject());
                    break;
                }
                default: {
                    LOGGER.warn("No update handler found update updateType: {}", (Object)updateType);
                }
            }
        });
    }

    public void onMessageNew(MessageNew messageNew) {
    }

    public void onMessageReply(Message message) {
    }

    public void onMessageEdit(Message message) {
    }

    public void onMessageEvent(MessageEvent messageEvent) {
    }

    public void onPhotoNew(Photo photo) {
    }

    public void onPhotoCommentNew(PhotoComment photoComment) {
    }

    public void onPhotoCommentEdit(PhotoComment photoComment) {
    }

    public void onPhotoCommentDelete(PhotoCommentDelete photoCommentDelete) {
    }

    public void onPhotoCommentRestore(PhotoComment photoComment) {
    }

    public void onVideoNew(Video video) {
    }

    public void onAudioNew(Audio audio) {
    }

    public void onVideoCommentNew(VideoComment videoComment) {
    }

    public void onVideoCommentEdit(VideoComment videoComment) {
    }

    public void onVideoCommentDelete(VideoCommentDelete videoCommentDelete) {
    }

    public void onVideoCommentRestore(VideoComment videoComment) {
    }

    public void onWallPostNew(WallPost wallPost) {
    }

    public void onWallRepost(WallPost wallPost) {
    }

    public void onLikeAdd(Like like) {
    }

    public void onLikeRemove(Like like) {
    }

    public void onWallReplyNew(WallReply wallReply) {
    }

    public void onWallReplyEdit(WallReply wallReply) {
    }

    public void onWallReplyDelete(WallReplyDelete wallReplyDelete) {
    }

    public void onWallReplyRestore(WallReply wallReply) {
    }

    public void onBoardPostNew(BoardPost boardPost) {
    }

    public void onBoardPostEdit(BoardPost boardPost) {
    }

    public void onBoardPostDelete(BoardPostDelete boardPostDelete) {
    }

    public void onBoardPostRestore(BoardPost boardPost) {
    }

    public void onMarketCommentNew(MarketComment marketComment) {
    }

    public void onMarketCommentEdit(MarketComment marketComment) {
    }

    public void onMarketCommentRestore(MarketComment marketComment) {
    }

    public void onMarketCommentDelete(MarketCommentDelete marketCommentDelete) {
    }

    public void onMarketOrderNew(MarketOrder marketOrder) {
    }

    public void onMarketOrderEdit(MarketOrder marketOrder) {
    }

    public void onGroupLeave(GroupLeave groupLeave) {
    }

    public void onGroupJoin(GroupJoin groupJoin) {
    }

    public void onUserBlock(UserBlock userBlock) {
    }

    public void onUserUnblock(UserUnblock userUnblock) {
    }

    public void onGroupChangeSettings(GroupChangeSettings groupChangeSettings) {
    }

    public void onGroupChangePhoto(GroupChangePhoto groupChangePhoto) {
    }

    public void onVkpayTransaction(VkpayTransaction vkpayTransaction) {
    }

    public void onAppPayload(AppPayload appPayload) {
    }

    public void onMessageTypingState(MessageTypingState messageTypingState) {
    }

    public void onMessageAllow(MessageAllow messageAllow) {
    }

    public void onMessageDeny(MessageDeny messageDeny) {
    }

    public void onPollVoteNew(PollVoteNew pollVoteNew) {
    }
}

