/*
 * Decompiled with CFR 0.152.
 */
package api.longpoll.bots;

import api.longpoll.bots.VkBot;
import api.longpoll.bots.exceptions.VkApiException;
import api.longpoll.bots.exceptions.VkResponseException;
import api.longpoll.bots.methods.impl.events.GetUpdates;
import api.longpoll.bots.methods.impl.other.Execute;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public abstract class LongPollBot
extends VkBot {
    private static final long DEFAULT_SESSION_DURATION = 9L;
    private GetUpdates getUpdates;
    private boolean polling = true;
    private LocalDateTime initializedAt;
    private long sessionDuration = 9L;

    public void startPolling() throws VkApiException {
        this.initialize();
        while (this.polling) {
            try {
                if (this.isSessionExpired()) {
                    this.initialize();
                }
                GetUpdates.ResponseBody updates = (GetUpdates.ResponseBody)this.getUpdates.execute();
                this.getUpdates.setTs(updates.getTs());
                this.handle(updates.getEvents());
            }
            catch (VkResponseException e) {
                if (!e.getMessage().contains("failed")) {
                    throw e;
                }
                this.initialize();
            }
        }
    }

    public void stopPolling() {
        this.polling = false;
    }

    public void initialize() throws VkApiException {
        this.initializedAt = LocalDateTime.now();
        JsonObject longPollServer = ((JsonElement)((Execute.ResponseBody)this.vk.other.execute().setCode("return API.groups.getLongPollServer({\"group_id\":API.groups.getById()@.id[0]});").execute()).getResponse()).getAsJsonObject();
        this.getUpdates = new GetUpdates(longPollServer.get("server").getAsString()).setKey(longPollServer.get("key").getAsString()).setTs(longPollServer.get("ts").getAsInt());
    }

    public void setSessionDuration(long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    private boolean isSessionExpired() {
        return ChronoUnit.HOURS.between(this.initializedAt, LocalDateTime.now()) >= this.sessionDuration;
    }
}

