/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.visitor;

import com.github.vincentrussell.query.mongodb.sql.converter.holder.ExpressionHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang.mutable.MutableBoolean;

public class WhereVisitorMatchAndLookupPipelineMatchBuilder
extends ExpressionVisitorAdapter {
    private String baseAliasTable;
    private ExpressionHolder outputMatch = null;
    private final MutableBoolean haveOrExpression;
    private boolean isBaseAliasOrValue;

    public WhereVisitorMatchAndLookupPipelineMatchBuilder(String baseAliasTable, ExpressionHolder outputMatch, MutableBoolean haveOrExpression) {
        this.baseAliasTable = baseAliasTable;
        this.outputMatch = outputMatch;
        this.haveOrExpression = haveOrExpression;
    }

    private ExpressionHolder setOrAndExpression(ExpressionHolder baseExp, Expression newExp) {
        Object exp = baseExp.getExpression() != null ? new AndExpression(baseExp.getExpression(), newExp) : newExp;
        baseExp.setExpression((Expression)exp);
        return baseExp;
    }

    public void visit(Column column) {
        if (SqlUtils.isColumn((Expression)column)) {
            this.isBaseAliasOrValue = SqlUtils.isTableAliasOfColumn(column, this.baseAliasTable);
        }
    }

    public void visit(OrExpression expr) {
        this.haveOrExpression.setValue(true);
    }

    public void visit(IsNullExpression expr) {
        if (this.isBaseAliasOrValue) {
            this.setOrAndExpression(this.outputMatch, (Expression)expr);
        }
    }

    protected void visitBinaryExpression(BinaryExpression expr) {
        this.isBaseAliasOrValue = true;
        expr.getLeftExpression().accept((ExpressionVisitor)this);
        if (!this.isBaseAliasOrValue) {
            expr.getRightExpression().accept((ExpressionVisitor)this);
        } else {
            expr.getRightExpression().accept((ExpressionVisitor)this);
            if (this.isBaseAliasOrValue && !(expr instanceof AndExpression) && !(expr instanceof OrExpression)) {
                this.setOrAndExpression(this.outputMatch, (Expression)expr);
            }
        }
    }
}

