/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.holder.from;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLCommandInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLTableInfoHolder;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SubSelect;

public class FromHolder {
    private FieldType defaultFieldType;
    private Map<String, FieldType> fieldNameToFieldTypeMapping;
    private FromItem baseFrom;
    private String baseAlias;
    private Map<String, FromItem> aliasToTable = new HashMap<String, FromItem>();
    private Map<FromItem, String> tableToAlias = new HashMap<FromItem, String>();
    private Map<FromItem, SQLInfoHolder> fromToSQLHolder = new HashMap<FromItem, SQLInfoHolder>();

    public FromHolder(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
        this.defaultFieldType = defaultFieldType;
        this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
    }

    private void addToSQLHolderMap(FromItem from) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        if (from instanceof Table) {
            Table table = (Table)from;
            this.fromToSQLHolder.put((FromItem)table, new SQLTableInfoHolder(table.getName()));
        } else if (from instanceof SubSelect) {
            SubSelect subselect = (SubSelect)from;
            this.fromToSQLHolder.put(from, SQLCommandInfoHolder.Builder.create(this.defaultFieldType, this.fieldNameToFieldTypeMapping).setPlainSelect((PlainSelect)subselect.getSelectBody()).build());
        } else {
            return;
        }
    }

    private void addBaseFrom(FromItem from) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        this.baseFrom = from;
        this.addToSQLHolderMap(from);
    }

    private void addBaseFrom(FromItem from, String alias) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        this.addBaseFrom(from);
        if (alias != null) {
            this.baseAlias = alias;
            this.aliasToTable.put(alias, from);
        }
        this.tableToAlias.put(from, alias);
    }

    public void addFrom(FromItem from, String alias) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        if (this.baseFrom != null) {
            if (alias != null) {
                this.aliasToTable.put(alias, from);
            }
            this.tableToAlias.put(from, alias);
            this.addToSQLHolderMap(from);
        } else {
            this.addBaseFrom(from, alias);
        }
    }

    public String getBaseFromTableName() {
        return this.fromToSQLHolder.get(this.baseFrom).getBaseTableName();
    }

    public FromItem getBaseFrom() {
        return this.baseFrom;
    }

    public SQLInfoHolder getBaseSQLHolder() {
        return this.fromToSQLHolder.get(this.baseFrom);
    }

    public SQLInfoHolder getSQLHolder(FromItem fromItem) {
        return this.fromToSQLHolder.get(fromItem);
    }

    public String getBaseAliasTable() {
        return this.baseAlias;
    }
}

