/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.holder;

import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import java.util.HashMap;

public class AliasHolder {
    private HashMap<String, String> aliasFromFieldHash;
    private HashMap<String, String> fieldFromAliasHash;

    public AliasHolder(HashMap<String, String> aliasFromFieldMap, HashMap<String, String> fieldFromAliasMap) {
        this.aliasFromFieldHash = aliasFromFieldMap;
        this.fieldFromAliasHash = fieldFromAliasMap;
    }

    public String getAliasFromFieldExp(String field) {
        return this.aliasFromFieldHash.get(field);
    }

    public String getFieldFromAliasOrField(String fieldOrAlias) throws ParseException {
        if (!this.isAmbiguous(fieldOrAlias)) {
            String field = this.fieldFromAliasHash.get(fieldOrAlias);
            if (field == null) {
                return fieldOrAlias;
            }
            return field;
        }
        throw new ParseException("Ambiguous field: " + fieldOrAlias);
    }

    public boolean isEmpty() {
        return this.aliasFromFieldHash.isEmpty();
    }

    private boolean isAmbiguous(String fieldOrAlias) {
        String aliasFromField = this.aliasFromFieldHash.get(fieldOrAlias);
        String fieldFromAlias = this.fieldFromAliasHash.get(fieldOrAlias);
        return aliasFromField != null && fieldFromAlias != null && !aliasFromField.equals(fieldFromAlias);
    }
}

