/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutInputStream
extends InputStream {
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final InputStream inputStream;
    private final long timeout;
    private final TimeUnit timeUnit;
    private boolean receivedData = false;

    public TimeoutInputStream(InputStream inputStream, long timeout, TimeUnit timeUnit) {
        this.inputStream = inputStream;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public int read() throws IOException {
        int result = -1;
        Future<Integer> future = this.executorService.submit(new ReadNext(this.inputStream));
        try {
            result = this.getInteger(future);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            result = -1;
        }
        this.receivedData = true;
        return result;
    }

    private Integer getInteger(Future<Integer> future) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.receivedData) {
            return future.get(1L, TimeUnit.MINUTES);
        }
        return future.get(this.timeout, this.timeUnit);
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdownNow();
    }

    private static final class ReadNext
    implements Callable<Integer> {
        private final InputStream inputStream;

        private ReadNext(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public Integer call() throws Exception {
            return this.inputStream.read();
        }
    }
}

