/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.events.user.PrivateMessageEvent;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.github.twitch4j.common.util.TimeUtils;
import com.github.twitch4j.common.util.TwitchUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.pubsub.PubSubSubscription;
import com.github.twitch4j.pubsub.domain.AliasRestrictionUpdateData;
import com.github.twitch4j.pubsub.domain.AutomodCaughtMessageData;
import com.github.twitch4j.pubsub.domain.AutomodLevelsModified;
import com.github.twitch4j.pubsub.domain.BitsBadgeData;
import com.github.twitch4j.pubsub.domain.ChannelBitsData;
import com.github.twitch4j.pubsub.domain.ChannelPointsEarned;
import com.github.twitch4j.pubsub.domain.ChannelPointsRedemption;
import com.github.twitch4j.pubsub.domain.ChannelPointsReward;
import com.github.twitch4j.pubsub.domain.ChannelTermsAction;
import com.github.twitch4j.pubsub.domain.ChatModerationAction;
import com.github.twitch4j.pubsub.domain.CheerbombData;
import com.github.twitch4j.pubsub.domain.ClaimData;
import com.github.twitch4j.pubsub.domain.CommerceData;
import com.github.twitch4j.pubsub.domain.CommunityBoostProgression;
import com.github.twitch4j.pubsub.domain.CommunityGoalContribution;
import com.github.twitch4j.pubsub.domain.CreateNotificationData;
import com.github.twitch4j.pubsub.domain.CreatedUnbanRequest;
import com.github.twitch4j.pubsub.domain.CreatorGoal;
import com.github.twitch4j.pubsub.domain.FollowingData;
import com.github.twitch4j.pubsub.domain.FriendshipData;
import com.github.twitch4j.pubsub.domain.HypeLevelUp;
import com.github.twitch4j.pubsub.domain.HypeProgression;
import com.github.twitch4j.pubsub.domain.HypeTrainApproaching;
import com.github.twitch4j.pubsub.domain.HypeTrainConductor;
import com.github.twitch4j.pubsub.domain.HypeTrainEnd;
import com.github.twitch4j.pubsub.domain.HypeTrainRewardsData;
import com.github.twitch4j.pubsub.domain.HypeTrainStart;
import com.github.twitch4j.pubsub.domain.Leaderboard;
import com.github.twitch4j.pubsub.domain.LowTrustUserNewMessage;
import com.github.twitch4j.pubsub.domain.LowTrustUserTreatmentUpdate;
import com.github.twitch4j.pubsub.domain.ModeratorUnbanRequestAction;
import com.github.twitch4j.pubsub.domain.PointsSpent;
import com.github.twitch4j.pubsub.domain.PollData;
import com.github.twitch4j.pubsub.domain.PresenceData;
import com.github.twitch4j.pubsub.domain.PresenceSettings;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import com.github.twitch4j.pubsub.domain.PubSubResponse;
import com.github.twitch4j.pubsub.domain.RadioData;
import com.github.twitch4j.pubsub.domain.RedemptionProgress;
import com.github.twitch4j.pubsub.domain.SubGiftData;
import com.github.twitch4j.pubsub.domain.SubscriptionData;
import com.github.twitch4j.pubsub.domain.UpdateSummaryData;
import com.github.twitch4j.pubsub.domain.UpdatedUnbanRequest;
import com.github.twitch4j.pubsub.domain.UserAutomodCaughtMessage;
import com.github.twitch4j.pubsub.domain.UserModerationActionData;
import com.github.twitch4j.pubsub.domain.VideoPlaybackData;
import com.github.twitch4j.pubsub.enums.PubSubType;
import com.github.twitch4j.pubsub.enums.TMIConnectionState;
import com.github.twitch4j.pubsub.events.AliasRestrictionUpdateEvent;
import com.github.twitch4j.pubsub.events.AutomodCaughtMessageEvent;
import com.github.twitch4j.pubsub.events.AutomodLevelsModifiedEvent;
import com.github.twitch4j.pubsub.events.BitsLeaderboardEvent;
import com.github.twitch4j.pubsub.events.ChannelBitsBadgeUnlockEvent;
import com.github.twitch4j.pubsub.events.ChannelBitsEvent;
import com.github.twitch4j.pubsub.events.ChannelCommerceEvent;
import com.github.twitch4j.pubsub.events.ChannelSubGiftEvent;
import com.github.twitch4j.pubsub.events.ChannelSubscribeEvent;
import com.github.twitch4j.pubsub.events.ChannelTermsEvent;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestCreateEvent;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestUpdateEvent;
import com.github.twitch4j.pubsub.events.ChatModerationEvent;
import com.github.twitch4j.pubsub.events.CheerbombEvent;
import com.github.twitch4j.pubsub.events.ClaimAvailableEvent;
import com.github.twitch4j.pubsub.events.ClaimClaimedEvent;
import com.github.twitch4j.pubsub.events.CommunityBoostProgressionEvent;
import com.github.twitch4j.pubsub.events.CommunityGoalContributionEvent;
import com.github.twitch4j.pubsub.events.CreatorGoalEvent;
import com.github.twitch4j.pubsub.events.CrowdChantCreatedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardCreatedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardDeletedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardUpdatedEvent;
import com.github.twitch4j.pubsub.events.FollowingEvent;
import com.github.twitch4j.pubsub.events.FriendshipEvent;
import com.github.twitch4j.pubsub.events.HypeTrainApproachingEvent;
import com.github.twitch4j.pubsub.events.HypeTrainConductorUpdateEvent;
import com.github.twitch4j.pubsub.events.HypeTrainCooldownExpirationEvent;
import com.github.twitch4j.pubsub.events.HypeTrainEndEvent;
import com.github.twitch4j.pubsub.events.HypeTrainLevelUpEvent;
import com.github.twitch4j.pubsub.events.HypeTrainProgressionEvent;
import com.github.twitch4j.pubsub.events.HypeTrainRewardsEvent;
import com.github.twitch4j.pubsub.events.HypeTrainStartEvent;
import com.github.twitch4j.pubsub.events.LowTrustUserNewMessageEvent;
import com.github.twitch4j.pubsub.events.LowTrustUserTreatmentUpdateEvent;
import com.github.twitch4j.pubsub.events.ModUnbanRequestActionEvent;
import com.github.twitch4j.pubsub.events.OnsiteNotificationCreationEvent;
import com.github.twitch4j.pubsub.events.PointsEarnedEvent;
import com.github.twitch4j.pubsub.events.PointsSpentEvent;
import com.github.twitch4j.pubsub.events.PollsEvent;
import com.github.twitch4j.pubsub.events.PredictionCreatedEvent;
import com.github.twitch4j.pubsub.events.PredictionUpdatedEvent;
import com.github.twitch4j.pubsub.events.PresenceSettingsEvent;
import com.github.twitch4j.pubsub.events.PubSubListenResponseEvent;
import com.github.twitch4j.pubsub.events.RadioEvent;
import com.github.twitch4j.pubsub.events.RaidCancelEvent;
import com.github.twitch4j.pubsub.events.RaidGoEvent;
import com.github.twitch4j.pubsub.events.RaidUpdateEvent;
import com.github.twitch4j.pubsub.events.RedemptionStatusUpdateEvent;
import com.github.twitch4j.pubsub.events.RewardRedeemedEvent;
import com.github.twitch4j.pubsub.events.SubLeaderboardEvent;
import com.github.twitch4j.pubsub.events.UpdateOnsiteNotificationSummaryEvent;
import com.github.twitch4j.pubsub.events.UpdateRedemptionFinishedEvent;
import com.github.twitch4j.pubsub.events.UpdateRedemptionProgressEvent;
import com.github.twitch4j.pubsub.events.UserAutomodCaughtMessageEvent;
import com.github.twitch4j.pubsub.events.UserCommunityGoalContributionEvent;
import com.github.twitch4j.pubsub.events.UserModerationActionEvent;
import com.github.twitch4j.pubsub.events.UserPredictionMadeEvent;
import com.github.twitch4j.pubsub.events.UserPredictionResultEvent;
import com.github.twitch4j.pubsub.events.UserPresenceEvent;
import com.github.twitch4j.pubsub.events.UserUnbanRequestUpdateEvent;
import com.github.twitch4j.pubsub.events.VideoPlaybackEvent;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchPubSub
implements ITwitchPubSub {
    private static final Logger log = LoggerFactory.getLogger(TwitchPubSub.class);
    private final Object $lock = new Object[0];
    public static final int REQUIRED_THREAD_COUNT = 1;
    private static final Pattern LISTEN_AUTH_TOKEN = Pattern.compile("(\\{.*\"type\"\\s*?:\\s*?\"LISTEN\".*\"data\"\\s*?:\\s*?\\{.*\"auth_token\"\\s*?:\\s*?\").+(\".*}\\s*?})");
    private final EventManager eventManager;
    private static final String WEB_SOCKET_SERVER = "wss://pubsub-edge.twitch.tv:443";
    private volatile WebSocket webSocket;
    private volatile TMIConnectionState connectionState = TMIConnectionState.DISCONNECTED;
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final AtomicBoolean flushRequested = new AtomicBoolean();
    private final Runnable flushCommand;
    protected final Future<?> queueTask;
    protected final Future<?> heartbeatTask;
    protected volatile boolean isClosed = false;
    protected final BlockingQueue<String> commandQueue = new ArrayBlockingQueue<String>(200);
    protected final Set<PubSubRequest> subscribedTopics = ConcurrentHashMap.newKeySet();
    protected volatile long lastPing = TimeUtils.getCurrentTimeInMillis() - 240000L;
    protected volatile long lastPong = TimeUtils.getCurrentTimeInMillis();
    protected final ScheduledExecutorService taskExecutor;
    private final Collection<String> botOwnerIds;
    private final int wsPingPeriod;
    protected final WebSocketFactory webSocketFactory;
    protected final ExponentialBackoffStrategy backoff = ExponentialBackoffStrategy.builder().immediateFirst(false).baseMillis(Duration.ofSeconds(1L).toMillis()).jitter(true).multiplier(2.0).maximumBackoff(Duration.ofMinutes(2L).toMillis()).build();
    private volatile Future<?> backoffClearer;

    public TwitchPubSub(EventManager eventManager, ScheduledThreadPoolExecutor taskExecutor, ProxyConfig proxyConfig, Collection<String> botOwnerIds, int wsPingPeriod) {
        this.eventManager = eventManager;
        this.taskExecutor = taskExecutor;
        this.botOwnerIds = botOwnerIds;
        this.wsPingPeriod = wsPingPeriod;
        this.eventManager.getServiceMediator().addService("twitch4j-pubsub", (Object)this);
        this.webSocketFactory = new WebSocketFactory();
        if (proxyConfig != null) {
            proxyConfig.applyWs(this.webSocketFactory.getProxySettings());
        }
        this.connect();
        this.heartbeatTask = taskExecutor.scheduleAtFixedRate(() -> {
            if (this.isClosed || this.connectionState != TMIConnectionState.CONNECTED) {
                return;
            }
            PubSubRequest request = new PubSubRequest();
            request.setType(PubSubType.PING);
            this.sendCommand(TypeConvert.objectToJson((Object)request));
            log.debug("PubSub: Sending PING!");
            this.lastPing = TimeUtils.getCurrentTimeInMillis();
        }, 0L, 4L, TimeUnit.MINUTES);
        this.flushCommand = () -> {
            if (this.flushing.getAndSet(true)) {
                return;
            }
            while (!this.isClosed) {
                try {
                    String command;
                    if (this.lastPong < this.lastPing && TimeUtils.getCurrentTimeInMillis() >= this.lastPing + 10000L) {
                        log.warn("PubSub: Didn't receive a PONG response in time, reconnecting to obtain a connection to a different server.");
                        this.reconnect();
                        break;
                    }
                    if (!this.connectionState.equals((Object)TMIConnectionState.CONNECTED) || (command = (String)this.commandQueue.poll()) == null) break;
                    this.sendCommand(command);
                    if (!log.isDebugEnabled()) continue;
                    Matcher matcher = LISTEN_AUTH_TOKEN.matcher(command);
                    String cmd = matcher.find() ? matcher.group(1) + "\u2022\u2022\u2022" + matcher.group(2) : command;
                    log.debug("Processed command from queue: [{}].", (Object)cmd);
                }
                catch (Exception ex) {
                    log.error("PubSub: Unexpected error in worker thread", (Throwable)ex);
                    break;
                }
            }
            this.flushRequested.set(false);
            this.flushing.set(false);
        };
        this.queueTask = taskExecutor.scheduleWithFixedDelay(this.flushCommand, 0L, 2500L, TimeUnit.MILLISECONDS);
        log.debug("PubSub: Started Queue Worker Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.connectionState.equals((Object)TMIConnectionState.DISCONNECTED) || this.connectionState.equals((Object)TMIConnectionState.RECONNECTING)) {
                try {
                    this.connectionState = TMIConnectionState.CONNECTING;
                    this.createWebSocket();
                    this.lastPong = TimeUtils.getCurrentTimeInMillis();
                    this.lastPing = this.lastPong - 240000L;
                    this.webSocket.connect();
                }
                catch (Exception ex) {
                    log.error("PubSub: Connection to Twitch PubSub failed: {} - Retrying ...", (Object)ex.getMessage());
                    if (this.backoffClearer != null) {
                        try {
                            this.backoffClearer.cancel(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        this.backoff.sleep();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.reconnect();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.connectionState.equals((Object)TMIConnectionState.CONNECTED)) {
                this.connectionState = TMIConnectionState.DISCONNECTING;
            }
            this.connectionState = TMIConnectionState.DISCONNECTED;
            if (this.webSocket != null) {
                this.webSocket.clearListeners();
                this.webSocket.disconnect();
                this.webSocket = null;
            }
            if (this.backoffClearer != null) {
                this.backoffClearer.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.$lock;
        synchronized (object) {
            this.connectionState = TMIConnectionState.RECONNECTING;
            this.disconnect();
            this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWebSocket() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                this.webSocket = this.webSocketFactory.createSocket(WEB_SOCKET_SERVER);
                this.webSocket.setPingInterval((long)this.wsPingPeriod);
                this.webSocket.clearListeners();
                this.webSocket.addListener((WebSocketListener)new WebSocketAdapter(){

                    public void onConnected(WebSocket ws, Map<String, List<String>> headers) {
                        log.info("Connecting to Twitch PubSub {}", (Object)TwitchPubSub.WEB_SOCKET_SERVER);
                        TwitchPubSub.this.connectionState = TMIConnectionState.CONNECTED;
                        TwitchPubSub.this.backoffClearer = TwitchPubSub.this.taskExecutor.schedule(() -> {
                            if (TwitchPubSub.this.connectionState == TMIConnectionState.CONNECTED) {
                                TwitchPubSub.this.backoff.reset();
                            }
                        }, 30L, TimeUnit.SECONDS);
                        log.info("Connected to Twitch PubSub {}", (Object)TwitchPubSub.WEB_SOCKET_SERVER);
                        TwitchPubSub.this.subscribedTopics.forEach(topic -> TwitchPubSub.this.queueRequest(topic));
                    }

                    public void onTextMessage(WebSocket ws, String text) {
                        try {
                            log.trace("Received WebSocketMessage: " + text);
                            PubSubResponse message = (PubSubResponse)TypeConvert.jsonToObject((String)text, PubSubResponse.class);
                            if (message.getType().equals((Object)PubSubType.MESSAGE)) {
                                String topic = message.getData().getTopic();
                                String[] topicParts = StringUtils.split((String)topic, (char)'.');
                                String topicName = topicParts[0];
                                String lastTopicIdentifier = topicParts[topicParts.length - 1];
                                String type = message.getData().getMessage().getType();
                                JsonNode msgData = message.getData().getMessage().getMessageData();
                                String rawMessage = message.getData().getMessage().getRawMessage();
                                if ("channel-bits-events-v2".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new ChannelBitsEvent((ChannelBitsData)TypeConvert.convertValue((Object)msgData, ChannelBitsData.class)));
                                } else if ("channel-bits-badge-unlocks".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new ChannelBitsBadgeUnlockEvent((BitsBadgeData)TypeConvert.jsonToObject((String)rawMessage, BitsBadgeData.class)));
                                } else if ("channel-subscribe-events-v1".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new ChannelSubscribeEvent((SubscriptionData)TypeConvert.jsonToObject((String)rawMessage, SubscriptionData.class)));
                                } else if ("channel-commerce-events-v1".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new ChannelCommerceEvent((CommerceData)TypeConvert.jsonToObject((String)rawMessage, CommerceData.class)));
                                } else if ("whispers".equals(topicName) && (type.equals("whisper_sent") || type.equals("whisper_received"))) {
                                    JsonNode msgDataParsed = (JsonNode)TypeConvert.jsonToObject((String)msgData.asText(), JsonNode.class);
                                    Map tags = (Map)TypeConvert.convertValue((Object)msgDataParsed.path("tags"), (TypeReference)new TypeReference<Map<String, Object>>(){});
                                    String fromId = msgDataParsed.get("from_id").asText();
                                    String displayName = (String)tags.get("display_name");
                                    EventUser eventUser = new EventUser(fromId, displayName);
                                    String body = msgDataParsed.get("body").asText();
                                    Set permissions = TwitchUtils.getPermissionsFromTags((Map)tags, new HashMap(), (String)fromId, (Collection)TwitchPubSub.this.botOwnerIds);
                                    PrivateMessageEvent privateMessageEvent = new PrivateMessageEvent(eventUser, body, permissions);
                                    TwitchPubSub.this.eventManager.publish((Object)privateMessageEvent);
                                } else if ("automod-levels-modification".equals(topicName) && topicParts.length > 1) {
                                    if ("automod_levels_modified".equals(type)) {
                                        AutomodLevelsModified data = (AutomodLevelsModified)TypeConvert.convertValue((Object)msgData, AutomodLevelsModified.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new AutomodLevelsModifiedEvent(lastTopicIdentifier, data));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("automod-queue".equals(topicName)) {
                                    if (topicParts.length == 3 && "automod_caught_message".equalsIgnoreCase(type)) {
                                        AutomodCaughtMessageData data = (AutomodCaughtMessageData)TypeConvert.convertValue((Object)msgData, AutomodCaughtMessageData.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new AutomodCaughtMessageEvent(topicParts[2], data));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("community-boost-events-v1".equals(topicName)) {
                                    if ("community-boost-progression".equals(type)) {
                                        CommunityBoostProgression progression = (CommunityBoostProgression)TypeConvert.convertValue((Object)msgData, CommunityBoostProgression.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new CommunityBoostProgressionEvent(progression));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("community-points-channel-v1".equals(topicName) || "channel-points-channel-v1".equals(topicName)) {
                                    String timestampText = msgData.path("timestamp").asText();
                                    Instant instant = Instant.parse(timestampText);
                                    switch (type) {
                                        case "reward-redeemed": {
                                            ChannelPointsRedemption redemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new RewardRedeemedEvent(instant, redemption));
                                            break;
                                        }
                                        case "redemption-status-update": {
                                            ChannelPointsRedemption updatedRedemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new RedemptionStatusUpdateEvent(instant, updatedRedemption));
                                            break;
                                        }
                                        case "custom-reward-created": {
                                            ChannelPointsReward newReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("new_reward"), ChannelPointsReward.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new CustomRewardCreatedEvent(instant, newReward));
                                            break;
                                        }
                                        case "custom-reward-updated": {
                                            ChannelPointsReward updatedReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("updated_reward"), ChannelPointsReward.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new CustomRewardUpdatedEvent(instant, updatedReward));
                                            break;
                                        }
                                        case "custom-reward-deleted": {
                                            ChannelPointsReward deletedReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("deleted_reward"), ChannelPointsReward.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new CustomRewardDeletedEvent(instant, deletedReward));
                                            break;
                                        }
                                        case "update-redemption-statuses-progress": {
                                            RedemptionProgress redemptionProgress = (RedemptionProgress)TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new UpdateRedemptionProgressEvent(instant, redemptionProgress));
                                            break;
                                        }
                                        case "update-redemption-statuses-finished": {
                                            RedemptionProgress redemptionFinished = (RedemptionProgress)TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new UpdateRedemptionFinishedEvent(instant, redemptionFinished));
                                            break;
                                        }
                                        case "community-goal-contribution": {
                                            CommunityGoalContribution contribution = (CommunityGoalContribution)TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new CommunityGoalContributionEvent(instant, contribution));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("creator-goals-events-v1".equals(topicName)) {
                                    CreatorGoal creatorGoal = (CreatorGoal)TypeConvert.convertValue((Object)msgData.path("goal"), CreatorGoal.class);
                                    TwitchPubSub.this.eventManager.publish((Object)new CreatorGoalEvent(lastTopicIdentifier, type, creatorGoal));
                                } else if ("crowd-chant-channel-v1".equals(topicName)) {
                                    if ("crowd-chant-created".equals(type)) {
                                        CrowdChantCreatedEvent event = (CrowdChantCreatedEvent)((Object)TypeConvert.convertValue((Object)msgData, CrowdChantCreatedEvent.class));
                                        TwitchPubSub.this.eventManager.publish((Object)event);
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("raid".equals(topicName)) {
                                    switch (type) {
                                        case "raid_go_v2": {
                                            TwitchPubSub.this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidGoEvent.class));
                                            break;
                                        }
                                        case "raid_update_v2": {
                                            TwitchPubSub.this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidUpdateEvent.class));
                                            break;
                                        }
                                        case "raid_cancel_v2": {
                                            TwitchPubSub.this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidCancelEvent.class));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("chat_moderator_actions".equals(topicName) && topicParts.length > 1) {
                                    switch (type) {
                                        case "moderation_action": {
                                            ChatModerationAction modAction = (ChatModerationAction)TypeConvert.convertValue((Object)msgData, ChatModerationAction.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new ChatModerationEvent(lastTopicIdentifier, modAction));
                                            break;
                                        }
                                        case "channel_terms_action": {
                                            ChannelTermsAction termsAction = (ChannelTermsAction)TypeConvert.convertValue((Object)msgData, ChannelTermsAction.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new ChannelTermsEvent(lastTopicIdentifier, termsAction));
                                            break;
                                        }
                                        case "approve_unban_request": 
                                        case "deny_unban_request": {
                                            ModeratorUnbanRequestAction unbanRequestAction = (ModeratorUnbanRequestAction)TypeConvert.convertValue((Object)msgData, ModeratorUnbanRequestAction.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new ModUnbanRequestActionEvent(lastTopicIdentifier, unbanRequestAction));
                                            break;
                                        }
                                        case "moderator_added": 
                                        case "moderator_removed": 
                                        case "vip_added": 
                                        case "vip_removed": {
                                            ChatModerationAction.ModerationAction act = "moderator_added".equals(type) ? ChatModerationAction.ModerationAction.MOD : ("moderator_removed".equals(type) ? ChatModerationAction.ModerationAction.UNMOD : ("vip_added".equals(type) ? ChatModerationAction.ModerationAction.VIP : ChatModerationAction.ModerationAction.UNVIP));
                                            String targetUserId = msgData.path("target_user_id").asText();
                                            String targetUserName = msgData.path("target_user_login").asText();
                                            String createdByUserId = msgData.path("created_by_user_id").asText();
                                            String createdBy = msgData.path("created_by").asText();
                                            ChatModerationAction action = new ChatModerationAction("chat_login_moderation", act, Collections.singletonList(targetUserName), createdBy, createdByUserId, "", targetUserId, targetUserName, false);
                                            TwitchPubSub.this.eventManager.publish((Object)new ChatModerationEvent(lastTopicIdentifier, action));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("chatrooms-user-v1".equals(topicName) && topicParts.length > 1) {
                                    String userId = topicParts[1];
                                    switch (type) {
                                        case "channel_banned_alias_restriction_update": {
                                            AliasRestrictionUpdateData aliasData = (AliasRestrictionUpdateData)TypeConvert.convertValue((Object)msgData, AliasRestrictionUpdateData.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new AliasRestrictionUpdateEvent(userId, aliasData));
                                            break;
                                        }
                                        case "user_moderation_action": {
                                            UserModerationActionData actionData = (UserModerationActionData)TypeConvert.convertValue((Object)msgData, UserModerationActionData.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new UserModerationActionEvent(userId, actionData));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("following".equals(topicName) && topicParts.length > 1) {
                                    FollowingData data = (FollowingData)TypeConvert.jsonToObject((String)rawMessage, FollowingData.class);
                                    TwitchPubSub.this.eventManager.publish((Object)new FollowingEvent(lastTopicIdentifier, data));
                                } else if ("hype-train-events-v1".equals(topicName) && topicParts.length > 2 && "rewards".equals(topicParts[1])) {
                                    TwitchPubSub.this.eventManager.publish((Object)new HypeTrainRewardsEvent((HypeTrainRewardsData)TypeConvert.convertValue((Object)msgData, HypeTrainRewardsData.class)));
                                } else if ("hype-train-events-v1".equals(topicName) && topicParts.length > 1) {
                                    switch (type) {
                                        case "hype-train-approaching": {
                                            HypeTrainApproaching approachData = (HypeTrainApproaching)TypeConvert.convertValue((Object)msgData, HypeTrainApproaching.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainApproachingEvent(approachData));
                                            break;
                                        }
                                        case "hype-train-start": {
                                            HypeTrainStart startData = (HypeTrainStart)TypeConvert.convertValue((Object)msgData, HypeTrainStart.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainStartEvent(startData));
                                            break;
                                        }
                                        case "hype-train-progression": {
                                            HypeProgression progressionData = (HypeProgression)TypeConvert.convertValue((Object)msgData, HypeProgression.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainProgressionEvent(lastTopicIdentifier, progressionData));
                                            break;
                                        }
                                        case "hype-train-level-up": {
                                            HypeLevelUp levelUpData = (HypeLevelUp)TypeConvert.convertValue((Object)msgData, HypeLevelUp.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainLevelUpEvent(lastTopicIdentifier, levelUpData));
                                            break;
                                        }
                                        case "hype-train-end": {
                                            HypeTrainEnd endData = (HypeTrainEnd)TypeConvert.convertValue((Object)msgData, HypeTrainEnd.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainEndEvent(lastTopicIdentifier, endData));
                                            break;
                                        }
                                        case "hype-train-conductor-update": {
                                            HypeTrainConductor conductorData = (HypeTrainConductor)TypeConvert.convertValue((Object)msgData, HypeTrainConductor.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainConductorUpdateEvent(lastTopicIdentifier, conductorData));
                                            break;
                                        }
                                        case "hype-train-cooldown-expiration": {
                                            TwitchPubSub.this.eventManager.publish((Object)new HypeTrainCooldownExpirationEvent(lastTopicIdentifier));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("community-points-user-v1".equals(topicName)) {
                                    switch (type) {
                                        case "points-earned": {
                                            ChannelPointsEarned pointsEarned = (ChannelPointsEarned)TypeConvert.convertValue((Object)msgData, ChannelPointsEarned.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new PointsEarnedEvent(pointsEarned));
                                            break;
                                        }
                                        case "claim-available": {
                                            ClaimData claimAvailable = (ClaimData)TypeConvert.convertValue((Object)msgData, ClaimData.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new ClaimAvailableEvent(claimAvailable));
                                            break;
                                        }
                                        case "claim-claimed": {
                                            ClaimData claimClaimed = (ClaimData)TypeConvert.convertValue((Object)msgData, ClaimData.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new ClaimClaimedEvent(claimClaimed));
                                            break;
                                        }
                                        case "points-spent": {
                                            PointsSpent pointsSpent = (PointsSpent)TypeConvert.convertValue((Object)msgData, PointsSpent.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new PointsSpentEvent(pointsSpent));
                                            break;
                                        }
                                        case "reward-redeemed": {
                                            ChannelPointsRedemption redemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                                            TwitchPubSub.this.eventManager.publish((Object)new RewardRedeemedEvent(Instant.parse(msgData.path("timestamp").asText()), redemption));
                                            break;
                                        }
                                        case "community-goal-contribution": {
                                            CommunityGoalContribution goal = (CommunityGoalContribution)TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                                            Instant instant = Instant.parse(msgData.path("timestamp").textValue());
                                            TwitchPubSub.this.eventManager.publish((Object)new UserCommunityGoalContributionEvent(lastTopicIdentifier, instant, goal));
                                            break;
                                        }
                                        case "global-last-viewed-content-updated": 
                                        case "channel-last-viewed-content-updated": {
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("leaderboard-events-v1".equals(topicName)) {
                                    Leaderboard leaderboard = (Leaderboard)TypeConvert.jsonToObject((String)rawMessage, Leaderboard.class);
                                    switch (leaderboard.getIdentifier().getDomain()) {
                                        case "bits-usage-by-channel-v1": {
                                            TwitchPubSub.this.eventManager.publish((Object)new BitsLeaderboardEvent(leaderboard));
                                            break;
                                        }
                                        case "sub-gifts-sent": {
                                            TwitchPubSub.this.eventManager.publish((Object)new SubLeaderboardEvent(leaderboard));
                                            break;
                                        }
                                        default: {
                                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                            break;
                                        }
                                    }
                                } else if ("user-moderation-notifications".equals(topicName)) {
                                    if (topicParts.length == 3 && "automod_caught_message".equalsIgnoreCase(type)) {
                                        UserAutomodCaughtMessage data = (UserAutomodCaughtMessage)TypeConvert.convertValue((Object)msgData, UserAutomodCaughtMessage.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new UserAutomodCaughtMessageEvent(topicParts[1], topicParts[2], data));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("polls".equals(topicName)) {
                                    PollData pollData = (PollData)TypeConvert.convertValue((Object)msgData.path("poll"), PollData.class);
                                    TwitchPubSub.this.eventManager.publish((Object)new PollsEvent(type, pollData));
                                } else if ("predictions-channel-v1".equals(topicName)) {
                                    if ("event-created".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish(TypeConvert.convertValue((Object)msgData, PredictionCreatedEvent.class));
                                    } else if ("event-updated".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish(TypeConvert.convertValue((Object)msgData, PredictionUpdatedEvent.class));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("predictions-user-v1".equals(topicName)) {
                                    if ("prediction-made".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish(TypeConvert.convertValue((Object)msgData, UserPredictionMadeEvent.class));
                                    } else if ("prediction-result".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish(TypeConvert.convertValue((Object)msgData, UserPredictionResultEvent.class));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("friendship".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new FriendshipEvent((FriendshipData)TypeConvert.jsonToObject((String)rawMessage, FriendshipData.class)));
                                } else if ("presence".equals(topicName) && topicParts.length > 1) {
                                    if ("presence".equalsIgnoreCase(type)) {
                                        TwitchPubSub.this.eventManager.publish((Object)new UserPresenceEvent((PresenceData)TypeConvert.convertValue((Object)msgData, PresenceData.class)));
                                    } else if ("settings".equalsIgnoreCase(type)) {
                                        PresenceSettings presenceSettings = (PresenceSettings)TypeConvert.convertValue((Object)msgData, PresenceSettings.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new PresenceSettingsEvent(lastTopicIdentifier, presenceSettings));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("radio-events-v1".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new RadioEvent((RadioData)TypeConvert.jsonToObject((String)rawMessage, RadioData.class)));
                                } else if ("channel-sub-gifts-v1".equals(topicName)) {
                                    TwitchPubSub.this.eventManager.publish((Object)new ChannelSubGiftEvent((SubGiftData)TypeConvert.jsonToObject((String)rawMessage, SubGiftData.class)));
                                } else if ("channel-cheer-events-public-v1".equals(topicName) && topicParts.length > 1) {
                                    if ("cheerbomb".equalsIgnoreCase(type)) {
                                        CheerbombData cheerbomb = (CheerbombData)TypeConvert.convertValue((Object)msgData, CheerbombData.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new CheerbombEvent(lastTopicIdentifier, cheerbomb));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("low-trust-users".equals(topicName) && topicParts.length == 3) {
                                    String userId = topicParts[1];
                                    String channelId = topicParts[2];
                                    if ("low_trust_user_new_message".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish((Object)new LowTrustUserNewMessageEvent(userId, channelId, (LowTrustUserNewMessage)TypeConvert.convertValue((Object)msgData, LowTrustUserNewMessage.class)));
                                    } else if ("low_trust_user_treatment_update".equals(type)) {
                                        TwitchPubSub.this.eventManager.publish((Object)new LowTrustUserTreatmentUpdateEvent(userId, channelId, (LowTrustUserTreatmentUpdate)TypeConvert.convertValue((Object)msgData, LowTrustUserTreatmentUpdate.class)));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("onsite-notifications".equals(topicName) && topicParts.length > 1) {
                                    if ("create-notification".equalsIgnoreCase(type)) {
                                        TwitchPubSub.this.eventManager.publish((Object)new OnsiteNotificationCreationEvent((CreateNotificationData)TypeConvert.convertValue((Object)msgData, CreateNotificationData.class)));
                                    } else if ("update-summary".equalsIgnoreCase(type)) {
                                        UpdateSummaryData data = (UpdateSummaryData)TypeConvert.convertValue((Object)msgData, UpdateSummaryData.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new UpdateOnsiteNotificationSummaryEvent(lastTopicIdentifier, data));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if (("video-playback-by-id".equals(topicName) || "video-playback".equals(topicName)) && topicParts.length > 1) {
                                    boolean hasId = topicName.endsWith("d");
                                    VideoPlaybackData data = (VideoPlaybackData)TypeConvert.jsonToObject((String)rawMessage, VideoPlaybackData.class);
                                    TwitchPubSub.this.eventManager.publish((Object)new VideoPlaybackEvent(hasId ? lastTopicIdentifier : null, hasId ? null : lastTopicIdentifier, data));
                                } else if ("channel-unban-requests".equals(topicName) && topicParts.length == 3) {
                                    String userId = topicParts[1];
                                    String channelId = topicParts[2];
                                    if ("create_unban_request".equals(type)) {
                                        CreatedUnbanRequest request = (CreatedUnbanRequest)TypeConvert.convertValue((Object)msgData, CreatedUnbanRequest.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new ChannelUnbanRequestCreateEvent(userId, channelId, request));
                                    } else if ("update_unban_request".equals(type)) {
                                        UpdatedUnbanRequest request = (UpdatedUnbanRequest)TypeConvert.convertValue((Object)msgData, UpdatedUnbanRequest.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new ChannelUnbanRequestUpdateEvent(userId, channelId, request));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else if ("user-unban-requests".equals(topicName) && topicParts.length == 3) {
                                    String userId = topicParts[1];
                                    String channelId = topicParts[2];
                                    if ("update_unban_request".equals(type)) {
                                        UpdatedUnbanRequest request = (UpdatedUnbanRequest)TypeConvert.convertValue((Object)msgData, UpdatedUnbanRequest.class);
                                        TwitchPubSub.this.eventManager.publish((Object)new UserUnbanRequestUpdateEvent(userId, channelId, request));
                                    } else {
                                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                    }
                                } else {
                                    log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                                }
                            } else if (message.getType().equals((Object)PubSubType.RESPONSE)) {
                                TwitchPubSub.this.eventManager.publish((Object)new PubSubListenResponseEvent(message.getNonce(), message.getError()));
                                if (message.getError().length() > 0) {
                                    if (message.getError().equalsIgnoreCase("ERR_BADAUTH")) {
                                        log.error("PubSub: You used a invalid oauth token to subscribe to the topic. Please use a token that is authorized for the specified channel.");
                                    } else {
                                        log.error("PubSub: Failed to subscribe to topic - [" + message.getError() + "]");
                                    }
                                }
                            } else if (message.getType().equals((Object)PubSubType.PONG)) {
                                log.debug("PubSub: Received PONG response!");
                                TwitchPubSub.this.lastPong = TimeUtils.getCurrentTimeInMillis();
                            } else if (message.getType().equals((Object)PubSubType.RECONNECT)) {
                                log.warn("PubSub: Server instance we're connected to will go down for maintenance soon, reconnecting to obtain a new connection!");
                                TwitchPubSub.this.reconnect();
                            } else {
                                log.debug("PubSub: Unknown Message Type: " + message);
                            }
                        }
                        catch (Exception ex) {
                            log.warn("PubSub: Unparsable Message: " + text + " - [" + ex.getMessage() + "]");
                            ex.printStackTrace();
                        }
                    }

                    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
                        if (!TwitchPubSub.this.connectionState.equals((Object)TMIConnectionState.DISCONNECTING)) {
                            log.info("Connection to Twitch PubSub lost (WebSocket)! Retrying soon ...");
                            if (TwitchPubSub.this.backoffClearer != null) {
                                TwitchPubSub.this.backoffClearer.cancel(false);
                            }
                            TwitchPubSub.this.taskExecutor.schedule(() -> TwitchPubSub.this.reconnect(), TwitchPubSub.this.backoff.get(), TimeUnit.MILLISECONDS);
                        } else {
                            TwitchPubSub.this.connectionState = TMIConnectionState.DISCONNECTED;
                            log.info("Disconnected from Twitch PubSub (WebSocket)!");
                        }
                    }
                });
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void sendCommand(String command) {
        if (this.connectionState.equals((Object)TMIConnectionState.CONNECTED) || this.connectionState.equals((Object)TMIConnectionState.CONNECTING)) {
            this.webSocket.sendText(command);
        } else {
            log.warn("Can't send IRC-WS Command [{}]", (Object)command);
        }
    }

    private void queueRequest(PubSubRequest request) {
        this.commandQueue.add(TypeConvert.objectToJson((Object)request));
        if (!this.flushing.get() && !this.flushRequested.getAndSet(true)) {
            this.taskExecutor.schedule(this.flushCommand, 50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public PubSubSubscription listenOnTopic(PubSubRequest request) {
        if (this.subscribedTopics.add(request)) {
            this.queueRequest(request);
        }
        return new PubSubSubscription(request);
    }

    @Override
    public boolean unsubscribeFromTopic(PubSubSubscription subscription) {
        PubSubRequest request = subscription.getRequest();
        if (request.getType() != PubSubType.LISTEN) {
            log.warn("Cannot unsubscribe using request with unexpected type: {}", (Object)request.getType());
            return false;
        }
        boolean removed = this.subscribedTopics.remove(request);
        if (!removed) {
            log.warn("Not subscribed to topic: {}", (Object)request);
            return false;
        }
        PubSubRequest unlistenRequest = new PubSubRequest();
        unlistenRequest.setType(PubSubType.UNLISTEN);
        unlistenRequest.setNonce(CryptoUtils.generateNonce((int)30));
        unlistenRequest.setData(request.getData());
        this.queueRequest(unlistenRequest);
        return true;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.heartbeatTask.cancel(false);
            this.queueTask.cancel(false);
            this.disconnect();
        }
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }
}

