/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.AutomodContentClassification;
import java.time.Instant;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AutomodCaughtMessage {
    private Content content;
    private String id;
    private Sender sender;
    private Instant sentAt;

    public Content getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public Sender getSender() {
        return this.sender;
    }

    public Instant getSentAt() {
        return this.sentAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutomodCaughtMessage)) {
            return false;
        }
        AutomodCaughtMessage other = (AutomodCaughtMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Content this$content = this.getContent();
        Content other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Sender this$sender = this.getSender();
        Sender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        Instant this$sentAt = this.getSentAt();
        Instant other$sentAt = other.getSentAt();
        return !(this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutomodCaughtMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Content $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Sender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        Instant $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        return result;
    }

    public String toString() {
        return "AutomodCaughtMessage(content=" + this.getContent() + ", id=" + this.getId() + ", sender=" + this.getSender() + ", sentAt=" + this.getSentAt() + ")";
    }

    private void setContent(Content content) {
        this.content = content;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setSender(Sender sender) {
        this.sender = sender;
    }

    private void setSentAt(Instant sentAt) {
        this.sentAt = sentAt;
    }

    public static class Content {
        private String text;
        private List<Fragment> fragments;

        public String getText() {
            return this.text;
        }

        public List<Fragment> getFragments() {
            return this.fragments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            List<Fragment> this$fragments = this.getFragments();
            List<Fragment> other$fragments = other.getFragments();
            return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            List<Fragment> $fragments = this.getFragments();
            result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.Content(text=" + this.getText() + ", fragments=" + this.getFragments() + ")";
        }

        private void setText(String text) {
            this.text = text;
        }

        private void setFragments(List<Fragment> fragments) {
            this.fragments = fragments;
        }
    }

    public static class Sender {
        private String userId;
        private String login;
        private String displayName;
        private String chatColor;
        private List<Badge> badges;

        public String getUserId() {
            return this.userId;
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getChatColor() {
            return this.chatColor;
        }

        public List<Badge> getBadges() {
            return this.badges;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sender)) {
                return false;
            }
            Sender other = (Sender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$login = this.getLogin();
            String other$login = other.getLogin();
            if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$chatColor = this.getChatColor();
            String other$chatColor = other.getChatColor();
            if (this$chatColor == null ? other$chatColor != null : !this$chatColor.equals(other$chatColor)) {
                return false;
            }
            List<Badge> this$badges = this.getBadges();
            List<Badge> other$badges = other.getBadges();
            return !(this$badges == null ? other$badges != null : !((Object)this$badges).equals(other$badges));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $login = this.getLogin();
            result = result * 59 + ($login == null ? 43 : $login.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $chatColor = this.getChatColor();
            result = result * 59 + ($chatColor == null ? 43 : $chatColor.hashCode());
            List<Badge> $badges = this.getBadges();
            result = result * 59 + ($badges == null ? 43 : ((Object)$badges).hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.Sender(userId=" + this.getUserId() + ", login=" + this.getLogin() + ", displayName=" + this.getDisplayName() + ", chatColor=" + this.getChatColor() + ", badges=" + this.getBadges() + ")";
        }

        private void setUserId(String userId) {
            this.userId = userId;
        }

        private void setLogin(String login) {
            this.login = login;
        }

        private void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        private void setChatColor(String chatColor) {
            this.chatColor = chatColor;
        }

        private void setBadges(List<Badge> badges) {
            this.badges = badges;
        }

        public static class Badge {
            private String id;
            private String version;

            public String getId() {
                return this.id;
            }

            public String getVersion() {
                return this.version;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Badge)) {
                    return false;
                }
                Badge other = (Badge)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Badge;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            public String toString() {
                return "AutomodCaughtMessage.Sender.Badge(id=" + this.getId() + ", version=" + this.getVersion() + ")";
            }

            private void setId(String id) {
                this.id = id;
            }

            private void setVersion(String version) {
                this.version = version;
            }
        }
    }

    public static class FragmentMention {
        @JsonProperty(value="userID")
        String userId;
        String login;
        String displayName;

        public String getUserId() {
            return this.userId;
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FragmentMention)) {
                return false;
            }
            FragmentMention other = (FragmentMention)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$login = this.getLogin();
            String other$login = other.getLogin();
            if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FragmentMention;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $login = this.getLogin();
            result = result * 59 + ($login == null ? 43 : $login.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.FragmentMention(userId=" + this.getUserId() + ", login=" + this.getLogin() + ", displayName=" + this.getDisplayName() + ")";
        }

        @JsonProperty(value="userID")
        private void setUserId(String userId) {
            this.userId = userId;
        }

        private void setLogin(String login) {
            this.login = login;
        }

        private void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class FragmentLink {
        private String host;

        public String getHost() {
            return this.host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FragmentLink)) {
                return false;
            }
            FragmentLink other = (FragmentLink)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FragmentLink;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.FragmentLink(host=" + this.getHost() + ")";
        }

        private void setHost(String host) {
            this.host = host;
        }
    }

    public static class FragmentFlags {
        private Map<String, Integer> topics;

        public Map<AutomodContentClassification.Category, Integer> getParsedTopics() {
            return (Map)TypeConvert.convertValue(this.topics, (TypeReference)new TypeReference<EnumMap<AutomodContentClassification.Category, Integer>>(){});
        }

        public Map<String, Integer> getTopics() {
            return this.topics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FragmentFlags)) {
                return false;
            }
            FragmentFlags other = (FragmentFlags)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Integer> this$topics = this.getTopics();
            Map<String, Integer> other$topics = other.getTopics();
            return !(this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FragmentFlags;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Integer> $topics = this.getTopics();
            result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.FragmentFlags(topics=" + this.getTopics() + ")";
        }

        private void setTopics(Map<String, Integer> topics) {
            this.topics = topics;
        }
    }

    public static class Fragment {
        private String text;
        @Nullable
        private FragmentFlags automod;
        @Nullable
        private FragmentLink link;
        @Nullable
        private FragmentMention userMention;

        public boolean isFragmentFlagged() {
            return this.getAutomod() != null && this.getAutomod().getTopics() != null && !this.getAutomod().getTopics().isEmpty();
        }

        public boolean isFragmentLink() {
            return this.getLink() != null && this.getLink().getHost() != null;
        }

        public boolean isFragmentMention() {
            return this.getUserMention() != null && this.getUserMention().getUserId() != null;
        }

        public String getText() {
            return this.text;
        }

        @Nullable
        public FragmentFlags getAutomod() {
            return this.automod;
        }

        @Nullable
        public FragmentLink getLink() {
            return this.link;
        }

        @Nullable
        public FragmentMention getUserMention() {
            return this.userMention;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fragment)) {
                return false;
            }
            Fragment other = (Fragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            FragmentFlags this$automod = this.getAutomod();
            FragmentFlags other$automod = other.getAutomod();
            if (this$automod == null ? other$automod != null : !((Object)this$automod).equals(other$automod)) {
                return false;
            }
            FragmentLink this$link = this.getLink();
            FragmentLink other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            FragmentMention this$userMention = this.getUserMention();
            FragmentMention other$userMention = other.getUserMention();
            return !(this$userMention == null ? other$userMention != null : !((Object)this$userMention).equals(other$userMention));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Fragment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            FragmentFlags $automod = this.getAutomod();
            result = result * 59 + ($automod == null ? 43 : ((Object)$automod).hashCode());
            FragmentLink $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            FragmentMention $userMention = this.getUserMention();
            result = result * 59 + ($userMention == null ? 43 : ((Object)$userMention).hashCode());
            return result;
        }

        public String toString() {
            return "AutomodCaughtMessage.Fragment(text=" + this.getText() + ", automod=" + this.getAutomod() + ", link=" + this.getLink() + ", userMention=" + this.getUserMention() + ")";
        }

        private void setText(String text) {
            this.text = text;
        }

        private void setAutomod(@Nullable FragmentFlags automod) {
            this.automod = automod;
        }

        private void setLink(@Nullable FragmentLink link) {
            this.link = link;
        }

        private void setUserMention(@Nullable FragmentMention userMention) {
            this.userMention = userMention;
        }
    }
}

