/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.pubsub.PubSubSubscription;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import com.github.twitch4j.pubsub.enums.PubSubType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public interface ITwitchPubSub
extends AutoCloseable {
    public EventManager getEventManager();

    public PubSubSubscription listenOnTopic(PubSubRequest var1);

    public boolean unsubscribeFromTopic(PubSubSubscription var1);

    @Override
    public void close();

    default public PubSubSubscription listenOnTopic(PubSubType type, OAuth2Credential credential, Collection<String> topics) {
        PubSubRequest request = new PubSubRequest();
        request.setType(type);
        request.setNonce(CryptoUtils.generateNonce((int)30));
        request.getData().put("auth_token", credential != null ? credential.getAccessToken() : "");
        request.getData().put("topics", topics);
        return this.listenOnTopic(request);
    }

    default public PubSubSubscription listenOnTopic(PubSubType type, OAuth2Credential credential, String topic) {
        return this.listenOnTopic(type, credential, Collections.singletonList(topic));
    }

    default public PubSubSubscription listenOnTopic(PubSubType type, OAuth2Credential credential, String ... topics) {
        return this.listenOnTopic(type, credential, Arrays.asList(topics));
    }

    default public PubSubSubscription listenForAutomodQueueEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "automod-queue." + userId + "." + channelId);
    }

    default public PubSubSubscription listenForBitsBadgeEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-bits-badge-unlocks." + channelId);
    }

    default public PubSubSubscription listenForCheerEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-bits-events-v2." + channelId);
    }

    default public PubSubSubscription listenForSubscriptionEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-subscribe-events-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForCommerceEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-commerce-events-v1." + channelId);
    }

    default public PubSubSubscription listenForWhisperEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "whispers." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForModerationEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "chat_moderator_actions." + channelId);
    }

    default public PubSubSubscription listenForModerationEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenForModerationEvents(credential, userId + "." + channelId);
    }

    default public PubSubSubscription listenForUserModerationNotificationEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-moderation-notifications." + userId + "." + channelId);
    }

    default public PubSubSubscription listenForChannelPointsRedemptionEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "community-points-channel-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForAdsEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "ads." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForAdPropertyRefreshEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "ad-property-refresh." + channelId);
    }

    default public PubSubSubscription listenForAutomodLevelsModificationEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "automod-levels-modification." + userId + "." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForBountyBoardEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-bounty-board-events.cta." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForDashboardActivityFeedEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "dashboard-activity-feed." + userId);
    }

    default public PubSubSubscription listenForCommunityBoostEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "community-boost-events-v1." + channelId);
    }

    default public PubSubSubscription listenForCrowdChantEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "crowd-chant-channel-v1." + channelId);
    }

    default public PubSubSubscription listenForUserChannelPointsEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "community-points-user-v1." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForChannelDropEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-drop-events." + channelId);
    }

    default public PubSubSubscription listenForChannelBitsLeaderboardEvents(OAuth2Credential credential, String channelId) {
        return this.listenForChannelBitsLeaderboardEvents(credential, channelId, "WEEK");
    }

    default public PubSubSubscription listenForChannelBitsLeaderboardMonthlyEvents(OAuth2Credential credential, String channelId) {
        return this.listenForChannelBitsLeaderboardEvents(credential, channelId, "MONTH");
    }

    default public PubSubSubscription listenForChannelBitsLeaderboardEvents(OAuth2Credential credential, String channelId, String timeAggregationUnit) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "leaderboard-events-v1.bits-usage-by-channel-v1-" + channelId + "-" + timeAggregationUnit);
    }

    @Deprecated
    default public PubSubSubscription listenForChannelPrimeGiftStatusEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-prime-gifting-status." + channelId);
    }

    default public PubSubSubscription listenForChannelSubLeaderboardEvents(OAuth2Credential credential, String channelId) {
        return this.listenForChannelSubLeaderboardEvents(credential, channelId, "WEEK");
    }

    default public PubSubSubscription listenForChannelSubLeaderboardMonthlyEvents(OAuth2Credential credential, String channelId) {
        return this.listenForChannelSubLeaderboardEvents(credential, channelId, "MONTH");
    }

    default public PubSubSubscription listenForChannelSubLeaderboardEvents(OAuth2Credential credential, String channelId, String timeAggregationUnit) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "leaderboard-events-v1.sub-gifts-sent-" + channelId + "-" + timeAggregationUnit);
    }

    default public PubSubSubscription listenForLeaderboardEvents(OAuth2Credential credential, String channelId) {
        return this.listenForLeaderboardEvents(credential, channelId, "WEEK");
    }

    default public PubSubSubscription listenForLeaderboardMonthlyEvents(OAuth2Credential credential, String channelId) {
        return this.listenForLeaderboardEvents(credential, channelId, "MONTH");
    }

    default public PubSubSubscription listenForLeaderboardEvents(OAuth2Credential credential, String channelId, String timeAggregationUnit) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "leaderboard-events-v1.bits-usage-by-channel-v1-" + channelId + "-" + timeAggregationUnit, "leaderboard-events-v1.sub-gifts-sent-" + channelId + "-" + timeAggregationUnit);
    }

    default public PubSubSubscription listenForChannelPredictionsEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "predictions-channel-v1." + channelId);
    }

    default public PubSubSubscription listenForUserPredictionsEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "predictions-user-v1." + userId);
    }

    default public PubSubSubscription listenForChannelSubGiftsEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-sub-gifts-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForChannelSquadEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-squad-updates." + channelId);
    }

    default public PubSubSubscription listenForRaidEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "raid." + channelId);
    }

    default public PubSubSubscription listenForChannelUnbanRequestEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-unban-requests." + userId + '.' + channelId);
    }

    default public PubSubSubscription listenForUserUnbanRequestEvents(OAuth2Credential credential, String userId, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-unban-requests." + userId + '.' + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForChannelExtensionEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-ext-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForExtensionControlEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "extension-control." + channelId);
    }

    default public PubSubSubscription listenForHypeTrainEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "hype-train-events-v1." + channelId);
    }

    default public PubSubSubscription listenForHypeTrainRewardEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "hype-train-events-v1.rewards." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForBroadcastSettingUpdateEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "broadcast-settings-update." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForCelebrationEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "celebration-events-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForPublicBitEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-bit-events-public." + channelId);
    }

    default public PubSubSubscription listenForPublicCheerEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "channel-cheer-events-public-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForStreamChangeEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "stream-change-by-channel." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForStreamChatRoomEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "stream-chat-room-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForChannelChatroomEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "chatrooms-channel-v1." + channelId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserChatroomEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "chatrooms-user-v1." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserBitsUpdateEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-bits-updates-v1." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserCampaignEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-campaign-events." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserDropEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-drop-events." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserPropertiesUpdateEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-properties-update." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserSubscribeEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-subscribe-events-v1." + userId);
    }

    @Deprecated
    default public PubSubSubscription listenForUserImageUpdateEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "user-image-update." + userId);
    }

    default public PubSubSubscription listenForFollowingEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "following." + channelId);
    }

    default public PubSubSubscription listenForFriendshipEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "friendship." + userId);
    }

    default public PubSubSubscription listenForOnsiteNotificationEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "onsite-notifications." + userId);
    }

    default public PubSubSubscription listenForPollEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "polls." + channelId);
    }

    default public PubSubSubscription listenForPresenceEvents(OAuth2Credential credential, String userId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "presence." + userId);
    }

    default public PubSubSubscription listenForRadioEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "radio-events-v1." + channelId);
    }

    default public PubSubSubscription listenForVideoPlaybackEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "video-playback-by-id." + channelId);
    }

    default public PubSubSubscription listenForVideoPlaybackByNameEvents(OAuth2Credential credential, String channelName) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "video-playback." + channelName.toLowerCase());
    }

    @Deprecated
    default public PubSubSubscription listenForWatchPartyEvents(OAuth2Credential credential, String channelId) {
        return this.listenOnTopic(PubSubType.LISTEN, credential, "pv-watch-party-events." + channelId);
    }
}

