/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.CreateNotificationData;
import com.github.twitch4j.pubsub.domain.UpdateSummaryData;
import com.github.twitch4j.pubsub.events.OnsiteNotificationCreationEvent;
import com.github.twitch4j.pubsub.events.UpdateOnsiteNotificationSummaryEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;

class NotificationHandler
implements TopicHandler {
    NotificationHandler() {
    }

    @Override
    public String topicName() {
        return "onsite-notifications";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        if ("create-notification".equalsIgnoreCase(args.getType())) {
            CreateNotificationData data = (CreateNotificationData)TypeConvert.convertValue((Object)args.getData(), CreateNotificationData.class);
            return new OnsiteNotificationCreationEvent(data);
        }
        if ("update-summary".equalsIgnoreCase(args.getType())) {
            UpdateSummaryData data = (UpdateSummaryData)TypeConvert.convertValue((Object)args.getData(), UpdateSummaryData.class);
            return new UpdateOnsiteNotificationSummaryEvent(args.getLastTopicPart(), data);
        }
        return null;
    }
}

