/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.domain;

import com.github.twitch4j.common.util.DonationAmount;
import java.util.Optional;

public class CharityDonationData {
    private String campaignId;
    private String campaignCurrency = "USD";
    private Long donationTotal;
    private Long goalTarget;

    public DonationAmount getTotal() {
        return new DonationAmount(this.donationTotal, Integer.valueOf(2), this.campaignCurrency);
    }

    public Optional<DonationAmount> getTarget() {
        return Optional.ofNullable(this.goalTarget).filter(l -> l > 0L).map(target -> new DonationAmount(target, Integer.valueOf(2), this.campaignCurrency));
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getCampaignCurrency() {
        return this.campaignCurrency;
    }

    public Long getDonationTotal() {
        return this.donationTotal;
    }

    public Long getGoalTarget() {
        return this.goalTarget;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharityDonationData)) {
            return false;
        }
        CharityDonationData other = (CharityDonationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$donationTotal = this.getDonationTotal();
        Long other$donationTotal = other.getDonationTotal();
        if (this$donationTotal == null ? other$donationTotal != null : !((Object)this$donationTotal).equals(other$donationTotal)) {
            return false;
        }
        Long this$goalTarget = this.getGoalTarget();
        Long other$goalTarget = other.getGoalTarget();
        if (this$goalTarget == null ? other$goalTarget != null : !((Object)this$goalTarget).equals(other$goalTarget)) {
            return false;
        }
        String this$campaignId = this.getCampaignId();
        String other$campaignId = other.getCampaignId();
        if (this$campaignId == null ? other$campaignId != null : !this$campaignId.equals(other$campaignId)) {
            return false;
        }
        String this$campaignCurrency = this.getCampaignCurrency();
        String other$campaignCurrency = other.getCampaignCurrency();
        return !(this$campaignCurrency == null ? other$campaignCurrency != null : !this$campaignCurrency.equals(other$campaignCurrency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CharityDonationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $donationTotal = this.getDonationTotal();
        result = result * 59 + ($donationTotal == null ? 43 : ((Object)$donationTotal).hashCode());
        Long $goalTarget = this.getGoalTarget();
        result = result * 59 + ($goalTarget == null ? 43 : ((Object)$goalTarget).hashCode());
        String $campaignId = this.getCampaignId();
        result = result * 59 + ($campaignId == null ? 43 : $campaignId.hashCode());
        String $campaignCurrency = this.getCampaignCurrency();
        result = result * 59 + ($campaignCurrency == null ? 43 : $campaignCurrency.hashCode());
        return result;
    }

    public String toString() {
        return "CharityDonationData(campaignId=" + this.getCampaignId() + ", campaignCurrency=" + this.getCampaignCurrency() + ", donationTotal=" + this.getDonationTotal() + ", goalTarget=" + this.getGoalTarget() + ")";
    }

    private void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    private void setCampaignCurrency(String campaignCurrency) {
        this.campaignCurrency = campaignCurrency;
    }

    private void setDonationTotal(Long donationTotal) {
        this.donationTotal = donationTotal;
    }

    private void setGoalTarget(Long goalTarget) {
        this.goalTarget = goalTarget;
    }
}

