/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.events;

import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import java.util.Optional;
import java.util.function.Supplier;

public final class PubSubListenResponseEvent
extends TwitchEvent {
    private final String nonce;
    private final String error;
    private final Supplier<PubSubRequest> listenRequestSupplier;

    public Optional<PubSubRequest> getListenRequest() {
        return Optional.ofNullable(this.listenRequestSupplier.get());
    }

    public boolean hasError() {
        return this.error != null && this.error.length() > 0;
    }

    public boolean isBadAuthentication() {
        return "ERR_BADAUTH".equals(this.error);
    }

    public boolean isBadMessage() {
        return "ERR_BADMESSAGE".equals(this.error);
    }

    public boolean isBadTopic() {
        return "ERR_BADTOPIC".equals(this.error);
    }

    public boolean isServerError() {
        return "ERR_SERVER".equals(this.error);
    }

    public PubSubListenResponseEvent(String nonce, String error, Supplier<PubSubRequest> listenRequestSupplier) {
        this.nonce = nonce;
        this.error = error;
        this.listenRequestSupplier = listenRequestSupplier;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return "PubSubListenResponseEvent(nonce=" + this.getNonce() + ", error=" + this.getError() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubSubListenResponseEvent)) {
            return false;
        }
        PubSubListenResponseEvent other = (PubSubListenResponseEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Supplier<PubSubRequest> this$listenRequestSupplier = this.getListenRequestSupplier();
        Supplier<PubSubRequest> other$listenRequestSupplier = other.getListenRequestSupplier();
        return !(this$listenRequestSupplier == null ? other$listenRequestSupplier != null : !this$listenRequestSupplier.equals(other$listenRequestSupplier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PubSubListenResponseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Supplier<PubSubRequest> $listenRequestSupplier = this.getListenRequestSupplier();
        result = result * 59 + ($listenRequestSupplier == null ? 43 : $listenRequestSupplier.hashCode());
        return result;
    }

    private Supplier<PubSubRequest> getListenRequestSupplier() {
        return this.listenRequestSupplier;
    }
}

