/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.client.websocket.WebsocketConnection;
import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.events.user.PrivateMessageEvent;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.TimeUtils;
import com.github.twitch4j.common.util.TwitchUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.pubsub.PubSubSubscription;
import com.github.twitch4j.pubsub.domain.AliasRestrictionUpdateData;
import com.github.twitch4j.pubsub.domain.AutomodCaughtMessageData;
import com.github.twitch4j.pubsub.domain.AutomodLevelsModified;
import com.github.twitch4j.pubsub.domain.BannedTermAdded;
import com.github.twitch4j.pubsub.domain.BannedTermRemoved;
import com.github.twitch4j.pubsub.domain.BitsBadgeData;
import com.github.twitch4j.pubsub.domain.ChannelBitsData;
import com.github.twitch4j.pubsub.domain.ChannelPointsEarned;
import com.github.twitch4j.pubsub.domain.ChannelPointsRedemption;
import com.github.twitch4j.pubsub.domain.ChannelPointsReward;
import com.github.twitch4j.pubsub.domain.ChannelTermsAction;
import com.github.twitch4j.pubsub.domain.CharityCampaignStatus;
import com.github.twitch4j.pubsub.domain.CharityDonationData;
import com.github.twitch4j.pubsub.domain.ChatModerationAction;
import com.github.twitch4j.pubsub.domain.CheerbombData;
import com.github.twitch4j.pubsub.domain.ClaimData;
import com.github.twitch4j.pubsub.domain.CommerceData;
import com.github.twitch4j.pubsub.domain.CommunityBoostProgression;
import com.github.twitch4j.pubsub.domain.CommunityGoalContribution;
import com.github.twitch4j.pubsub.domain.CreateNotificationData;
import com.github.twitch4j.pubsub.domain.CreateShoutoutData;
import com.github.twitch4j.pubsub.domain.CreatedUnbanRequest;
import com.github.twitch4j.pubsub.domain.CreatorGoal;
import com.github.twitch4j.pubsub.domain.DeletePinnedChatData;
import com.github.twitch4j.pubsub.domain.FollowingData;
import com.github.twitch4j.pubsub.domain.FriendshipData;
import com.github.twitch4j.pubsub.domain.HypeLevelUp;
import com.github.twitch4j.pubsub.domain.HypeProgression;
import com.github.twitch4j.pubsub.domain.HypeTrainApproaching;
import com.github.twitch4j.pubsub.domain.HypeTrainConductor;
import com.github.twitch4j.pubsub.domain.HypeTrainEnd;
import com.github.twitch4j.pubsub.domain.HypeTrainRewardsData;
import com.github.twitch4j.pubsub.domain.HypeTrainStart;
import com.github.twitch4j.pubsub.domain.Leaderboard;
import com.github.twitch4j.pubsub.domain.LowTrustUserNewMessage;
import com.github.twitch4j.pubsub.domain.LowTrustUserTreatmentUpdate;
import com.github.twitch4j.pubsub.domain.ModeratorUnbanRequestAction;
import com.github.twitch4j.pubsub.domain.PinnedChatData;
import com.github.twitch4j.pubsub.domain.PointsSpent;
import com.github.twitch4j.pubsub.domain.PollData;
import com.github.twitch4j.pubsub.domain.PresenceData;
import com.github.twitch4j.pubsub.domain.PresenceSettings;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import com.github.twitch4j.pubsub.domain.PubSubResponse;
import com.github.twitch4j.pubsub.domain.RadioData;
import com.github.twitch4j.pubsub.domain.RedemptionProgress;
import com.github.twitch4j.pubsub.domain.ShieldModeSettings;
import com.github.twitch4j.pubsub.domain.ShieldModeStatus;
import com.github.twitch4j.pubsub.domain.SubGiftData;
import com.github.twitch4j.pubsub.domain.SubscriptionData;
import com.github.twitch4j.pubsub.domain.SupportActivityFeedData;
import com.github.twitch4j.pubsub.domain.UpdateSummaryData;
import com.github.twitch4j.pubsub.domain.UpdatedPinnedChatTiming;
import com.github.twitch4j.pubsub.domain.UpdatedUnbanRequest;
import com.github.twitch4j.pubsub.domain.UserAutomodCaughtMessage;
import com.github.twitch4j.pubsub.domain.UserModerationActionData;
import com.github.twitch4j.pubsub.domain.VideoPlaybackData;
import com.github.twitch4j.pubsub.enums.PubSubType;
import com.github.twitch4j.pubsub.events.AliasRestrictionUpdateEvent;
import com.github.twitch4j.pubsub.events.AutomodCaughtMessageEvent;
import com.github.twitch4j.pubsub.events.AutomodLevelsModifiedEvent;
import com.github.twitch4j.pubsub.events.BitsLeaderboardEvent;
import com.github.twitch4j.pubsub.events.ChannelBitsBadgeUnlockEvent;
import com.github.twitch4j.pubsub.events.ChannelBitsEvent;
import com.github.twitch4j.pubsub.events.ChannelCommerceEvent;
import com.github.twitch4j.pubsub.events.ChannelSubGiftEvent;
import com.github.twitch4j.pubsub.events.ChannelSubscribeEvent;
import com.github.twitch4j.pubsub.events.ChannelTermsEvent;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestCreateEvent;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestUpdateEvent;
import com.github.twitch4j.pubsub.events.CharityCampaignDonationEvent;
import com.github.twitch4j.pubsub.events.CharityCampaignStatusEvent;
import com.github.twitch4j.pubsub.events.ChatModerationEvent;
import com.github.twitch4j.pubsub.events.CheerbombEvent;
import com.github.twitch4j.pubsub.events.ClaimAvailableEvent;
import com.github.twitch4j.pubsub.events.ClaimClaimedEvent;
import com.github.twitch4j.pubsub.events.CommunityBoostProgressionEvent;
import com.github.twitch4j.pubsub.events.CommunityGoalContributionEvent;
import com.github.twitch4j.pubsub.events.CreatorGoalEvent;
import com.github.twitch4j.pubsub.events.CrowdChantCreatedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardCreatedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardDeletedEvent;
import com.github.twitch4j.pubsub.events.CustomRewardUpdatedEvent;
import com.github.twitch4j.pubsub.events.FollowingEvent;
import com.github.twitch4j.pubsub.events.FriendshipEvent;
import com.github.twitch4j.pubsub.events.HypeTrainApproachingEvent;
import com.github.twitch4j.pubsub.events.HypeTrainConductorUpdateEvent;
import com.github.twitch4j.pubsub.events.HypeTrainCooldownExpirationEvent;
import com.github.twitch4j.pubsub.events.HypeTrainEndEvent;
import com.github.twitch4j.pubsub.events.HypeTrainLevelUpEvent;
import com.github.twitch4j.pubsub.events.HypeTrainProgressionEvent;
import com.github.twitch4j.pubsub.events.HypeTrainRewardsEvent;
import com.github.twitch4j.pubsub.events.HypeTrainStartEvent;
import com.github.twitch4j.pubsub.events.LowTrustUserNewMessageEvent;
import com.github.twitch4j.pubsub.events.LowTrustUserTreatmentUpdateEvent;
import com.github.twitch4j.pubsub.events.ModUnbanRequestActionEvent;
import com.github.twitch4j.pubsub.events.OnsiteNotificationCreationEvent;
import com.github.twitch4j.pubsub.events.PinnedChatCreatedEvent;
import com.github.twitch4j.pubsub.events.PinnedChatDeletedEvent;
import com.github.twitch4j.pubsub.events.PinnedChatTimingUpdatedEvent;
import com.github.twitch4j.pubsub.events.PointsEarnedEvent;
import com.github.twitch4j.pubsub.events.PointsSpentEvent;
import com.github.twitch4j.pubsub.events.PollsEvent;
import com.github.twitch4j.pubsub.events.PredictionCreatedEvent;
import com.github.twitch4j.pubsub.events.PredictionUpdatedEvent;
import com.github.twitch4j.pubsub.events.PresenceSettingsEvent;
import com.github.twitch4j.pubsub.events.PubSubConnectionStateEvent;
import com.github.twitch4j.pubsub.events.PubSubListenResponseEvent;
import com.github.twitch4j.pubsub.events.RadioEvent;
import com.github.twitch4j.pubsub.events.RaidCancelEvent;
import com.github.twitch4j.pubsub.events.RaidGoEvent;
import com.github.twitch4j.pubsub.events.RaidUpdateEvent;
import com.github.twitch4j.pubsub.events.RedemptionStatusUpdateEvent;
import com.github.twitch4j.pubsub.events.RewardRedeemedEvent;
import com.github.twitch4j.pubsub.events.ShieldModeBannedTermAddedEvent;
import com.github.twitch4j.pubsub.events.ShieldModeBannedTermRemovedEvent;
import com.github.twitch4j.pubsub.events.ShieldModeSettingsUpdatedEvent;
import com.github.twitch4j.pubsub.events.ShieldModeStatusUpdatedEvent;
import com.github.twitch4j.pubsub.events.ShoutoutCreatedEvent;
import com.github.twitch4j.pubsub.events.SubLeaderboardEvent;
import com.github.twitch4j.pubsub.events.SupportActivityFeedEvent;
import com.github.twitch4j.pubsub.events.UpdateOnsiteNotificationSummaryEvent;
import com.github.twitch4j.pubsub.events.UpdateRedemptionFinishedEvent;
import com.github.twitch4j.pubsub.events.UpdateRedemptionProgressEvent;
import com.github.twitch4j.pubsub.events.UserAutomodCaughtMessageEvent;
import com.github.twitch4j.pubsub.events.UserCommunityGoalContributionEvent;
import com.github.twitch4j.pubsub.events.UserModerationActionEvent;
import com.github.twitch4j.pubsub.events.UserPredictionMadeEvent;
import com.github.twitch4j.pubsub.events.UserPredictionResultEvent;
import com.github.twitch4j.pubsub.events.UserPresenceEvent;
import com.github.twitch4j.pubsub.events.UserUnbanRequestUpdateEvent;
import com.github.twitch4j.pubsub.events.VideoPlaybackEvent;
import com.github.twitch4j.util.IBackoffStrategy;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchPubSub
implements ITwitchPubSub {
    private static final Logger log = LoggerFactory.getLogger(TwitchPubSub.class);
    private final Object $lock = new Object[0];
    public static final int REQUIRED_THREAD_COUNT = 1;
    private static final Pattern LISTEN_AUTH_TOKEN = Pattern.compile("(\\{.*\"type\"\\s*?:\\s*?\"LISTEN\".*\"data\"\\s*?:\\s*?\\{.*\"auth_token\"\\s*?:\\s*?\").+(\".*}\\s*?})");
    private final EventManager eventManager;
    private final WebsocketConnection connection;
    private static final String WEB_SOCKET_SERVER = "wss://pubsub-edge.twitch.tv:443";
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final AtomicBoolean flushRequested = new AtomicBoolean();
    private final Runnable flushCommand;
    protected final Future<?> queueTask;
    protected final Future<?> heartbeatTask;
    protected volatile boolean isClosed = false;
    protected final BlockingQueue<String> commandQueue = new ArrayBlockingQueue<String>(128);
    protected final Set<PubSubRequest> subscribedTopics = ConcurrentHashMap.newKeySet();
    protected volatile long lastPing = TimeUtils.getCurrentTimeInMillis() - 240000L;
    protected volatile long lastPong = TimeUtils.getCurrentTimeInMillis();
    protected final ScheduledExecutorService taskExecutor;
    private final Collection<String> botOwnerIds;

    public TwitchPubSub(WebsocketConnection websocketConnection, EventManager eventManager, ScheduledThreadPoolExecutor taskExecutor, ProxyConfig proxyConfig, Collection<String> botOwnerIds, int wsPingPeriod, IBackoffStrategy connectionBackoffStrategy, int wsCloseDelay) {
        this.eventManager = eventManager;
        this.taskExecutor = taskExecutor;
        this.botOwnerIds = botOwnerIds;
        this.connection = websocketConnection == null ? new WebsocketConnection(spec -> {
            spec.baseUrl(WEB_SOCKET_SERVER);
            spec.closeDelay(wsCloseDelay);
            spec.wsPingPeriod(wsPingPeriod);
            spec.onStateChanged((oldState, newState) -> eventManager.publish((Object)new PubSubConnectionStateEvent((WebsocketConnectionState)oldState, (WebsocketConnectionState)newState, this)));
            spec.onPreConnect(this::onPreConnect);
            spec.onConnected(this::onConnected);
            spec.onTextMessage(this::onTextMessage);
            spec.onPostDisconnect(this.commandQueue::clear);
            spec.taskExecutor((ScheduledExecutorService)taskExecutor);
            spec.proxyConfig(proxyConfig);
            if (connectionBackoffStrategy != null) {
                spec.backoffStrategy(connectionBackoffStrategy);
            }
        }) : websocketConnection;
        this.eventManager.getServiceMediator().addService("twitch4j-pubsub", (Object)this);
        this.connect();
        this.heartbeatTask = taskExecutor.scheduleAtFixedRate(() -> {
            if (this.isClosed || this.connection.getConnectionState() != WebsocketConnectionState.CONNECTED) {
                return;
            }
            PubSubRequest request = new PubSubRequest();
            request.setType(PubSubType.PING);
            this.sendCommand(TypeConvert.objectToJson((Object)request));
            log.debug("PubSub: Sending PING!");
            this.lastPing = TimeUtils.getCurrentTimeInMillis();
        }, 0L, 4L, TimeUnit.MINUTES);
        this.flushCommand = () -> {
            if (this.flushing.getAndSet(true)) {
                return;
            }
            while (!this.isClosed) {
                try {
                    String command;
                    if (this.lastPong < this.lastPing && TimeUtils.getCurrentTimeInMillis() >= this.lastPing + 10000L) {
                        log.warn("PubSub: Didn't receive a PONG response in time, reconnecting to obtain a connection to a different server.");
                        this.reconnect();
                        break;
                    }
                    if (!WebsocketConnectionState.CONNECTED.equals((Object)this.connection.getConnectionState()) || (command = (String)this.commandQueue.poll()) == null) break;
                    this.sendCommand(command);
                    if (!log.isDebugEnabled()) continue;
                    Matcher matcher = LISTEN_AUTH_TOKEN.matcher(command);
                    String cmd = matcher.find() ? matcher.group(1) + "\u2022\u2022\u2022" + matcher.group(2) : command;
                    log.debug("Processed command from queue: [{}].", (Object)cmd);
                }
                catch (Exception ex) {
                    log.error("PubSub: Unexpected error in worker thread", (Throwable)ex);
                    break;
                }
            }
            this.flushRequested.set(false);
            this.flushing.set(false);
        };
        this.queueTask = taskExecutor.scheduleWithFixedDelay(this.flushCommand, 0L, 2500L, TimeUnit.MILLISECONDS);
        log.debug("PubSub: Started Queue Worker Thread");
    }

    public void connect() {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.$lock;
        synchronized (object) {
            this.connection.reconnect();
        }
    }

    protected void onPreConnect() {
        this.lastPong = TimeUtils.getCurrentTimeInMillis();
        this.lastPing = this.lastPong - 240000L;
    }

    protected void onConnected() {
        log.info("Connected to Twitch PubSub {}", (Object)WEB_SOCKET_SERVER);
        this.subscribedTopics.forEach(this::queueRequest);
    }

    protected void onTextMessage(String text) {
        try {
            log.trace("Received WebSocketMessage: " + text);
            PubSubResponse message = (PubSubResponse)TypeConvert.jsonToObject((String)text, PubSubResponse.class);
            if (message.getType().equals((Object)PubSubType.MESSAGE)) {
                String topic = message.getData().getTopic();
                String[] topicParts = StringUtils.split((String)topic, (char)'.');
                String topicName = topicParts[0];
                String lastTopicIdentifier = topicParts[topicParts.length - 1];
                String type = message.getData().getMessage().getType();
                JsonNode msgData = message.getData().getMessage().getMessageData();
                String rawMessage = message.getData().getMessage().getRawMessage();
                if ("channel-bits-events-v2".equals(topicName)) {
                    this.eventManager.publish((Object)new ChannelBitsEvent((ChannelBitsData)TypeConvert.convertValue((Object)msgData, ChannelBitsData.class)));
                } else if ("channel-bits-badge-unlocks".equals(topicName)) {
                    this.eventManager.publish((Object)new ChannelBitsBadgeUnlockEvent((BitsBadgeData)TypeConvert.jsonToObject((String)rawMessage, BitsBadgeData.class)));
                } else if ("channel-subscribe-events-v1".equals(topicName)) {
                    this.eventManager.publish((Object)new ChannelSubscribeEvent((SubscriptionData)TypeConvert.jsonToObject((String)rawMessage, SubscriptionData.class)));
                } else if ("channel-commerce-events-v1".equals(topicName)) {
                    this.eventManager.publish((Object)new ChannelCommerceEvent((CommerceData)TypeConvert.jsonToObject((String)rawMessage, CommerceData.class)));
                } else if ("whispers".equals(topicName) && (type.equals("whisper_sent") || type.equals("whisper_received"))) {
                    JsonNode msgDataParsed = (JsonNode)TypeConvert.jsonToObject((String)msgData.asText(), JsonNode.class);
                    Map tags = (Map)TypeConvert.convertValue((Object)msgDataParsed.path("tags"), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    String fromId = msgDataParsed.get("from_id").asText();
                    String displayName = (String)tags.get("display_name");
                    EventUser eventUser = new EventUser(fromId, displayName);
                    String body = msgDataParsed.get("body").asText();
                    Set permissions = TwitchUtils.getPermissionsFromTags((Map)tags, new HashMap(), (String)fromId, this.botOwnerIds);
                    PrivateMessageEvent privateMessageEvent = new PrivateMessageEvent(eventUser, body, permissions);
                    this.eventManager.publish((Object)privateMessageEvent);
                } else if ("automod-levels-modification".equals(topicName) && topicParts.length > 1) {
                    if ("automod_levels_modified".equals(type)) {
                        AutomodLevelsModified data = (AutomodLevelsModified)TypeConvert.convertValue((Object)msgData, AutomodLevelsModified.class);
                        this.eventManager.publish((Object)new AutomodLevelsModifiedEvent(lastTopicIdentifier, data));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("automod-queue".equals(topicName)) {
                    if (topicParts.length == 3 && "automod_caught_message".equalsIgnoreCase(type)) {
                        AutomodCaughtMessageData data = (AutomodCaughtMessageData)TypeConvert.convertValue((Object)msgData, AutomodCaughtMessageData.class);
                        this.eventManager.publish((Object)new AutomodCaughtMessageEvent(topicParts[2], data));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("community-boost-events-v1".equals(topicName)) {
                    if ("community-boost-progression".equals(type)) {
                        CommunityBoostProgression progression = (CommunityBoostProgression)TypeConvert.convertValue((Object)msgData, CommunityBoostProgression.class);
                        this.eventManager.publish((Object)new CommunityBoostProgressionEvent(progression));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("community-points-channel-v1".equals(topicName) || "channel-points-channel-v1".equals(topicName)) {
                    String timestampText = msgData.path("timestamp").asText();
                    Instant instant = Instant.parse(timestampText);
                    switch (type) {
                        case "reward-redeemed": {
                            ChannelPointsRedemption redemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                            this.eventManager.publish((Object)new RewardRedeemedEvent(instant, redemption));
                            break;
                        }
                        case "redemption-status-update": {
                            ChannelPointsRedemption updatedRedemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                            this.eventManager.publish((Object)new RedemptionStatusUpdateEvent(instant, updatedRedemption));
                            break;
                        }
                        case "custom-reward-created": {
                            ChannelPointsReward newReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("new_reward"), ChannelPointsReward.class);
                            this.eventManager.publish((Object)new CustomRewardCreatedEvent(instant, newReward));
                            break;
                        }
                        case "custom-reward-updated": {
                            ChannelPointsReward updatedReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("updated_reward"), ChannelPointsReward.class);
                            this.eventManager.publish((Object)new CustomRewardUpdatedEvent(instant, updatedReward));
                            break;
                        }
                        case "custom-reward-deleted": {
                            ChannelPointsReward deletedReward = (ChannelPointsReward)TypeConvert.convertValue((Object)msgData.path("deleted_reward"), ChannelPointsReward.class);
                            this.eventManager.publish((Object)new CustomRewardDeletedEvent(instant, deletedReward));
                            break;
                        }
                        case "update-redemption-statuses-progress": {
                            RedemptionProgress redemptionProgress = (RedemptionProgress)TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                            this.eventManager.publish((Object)new UpdateRedemptionProgressEvent(instant, redemptionProgress));
                            break;
                        }
                        case "update-redemption-statuses-finished": {
                            RedemptionProgress redemptionFinished = (RedemptionProgress)TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                            this.eventManager.publish((Object)new UpdateRedemptionFinishedEvent(instant, redemptionFinished));
                            break;
                        }
                        case "community-goal-contribution": {
                            CommunityGoalContribution contribution = (CommunityGoalContribution)TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                            this.eventManager.publish((Object)new CommunityGoalContributionEvent(instant, contribution));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("creator-goals-events-v1".equals(topicName)) {
                    CreatorGoal creatorGoal = (CreatorGoal)TypeConvert.convertValue((Object)msgData.path("goal"), CreatorGoal.class);
                    this.eventManager.publish((Object)new CreatorGoalEvent(lastTopicIdentifier, type, creatorGoal));
                } else if ("crowd-chant-channel-v1".equals(topicName)) {
                    if ("crowd-chant-created".equals(type)) {
                        CrowdChantCreatedEvent event = (CrowdChantCreatedEvent)((Object)TypeConvert.convertValue((Object)msgData, CrowdChantCreatedEvent.class));
                        this.eventManager.publish((Object)event);
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("raid".equals(topicName)) {
                    switch (type) {
                        case "raid_go_v2": {
                            this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidGoEvent.class));
                            break;
                        }
                        case "raid_update_v2": {
                            this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidUpdateEvent.class));
                            break;
                        }
                        case "raid_cancel_v2": {
                            this.eventManager.publish(TypeConvert.jsonToObject((String)rawMessage, RaidCancelEvent.class));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("charity-campaign-donation-events-v1".equals(topicName) && topicParts.length > 1) {
                    switch (type) {
                        case "charity_campaign_donation": {
                            CharityDonationData donation = (CharityDonationData)TypeConvert.jsonToObject((String)rawMessage, CharityDonationData.class);
                            this.eventManager.publish((Object)new CharityCampaignDonationEvent(lastTopicIdentifier, donation));
                            break;
                        }
                        case "charity_campaign_status": {
                            CharityCampaignStatus status = (CharityCampaignStatus)TypeConvert.jsonToObject((String)rawMessage, CharityCampaignStatus.class);
                            this.eventManager.publish((Object)new CharityCampaignStatusEvent(lastTopicIdentifier, status));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("chat_moderator_actions".equals(topicName) && topicParts.length > 1) {
                    switch (type) {
                        case "moderation_action": {
                            ChatModerationAction modAction = (ChatModerationAction)TypeConvert.convertValue((Object)msgData, ChatModerationAction.class);
                            this.eventManager.publish((Object)new ChatModerationEvent(lastTopicIdentifier, modAction));
                            break;
                        }
                        case "channel_terms_action": {
                            ChannelTermsAction termsAction = (ChannelTermsAction)TypeConvert.convertValue((Object)msgData, ChannelTermsAction.class);
                            this.eventManager.publish((Object)new ChannelTermsEvent(lastTopicIdentifier, termsAction));
                            break;
                        }
                        case "approve_unban_request": 
                        case "deny_unban_request": {
                            ModeratorUnbanRequestAction unbanRequestAction = (ModeratorUnbanRequestAction)TypeConvert.convertValue((Object)msgData, ModeratorUnbanRequestAction.class);
                            this.eventManager.publish((Object)new ModUnbanRequestActionEvent(lastTopicIdentifier, unbanRequestAction));
                            break;
                        }
                        case "moderator_added": 
                        case "moderator_removed": 
                        case "vip_added": 
                        case "vip_removed": {
                            ChatModerationAction.ModerationAction act = "moderator_added".equals(type) ? ChatModerationAction.ModerationAction.MOD : ("moderator_removed".equals(type) ? ChatModerationAction.ModerationAction.UNMOD : ("vip_added".equals(type) ? ChatModerationAction.ModerationAction.VIP : ChatModerationAction.ModerationAction.UNVIP));
                            String targetUserId = msgData.path("target_user_id").asText();
                            String targetUserName = msgData.path("target_user_login").asText();
                            String createdByUserId = msgData.path("created_by_user_id").asText();
                            String createdBy = msgData.path("created_by").asText();
                            ChatModerationAction action = new ChatModerationAction("chat_login_moderation", act, Collections.singletonList(targetUserName), createdBy, createdByUserId, "", targetUserId, targetUserName, false);
                            this.eventManager.publish((Object)new ChatModerationEvent(lastTopicIdentifier, action));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("chatrooms-user-v1".equals(topicName) && topicParts.length > 1) {
                    String userId = topicParts[1];
                    switch (type) {
                        case "channel_banned_alias_restriction_update": {
                            AliasRestrictionUpdateData aliasData = (AliasRestrictionUpdateData)TypeConvert.convertValue((Object)msgData, AliasRestrictionUpdateData.class);
                            this.eventManager.publish((Object)new AliasRestrictionUpdateEvent(userId, aliasData));
                            break;
                        }
                        case "user_moderation_action": {
                            UserModerationActionData actionData = (UserModerationActionData)TypeConvert.convertValue((Object)msgData, UserModerationActionData.class);
                            this.eventManager.publish((Object)new UserModerationActionEvent(userId, actionData));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("following".equals(topicName) && topicParts.length > 1) {
                    FollowingData data = (FollowingData)TypeConvert.jsonToObject((String)rawMessage, FollowingData.class);
                    this.eventManager.publish((Object)new FollowingEvent(lastTopicIdentifier, data));
                } else if ("hype-train-events-v1".equals(topicName) && topicParts.length > 2 && "rewards".equals(topicParts[1])) {
                    this.eventManager.publish((Object)new HypeTrainRewardsEvent((HypeTrainRewardsData)TypeConvert.convertValue((Object)msgData, HypeTrainRewardsData.class)));
                } else if ("hype-train-events-v1".equals(topicName) && topicParts.length > 1) {
                    switch (type) {
                        case "hype-train-approaching": {
                            HypeTrainApproaching approachData = (HypeTrainApproaching)TypeConvert.convertValue((Object)msgData, HypeTrainApproaching.class);
                            this.eventManager.publish((Object)new HypeTrainApproachingEvent(approachData));
                            break;
                        }
                        case "hype-train-start": {
                            HypeTrainStart startData = (HypeTrainStart)TypeConvert.convertValue((Object)msgData, HypeTrainStart.class);
                            this.eventManager.publish((Object)new HypeTrainStartEvent(startData));
                            break;
                        }
                        case "hype-train-progression": {
                            HypeProgression progressionData = (HypeProgression)TypeConvert.convertValue((Object)msgData, HypeProgression.class);
                            this.eventManager.publish((Object)new HypeTrainProgressionEvent(lastTopicIdentifier, progressionData));
                            break;
                        }
                        case "hype-train-level-up": {
                            HypeLevelUp levelUpData = (HypeLevelUp)TypeConvert.convertValue((Object)msgData, HypeLevelUp.class);
                            this.eventManager.publish((Object)new HypeTrainLevelUpEvent(lastTopicIdentifier, levelUpData));
                            break;
                        }
                        case "hype-train-end": {
                            HypeTrainEnd endData = (HypeTrainEnd)TypeConvert.convertValue((Object)msgData, HypeTrainEnd.class);
                            this.eventManager.publish((Object)new HypeTrainEndEvent(lastTopicIdentifier, endData));
                            break;
                        }
                        case "hype-train-conductor-update": {
                            HypeTrainConductor conductorData = (HypeTrainConductor)TypeConvert.convertValue((Object)msgData, HypeTrainConductor.class);
                            this.eventManager.publish((Object)new HypeTrainConductorUpdateEvent(lastTopicIdentifier, conductorData));
                            break;
                        }
                        case "hype-train-cooldown-expiration": {
                            this.eventManager.publish((Object)new HypeTrainCooldownExpirationEvent(lastTopicIdentifier));
                            break;
                        }
                        case "last-x-experiment-event": {
                            SupportActivityFeedData lastData = (SupportActivityFeedData)TypeConvert.convertValue((Object)msgData, SupportActivityFeedData.class);
                            this.eventManager.publish((Object)new SupportActivityFeedEvent(lastTopicIdentifier, lastData));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("community-points-user-v1".equals(topicName)) {
                    switch (type) {
                        case "points-earned": {
                            ChannelPointsEarned pointsEarned = (ChannelPointsEarned)TypeConvert.convertValue((Object)msgData, ChannelPointsEarned.class);
                            this.eventManager.publish((Object)new PointsEarnedEvent(pointsEarned));
                            break;
                        }
                        case "claim-available": {
                            ClaimData claimAvailable = (ClaimData)TypeConvert.convertValue((Object)msgData, ClaimData.class);
                            this.eventManager.publish((Object)new ClaimAvailableEvent(claimAvailable));
                            break;
                        }
                        case "claim-claimed": {
                            ClaimData claimClaimed = (ClaimData)TypeConvert.convertValue((Object)msgData, ClaimData.class);
                            this.eventManager.publish((Object)new ClaimClaimedEvent(claimClaimed));
                            break;
                        }
                        case "points-spent": {
                            PointsSpent pointsSpent = (PointsSpent)TypeConvert.convertValue((Object)msgData, PointsSpent.class);
                            this.eventManager.publish((Object)new PointsSpentEvent(pointsSpent));
                            break;
                        }
                        case "reward-redeemed": {
                            ChannelPointsRedemption redemption = (ChannelPointsRedemption)TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                            this.eventManager.publish((Object)new RewardRedeemedEvent(Instant.parse(msgData.path("timestamp").asText()), redemption));
                            break;
                        }
                        case "community-goal-contribution": {
                            CommunityGoalContribution goal = (CommunityGoalContribution)TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                            Instant instant = Instant.parse(msgData.path("timestamp").textValue());
                            this.eventManager.publish((Object)new UserCommunityGoalContributionEvent(lastTopicIdentifier, instant, goal));
                            break;
                        }
                        case "global-last-viewed-content-updated": 
                        case "channel-last-viewed-content-updated": {
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("leaderboard-events-v1".equals(topicName)) {
                    Leaderboard leaderboard = (Leaderboard)TypeConvert.jsonToObject((String)rawMessage, Leaderboard.class);
                    switch (leaderboard.getIdentifier().getDomain()) {
                        case "bits-usage-by-channel-v1": {
                            this.eventManager.publish((Object)new BitsLeaderboardEvent(leaderboard));
                            break;
                        }
                        case "sub-gifts-sent": {
                            this.eventManager.publish((Object)new SubLeaderboardEvent(leaderboard));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("user-moderation-notifications".equals(topicName)) {
                    if (topicParts.length == 3 && "automod_caught_message".equalsIgnoreCase(type)) {
                        UserAutomodCaughtMessage data = (UserAutomodCaughtMessage)TypeConvert.convertValue((Object)msgData, UserAutomodCaughtMessage.class);
                        this.eventManager.publish((Object)new UserAutomodCaughtMessageEvent(topicParts[1], topicParts[2], data));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("polls".equals(topicName)) {
                    PollData pollData = (PollData)TypeConvert.convertValue((Object)msgData.path("poll"), PollData.class);
                    this.eventManager.publish((Object)new PollsEvent(type, pollData));
                } else if ("predictions-channel-v1".equals(topicName)) {
                    if ("event-created".equals(type)) {
                        this.eventManager.publish(TypeConvert.convertValue((Object)msgData, PredictionCreatedEvent.class));
                    } else if ("event-updated".equals(type)) {
                        this.eventManager.publish(TypeConvert.convertValue((Object)msgData, PredictionUpdatedEvent.class));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("predictions-user-v1".equals(topicName)) {
                    if ("prediction-made".equals(type)) {
                        this.eventManager.publish(TypeConvert.convertValue((Object)msgData, UserPredictionMadeEvent.class));
                    } else if ("prediction-result".equals(type)) {
                        this.eventManager.publish(TypeConvert.convertValue((Object)msgData, UserPredictionResultEvent.class));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("friendship".equals(topicName)) {
                    this.eventManager.publish((Object)new FriendshipEvent((FriendshipData)TypeConvert.jsonToObject((String)rawMessage, FriendshipData.class)));
                } else if ("presence".equals(topicName) && topicParts.length > 1) {
                    if ("presence".equalsIgnoreCase(type)) {
                        this.eventManager.publish((Object)new UserPresenceEvent((PresenceData)TypeConvert.convertValue((Object)msgData, PresenceData.class)));
                    } else if ("settings".equalsIgnoreCase(type)) {
                        PresenceSettings presenceSettings = (PresenceSettings)TypeConvert.convertValue((Object)msgData, PresenceSettings.class);
                        this.eventManager.publish((Object)new PresenceSettingsEvent(lastTopicIdentifier, presenceSettings));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("radio-events-v1".equals(topicName)) {
                    this.eventManager.publish((Object)new RadioEvent((RadioData)TypeConvert.jsonToObject((String)rawMessage, RadioData.class)));
                } else if ("shield-mode".equals(topicName) && topicParts.length == 3) {
                    String userId = topicParts[1];
                    String channelId = topicParts[2];
                    switch (type) {
                        case "ADD_AUTOBAN_TERM": {
                            BannedTermAdded termAdded = (BannedTermAdded)TypeConvert.convertValue((Object)msgData, BannedTermAdded.class);
                            this.eventManager.publish((Object)new ShieldModeBannedTermAddedEvent(userId, channelId, termAdded));
                            break;
                        }
                        case "REMOVE_AUTOBAN_TERM": {
                            BannedTermRemoved termRemoved = (BannedTermRemoved)TypeConvert.convertValue((Object)msgData, BannedTermRemoved.class);
                            this.eventManager.publish((Object)new ShieldModeBannedTermRemovedEvent(userId, channelId, termRemoved));
                            break;
                        }
                        case "UPDATE_CHANNEL_MODERATION_MODE": {
                            ShieldModeStatus shieldModeStatus = (ShieldModeStatus)TypeConvert.convertValue((Object)msgData, ShieldModeStatus.class);
                            this.eventManager.publish((Object)new ShieldModeStatusUpdatedEvent(userId, channelId, shieldModeStatus));
                            break;
                        }
                        case "UPDATE_CHANNEL_MODERATION_SETTINGS": {
                            ShieldModeSettings shieldModeSettings = (ShieldModeSettings)TypeConvert.convertValue((Object)msgData, ShieldModeSettings.class);
                            this.eventManager.publish((Object)new ShieldModeSettingsUpdatedEvent(userId, channelId, shieldModeSettings));
                            break;
                        }
                        case "UPDATE_CHANNEL_MODERATION_MODE_SHORTCUT": {
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if ("shoutout".equals(topicName)) {
                    if ("create".equalsIgnoreCase(type)) {
                        CreateShoutoutData shoutoutInfo = (CreateShoutoutData)TypeConvert.convertValue((Object)msgData, CreateShoutoutData.class);
                        this.eventManager.publish((Object)new ShoutoutCreatedEvent(lastTopicIdentifier, shoutoutInfo));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("channel-sub-gifts-v1".equals(topicName)) {
                    this.eventManager.publish((Object)new ChannelSubGiftEvent((SubGiftData)TypeConvert.jsonToObject((String)rawMessage, SubGiftData.class)));
                } else if ("channel-cheer-events-public-v1".equals(topicName) && topicParts.length > 1) {
                    if ("cheerbomb".equalsIgnoreCase(type)) {
                        CheerbombData cheerbomb = (CheerbombData)TypeConvert.convertValue((Object)msgData, CheerbombData.class);
                        this.eventManager.publish((Object)new CheerbombEvent(lastTopicIdentifier, cheerbomb));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("low-trust-users".equals(topicName) && topicParts.length == 3) {
                    String userId = topicParts[1];
                    String channelId = topicParts[2];
                    if ("low_trust_user_new_message".equals(type)) {
                        this.eventManager.publish((Object)new LowTrustUserNewMessageEvent(userId, channelId, (LowTrustUserNewMessage)TypeConvert.convertValue((Object)msgData, LowTrustUserNewMessage.class)));
                    } else if ("low_trust_user_treatment_update".equals(type)) {
                        this.eventManager.publish((Object)new LowTrustUserTreatmentUpdateEvent(userId, channelId, (LowTrustUserTreatmentUpdate)TypeConvert.convertValue((Object)msgData, LowTrustUserTreatmentUpdate.class)));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("onsite-notifications".equals(topicName) && topicParts.length > 1) {
                    if ("create-notification".equalsIgnoreCase(type)) {
                        this.eventManager.publish((Object)new OnsiteNotificationCreationEvent((CreateNotificationData)TypeConvert.convertValue((Object)msgData, CreateNotificationData.class)));
                    } else if ("update-summary".equalsIgnoreCase(type)) {
                        UpdateSummaryData data = (UpdateSummaryData)TypeConvert.convertValue((Object)msgData, UpdateSummaryData.class);
                        this.eventManager.publish((Object)new UpdateOnsiteNotificationSummaryEvent(lastTopicIdentifier, data));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("pinned-chat-updates-v1".equals(topicName)) {
                    switch (type) {
                        case "pin-message": {
                            PinnedChatData createdPin = (PinnedChatData)TypeConvert.convertValue((Object)msgData, PinnedChatData.class);
                            this.eventManager.publish((Object)new PinnedChatCreatedEvent(lastTopicIdentifier, createdPin));
                            break;
                        }
                        case "update-message": {
                            UpdatedPinnedChatTiming updatedPin = (UpdatedPinnedChatTiming)TypeConvert.convertValue((Object)msgData, UpdatedPinnedChatTiming.class);
                            this.eventManager.publish((Object)new PinnedChatTimingUpdatedEvent(lastTopicIdentifier, updatedPin));
                            break;
                        }
                        case "unpin-message": {
                            DeletePinnedChatData deletePin = (DeletePinnedChatData)TypeConvert.convertValue((Object)msgData, DeletePinnedChatData.class);
                            this.eventManager.publish((Object)new PinnedChatDeletedEvent(lastTopicIdentifier, deletePin));
                            break;
                        }
                        default: {
                            log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                            break;
                        }
                    }
                } else if (("video-playback-by-id".equals(topicName) || "video-playback".equals(topicName)) && topicParts.length > 1) {
                    boolean hasId = topicName.endsWith("d");
                    VideoPlaybackData data = (VideoPlaybackData)TypeConvert.jsonToObject((String)rawMessage, VideoPlaybackData.class);
                    this.eventManager.publish((Object)new VideoPlaybackEvent(hasId ? lastTopicIdentifier : null, hasId ? null : lastTopicIdentifier, data));
                } else if ("channel-unban-requests".equals(topicName) && topicParts.length == 3) {
                    String userId = topicParts[1];
                    String channelId = topicParts[2];
                    if ("create_unban_request".equals(type)) {
                        CreatedUnbanRequest request = (CreatedUnbanRequest)TypeConvert.convertValue((Object)msgData, CreatedUnbanRequest.class);
                        this.eventManager.publish((Object)new ChannelUnbanRequestCreateEvent(userId, channelId, request));
                    } else if ("update_unban_request".equals(type)) {
                        UpdatedUnbanRequest request = (UpdatedUnbanRequest)TypeConvert.convertValue((Object)msgData, UpdatedUnbanRequest.class);
                        this.eventManager.publish((Object)new ChannelUnbanRequestUpdateEvent(userId, channelId, request));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else if ("user-unban-requests".equals(topicName) && topicParts.length == 3) {
                    String userId = topicParts[1];
                    String channelId = topicParts[2];
                    if ("update_unban_request".equals(type)) {
                        UpdatedUnbanRequest request = (UpdatedUnbanRequest)TypeConvert.convertValue((Object)msgData, UpdatedUnbanRequest.class);
                        this.eventManager.publish((Object)new UserUnbanRequestUpdateEvent(userId, channelId, request));
                    } else {
                        log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                    }
                } else {
                    log.warn("Unparsable Message: " + (Object)((Object)message.getType()) + "|" + message.getData());
                }
            } else if (message.getType().equals((Object)PubSubType.RESPONSE)) {
                Supplier<PubSubRequest> findListenRequest = () -> {
                    for (PubSubRequest topic : this.subscribedTopics) {
                        if (topic == null || !StringUtils.equals((CharSequence)message.getNonce(), (CharSequence)topic.getNonce())) continue;
                        return topic;
                    }
                    return null;
                };
                this.eventManager.publish((Object)new PubSubListenResponseEvent(message.getNonce(), message.getError(), findListenRequest));
                if (message.getError().length() > 0) {
                    if (message.getError().equalsIgnoreCase("ERR_BADAUTH")) {
                        log.error("PubSub: You used a invalid oauth token to subscribe to the topic. Please use a token that is authorized for the specified channel.");
                    } else {
                        log.error("PubSub: Failed to subscribe to topic - [" + message.getError() + "]");
                    }
                }
            } else if (message.getType().equals((Object)PubSubType.PONG)) {
                log.debug("PubSub: Received PONG response!");
                this.lastPong = TimeUtils.getCurrentTimeInMillis();
            } else if (message.getType().equals((Object)PubSubType.RECONNECT)) {
                log.warn("PubSub: Server instance we're connected to will go down for maintenance soon, reconnecting to obtain a new connection!");
                this.reconnect();
            } else {
                log.debug("PubSub: Unknown Message Type: " + message);
            }
        }
        catch (Exception ex) {
            log.warn("PubSub: Unparsable Message: " + text + " - [" + ex.getMessage() + "]", (Throwable)ex);
        }
    }

    private void sendCommand(String command) {
        if (WebsocketConnectionState.CONNECTED.equals((Object)this.connection.getConnectionState()) || WebsocketConnectionState.CONNECTING.equals((Object)this.connection.getConnectionState())) {
            this.connection.sendText(command);
        } else {
            log.warn("Can't send IRC-WS Command [{}]", (Object)command);
        }
    }

    private void queueRequest(PubSubRequest request) {
        this.commandQueue.add(TypeConvert.objectToJson((Object)request));
        if (!this.flushing.get() && !this.flushRequested.getAndSet(true)) {
            this.taskExecutor.schedule(this.flushCommand, 50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public PubSubSubscription listenOnTopic(PubSubRequest request) {
        if (this.subscribedTopics.add(request)) {
            this.queueRequest(request);
        }
        return new PubSubSubscription(request);
    }

    @Override
    public boolean unsubscribeFromTopic(PubSubSubscription subscription) {
        PubSubRequest request = subscription.getRequest();
        if (request.getType() != PubSubType.LISTEN) {
            log.warn("Cannot unsubscribe using request with unexpected type: {}", (Object)request.getType());
            return false;
        }
        boolean removed = this.subscribedTopics.remove(request);
        if (!removed) {
            log.warn("Not subscribed to topic: {}", (Object)request);
            return false;
        }
        PubSubRequest unlistenRequest = new PubSubRequest();
        unlistenRequest.setType(PubSubType.UNLISTEN);
        unlistenRequest.setNonce(CryptoUtils.generateNonce((int)30));
        unlistenRequest.setData(request.getData());
        this.queueRequest(unlistenRequest);
        return true;
    }

    @Override
    public long getLatency() {
        return this.connection.getLatency();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.heartbeatTask.cancel(false);
            this.queueTask.cancel(false);
            this.connection.close();
        }
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }
}

