/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.github.twitch4j.common.enums.SubscriptionPlan;
import com.github.twitch4j.common.enums.SubscriptionType;
import com.github.twitch4j.pubsub.domain.CommerceMessage;
import java.time.Month;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscriptionData {
    private String userName;
    private String displayName;
    private String channelName;
    private String userId;
    private String channelId;
    private String time;
    private SubscriptionPlan subPlan;
    private String subPlanName;
    @Deprecated
    private Integer months;
    private Integer cumulativeMonths;
    private Integer streakMonths;
    private SubscriptionType context;
    private Boolean isGift;
    private Integer multiMonthDuration;
    private CommerceMessage subMessage;
    private Integer benefitEndMonth;
    private String recipientId;
    private String recipientUserName;
    private String recipientDisplayName;

    public String getRecipientId() {
        return this.recipientId != null ? this.recipientId : this.userId;
    }

    public String getRecipientUserName() {
        return this.recipientUserName != null ? this.recipientUserName : this.userName;
    }

    public String getRecipientDisplayName() {
        return this.recipientDisplayName != null ? this.recipientDisplayName : this.displayName;
    }

    public Month getBenefitEndMonth() {
        return this.benefitEndMonth != null && this.benefitEndMonth > 0 ? Month.of(this.benefitEndMonth) : null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getTime() {
        return this.time;
    }

    public SubscriptionPlan getSubPlan() {
        return this.subPlan;
    }

    public String getSubPlanName() {
        return this.subPlanName;
    }

    @Deprecated
    public Integer getMonths() {
        return this.months;
    }

    public Integer getCumulativeMonths() {
        return this.cumulativeMonths;
    }

    public Integer getStreakMonths() {
        return this.streakMonths;
    }

    public SubscriptionType getContext() {
        return this.context;
    }

    public Boolean getIsGift() {
        return this.isGift;
    }

    public Integer getMultiMonthDuration() {
        return this.multiMonthDuration;
    }

    public CommerceMessage getSubMessage() {
        return this.subMessage;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setSubPlan(SubscriptionPlan subPlan) {
        this.subPlan = subPlan;
    }

    public void setSubPlanName(String subPlanName) {
        this.subPlanName = subPlanName;
    }

    @Deprecated
    public void setMonths(Integer months) {
        this.months = months;
    }

    public void setCumulativeMonths(Integer cumulativeMonths) {
        this.cumulativeMonths = cumulativeMonths;
    }

    public void setStreakMonths(Integer streakMonths) {
        this.streakMonths = streakMonths;
    }

    public void setContext(SubscriptionType context) {
        this.context = context;
    }

    public void setIsGift(Boolean isGift) {
        this.isGift = isGift;
    }

    public void setMultiMonthDuration(Integer multiMonthDuration) {
        this.multiMonthDuration = multiMonthDuration;
    }

    public void setSubMessage(CommerceMessage subMessage) {
        this.subMessage = subMessage;
    }

    public void setBenefitEndMonth(Integer benefitEndMonth) {
        this.benefitEndMonth = benefitEndMonth;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public void setRecipientUserName(String recipientUserName) {
        this.recipientUserName = recipientUserName;
    }

    public void setRecipientDisplayName(String recipientDisplayName) {
        this.recipientDisplayName = recipientDisplayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionData)) {
            return false;
        }
        SubscriptionData other = (SubscriptionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$channelName = this.getChannelName();
        String other$channelName = other.getChannelName();
        if (this$channelName == null ? other$channelName != null : !this$channelName.equals(other$channelName)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        SubscriptionPlan this$subPlan = this.getSubPlan();
        SubscriptionPlan other$subPlan = other.getSubPlan();
        if (this$subPlan == null ? other$subPlan != null : !this$subPlan.equals(other$subPlan)) {
            return false;
        }
        String this$subPlanName = this.getSubPlanName();
        String other$subPlanName = other.getSubPlanName();
        if (this$subPlanName == null ? other$subPlanName != null : !this$subPlanName.equals(other$subPlanName)) {
            return false;
        }
        Integer this$months = this.getMonths();
        Integer other$months = other.getMonths();
        if (this$months == null ? other$months != null : !((Object)this$months).equals(other$months)) {
            return false;
        }
        Integer this$cumulativeMonths = this.getCumulativeMonths();
        Integer other$cumulativeMonths = other.getCumulativeMonths();
        if (this$cumulativeMonths == null ? other$cumulativeMonths != null : !((Object)this$cumulativeMonths).equals(other$cumulativeMonths)) {
            return false;
        }
        Integer this$streakMonths = this.getStreakMonths();
        Integer other$streakMonths = other.getStreakMonths();
        if (this$streakMonths == null ? other$streakMonths != null : !((Object)this$streakMonths).equals(other$streakMonths)) {
            return false;
        }
        SubscriptionType this$context = this.getContext();
        SubscriptionType other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        Boolean this$isGift = this.getIsGift();
        Boolean other$isGift = other.getIsGift();
        if (this$isGift == null ? other$isGift != null : !((Object)this$isGift).equals(other$isGift)) {
            return false;
        }
        Integer this$multiMonthDuration = this.getMultiMonthDuration();
        Integer other$multiMonthDuration = other.getMultiMonthDuration();
        if (this$multiMonthDuration == null ? other$multiMonthDuration != null : !((Object)this$multiMonthDuration).equals(other$multiMonthDuration)) {
            return false;
        }
        CommerceMessage this$subMessage = this.getSubMessage();
        CommerceMessage other$subMessage = other.getSubMessage();
        if (this$subMessage == null ? other$subMessage != null : !((Object)this$subMessage).equals(other$subMessage)) {
            return false;
        }
        Month this$benefitEndMonth = this.getBenefitEndMonth();
        Month other$benefitEndMonth = other.getBenefitEndMonth();
        if (this$benefitEndMonth == null ? other$benefitEndMonth != null : !this$benefitEndMonth.equals(other$benefitEndMonth)) {
            return false;
        }
        String this$recipientId = this.getRecipientId();
        String other$recipientId = other.getRecipientId();
        if (this$recipientId == null ? other$recipientId != null : !this$recipientId.equals(other$recipientId)) {
            return false;
        }
        String this$recipientUserName = this.getRecipientUserName();
        String other$recipientUserName = other.getRecipientUserName();
        if (this$recipientUserName == null ? other$recipientUserName != null : !this$recipientUserName.equals(other$recipientUserName)) {
            return false;
        }
        String this$recipientDisplayName = this.getRecipientDisplayName();
        String other$recipientDisplayName = other.getRecipientDisplayName();
        return !(this$recipientDisplayName == null ? other$recipientDisplayName != null : !this$recipientDisplayName.equals(other$recipientDisplayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $channelName = this.getChannelName();
        result = result * 59 + ($channelName == null ? 43 : $channelName.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        SubscriptionPlan $subPlan = this.getSubPlan();
        result = result * 59 + ($subPlan == null ? 43 : $subPlan.hashCode());
        String $subPlanName = this.getSubPlanName();
        result = result * 59 + ($subPlanName == null ? 43 : $subPlanName.hashCode());
        Integer $months = this.getMonths();
        result = result * 59 + ($months == null ? 43 : ((Object)$months).hashCode());
        Integer $cumulativeMonths = this.getCumulativeMonths();
        result = result * 59 + ($cumulativeMonths == null ? 43 : ((Object)$cumulativeMonths).hashCode());
        Integer $streakMonths = this.getStreakMonths();
        result = result * 59 + ($streakMonths == null ? 43 : ((Object)$streakMonths).hashCode());
        SubscriptionType $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        Boolean $isGift = this.getIsGift();
        result = result * 59 + ($isGift == null ? 43 : ((Object)$isGift).hashCode());
        Integer $multiMonthDuration = this.getMultiMonthDuration();
        result = result * 59 + ($multiMonthDuration == null ? 43 : ((Object)$multiMonthDuration).hashCode());
        CommerceMessage $subMessage = this.getSubMessage();
        result = result * 59 + ($subMessage == null ? 43 : ((Object)$subMessage).hashCode());
        Month $benefitEndMonth = this.getBenefitEndMonth();
        result = result * 59 + ($benefitEndMonth == null ? 43 : $benefitEndMonth.hashCode());
        String $recipientId = this.getRecipientId();
        result = result * 59 + ($recipientId == null ? 43 : $recipientId.hashCode());
        String $recipientUserName = this.getRecipientUserName();
        result = result * 59 + ($recipientUserName == null ? 43 : $recipientUserName.hashCode());
        String $recipientDisplayName = this.getRecipientDisplayName();
        result = result * 59 + ($recipientDisplayName == null ? 43 : $recipientDisplayName.hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionData(userName=" + this.getUserName() + ", displayName=" + this.getDisplayName() + ", channelName=" + this.getChannelName() + ", userId=" + this.getUserId() + ", channelId=" + this.getChannelId() + ", time=" + this.getTime() + ", subPlan=" + this.getSubPlan() + ", subPlanName=" + this.getSubPlanName() + ", months=" + this.getMonths() + ", cumulativeMonths=" + this.getCumulativeMonths() + ", streakMonths=" + this.getStreakMonths() + ", context=" + this.getContext() + ", isGift=" + this.getIsGift() + ", multiMonthDuration=" + this.getMultiMonthDuration() + ", subMessage=" + this.getSubMessage() + ", benefitEndMonth=" + this.getBenefitEndMonth() + ", recipientId=" + this.getRecipientId() + ", recipientUserName=" + this.getRecipientUserName() + ", recipientDisplayName=" + this.getRecipientDisplayName() + ")";
    }
}

