/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.tmi.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Chatters {
    @JsonProperty(value="chatter_count")
    @NonNull
    private Integer viewerCount;
    @JsonIgnore
    private List<String> vips;
    @JsonIgnore
    private List<String> broadcaster;
    @JsonIgnore
    @Deprecated
    private List<String> staff;
    @JsonIgnore
    @Deprecated
    private List<String> admins;
    @JsonIgnore
    private List<String> moderators;
    @JsonIgnore
    private List<String> viewers;

    @JsonProperty(value="chatters")
    private void unpackMessage(Map<String, List<String>> chatters) {
        this.broadcaster = chatters.get("broadcaster");
        this.vips = chatters.get("vips");
        this.moderators = chatters.get("moderators");
        this.staff = chatters.get("staff");
        this.admins = chatters.get("admins");
        this.viewers = chatters.get("viewers");
    }

    public List<String> getAllViewers() {
        ArrayList<String> newList = new ArrayList<String>(this.viewerCount);
        newList.addAll(this.broadcaster);
        newList.addAll(this.vips);
        newList.addAll(this.moderators);
        newList.addAll(this.staff);
        newList.addAll(this.admins);
        newList.addAll(this.viewers);
        return newList;
    }

    @NonNull
    public Integer getViewerCount() {
        return this.viewerCount;
    }

    public List<String> getVips() {
        return this.vips;
    }

    public List<String> getBroadcaster() {
        return this.broadcaster;
    }

    @Deprecated
    public List<String> getStaff() {
        return this.staff;
    }

    @Deprecated
    public List<String> getAdmins() {
        return this.admins;
    }

    public List<String> getModerators() {
        return this.moderators;
    }

    public List<String> getViewers() {
        return this.viewers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chatters)) {
            return false;
        }
        Chatters other = (Chatters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$viewerCount = this.getViewerCount();
        Integer other$viewerCount = other.getViewerCount();
        if (this$viewerCount == null ? other$viewerCount != null : !((Object)this$viewerCount).equals(other$viewerCount)) {
            return false;
        }
        List<String> this$vips = this.getVips();
        List<String> other$vips = other.getVips();
        if (this$vips == null ? other$vips != null : !((Object)this$vips).equals(other$vips)) {
            return false;
        }
        List<String> this$broadcaster = this.getBroadcaster();
        List<String> other$broadcaster = other.getBroadcaster();
        if (this$broadcaster == null ? other$broadcaster != null : !((Object)this$broadcaster).equals(other$broadcaster)) {
            return false;
        }
        List<String> this$staff = this.getStaff();
        List<String> other$staff = other.getStaff();
        if (this$staff == null ? other$staff != null : !((Object)this$staff).equals(other$staff)) {
            return false;
        }
        List<String> this$admins = this.getAdmins();
        List<String> other$admins = other.getAdmins();
        if (this$admins == null ? other$admins != null : !((Object)this$admins).equals(other$admins)) {
            return false;
        }
        List<String> this$moderators = this.getModerators();
        List<String> other$moderators = other.getModerators();
        if (this$moderators == null ? other$moderators != null : !((Object)this$moderators).equals(other$moderators)) {
            return false;
        }
        List<String> this$viewers = this.getViewers();
        List<String> other$viewers = other.getViewers();
        return !(this$viewers == null ? other$viewers != null : !((Object)this$viewers).equals(other$viewers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chatters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $viewerCount = this.getViewerCount();
        result = result * 59 + ($viewerCount == null ? 43 : ((Object)$viewerCount).hashCode());
        List<String> $vips = this.getVips();
        result = result * 59 + ($vips == null ? 43 : ((Object)$vips).hashCode());
        List<String> $broadcaster = this.getBroadcaster();
        result = result * 59 + ($broadcaster == null ? 43 : ((Object)$broadcaster).hashCode());
        List<String> $staff = this.getStaff();
        result = result * 59 + ($staff == null ? 43 : ((Object)$staff).hashCode());
        List<String> $admins = this.getAdmins();
        result = result * 59 + ($admins == null ? 43 : ((Object)$admins).hashCode());
        List<String> $moderators = this.getModerators();
        result = result * 59 + ($moderators == null ? 43 : ((Object)$moderators).hashCode());
        List<String> $viewers = this.getViewers();
        result = result * 59 + ($viewers == null ? 43 : ((Object)$viewers).hashCode());
        return result;
    }

    public String toString() {
        return "Chatters(viewerCount=" + this.getViewerCount() + ", vips=" + this.getVips() + ", broadcaster=" + this.getBroadcaster() + ", staff=" + this.getStaff() + ", admins=" + this.getAdmins() + ", moderators=" + this.getModerators() + ", viewers=" + this.getViewers() + ")";
    }

    @JsonProperty(value="chatter_count")
    private void setViewerCount(@NonNull Integer viewerCount) {
        if (viewerCount == null) {
            throw new NullPointerException("viewerCount is marked non-null but is null");
        }
        this.viewerCount = viewerCount;
    }

    private void setVips(List<String> vips) {
        this.vips = vips;
    }

    private void setBroadcaster(List<String> broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Deprecated
    private void setStaff(List<String> staff) {
        this.staff = staff;
    }

    @Deprecated
    private void setAdmins(List<String> admins) {
        this.admins = admins;
    }

    private void setModerators(List<String> moderators) {
        this.moderators = moderators;
    }

    private void setViewers(List<String> viewers) {
        this.viewers = viewers;
    }
}

