/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.kraken;

import com.github.twitch4j.kraken.domain.KrakenBlockList;
import com.github.twitch4j.kraken.domain.KrakenBlockTransaction;
import com.github.twitch4j.kraken.domain.KrakenChannel;
import com.github.twitch4j.kraken.domain.KrakenClip;
import com.github.twitch4j.kraken.domain.KrakenCreatedVideo;
import com.github.twitch4j.kraken.domain.KrakenEmoticonSetList;
import com.github.twitch4j.kraken.domain.KrakenFollowList;
import com.github.twitch4j.kraken.domain.KrakenIngestList;
import com.github.twitch4j.kraken.domain.KrakenSubscriptionList;
import com.github.twitch4j.kraken.domain.KrakenTeam;
import com.github.twitch4j.kraken.domain.KrakenTeamList;
import com.github.twitch4j.kraken.domain.KrakenUser;
import com.github.twitch4j.kraken.domain.KrakenUserList;
import com.github.twitch4j.kraken.domain.KrakenVideo;
import com.netflix.hystrix.HystrixCommand;
import feign.Body;
import feign.CollectionFormat;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;

public interface TwitchKraken {
    public static final URI UPLOADS_BASE_URL = ((Supplier<URI>)() -> {
        try {
            return new URI("https://uploads.twitch.tv");
        }
        catch (Exception e) {
            return null;
        }
    }).get();

    @RequestLine(value="GET /channels/{channelId}/editors")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenUserList> getChannelEditors(@Param(value="token") String var1, @Param(value="channelId") String var2);

    @RequestLine(value="GET /channels/{channelId}/follows?limit={limit}&offset={offset}&cursor={cursor}&direction={direction}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenFollowList> getChannelFollowers(@Param(value="channelId") String var1, @Param(value="limit") Integer var2, @Param(value="offset") Integer var3, @Param(value="cursor") String var4, @Param(value="direction") String var5);

    @RequestLine(value="DELETE /channels/{channelId}/stream_key")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenChannel> resetChannelStreamKey(@Param(value="token") String var1, @Param(value="channelId") String var2);

    @RequestLine(value="GET /channels/{channelId}/subscriptions?limit={limit}&offset={offset}&direction={direction}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenSubscriptionList> getChannelSubscribers(@Param(value="token") String var1, @Param(value="channelId") String var2, @Param(value="limit") Integer var3, @Param(value="offset") Integer var4, @Param(value="direction") String var5);

    @RequestLine(value="POST /chat/twitchbot/approve")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json", "Content-Type: application/json"})
    @Body(value="%7B\"msg_id\":\"{msg_id}\"%7D")
    public HystrixCommand<Void> approveAutomodMessage(@Param(value="token") String var1, @Param(value="msg_id") String var2);

    @RequestLine(value="POST /chat/twitchbot/deny")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json", "Content-Type: application/json"})
    @Body(value="%7B\"msg_id\":\"{msg_id}\"%7D")
    public HystrixCommand<Void> denyAutomodMessage(@Param(value="token") String var1, @Param(value="msg_id") String var2);

    @RequestLine(value="GET /clips/{slug}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenClip> getClip(@Param(value="slug") String var1);

    @RequestLine(value="GET /users/{user}/blocks?limit={limit}&offset={offset}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenBlockList> getUserBlockList(@Param(value="token") String var1, @Param(value="user") String var2, @Param(value="limit") Integer var3, @Param(value="offset") Integer var4);

    @RequestLine(value="PUT /users/{from_id}/blocks/{to_id}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenBlockTransaction> blockUser(@Param(value="token") String var1, @Param(value="from_id") String var2, @Param(value="to_id") String var3);

    @RequestLine(value="DELETE /users/{from_id}/blocks/{to_id}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<Void> unblockUser(@Param(value="token") String var1, @Param(value="from_id") String var2, @Param(value="to_id") String var3);

    @RequestLine(value="GET /users/{user}/emotes")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenEmoticonSetList> getUserEmotes(@Param(value="token") String var1, @Param(value="user") String var2);

    @Deprecated
    @RequestLine(value="PUT /users/{user}/follows/channels/{targetUser}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<Object> addFollow(@Param(value="token") String var1, @Param(value="user") String var2, @Param(value="targetUser") String var3);

    @RequestLine(value="GET /ingests")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenIngestList> getIngestServers();

    @RequestLine(value="GET /channels/{channel_id}/teams")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenTeamList> getChannelTeams(@Param(value="channel_id") String var1);

    @RequestLine(value="GET /teams?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenTeamList> getAllTeams(@Param(value="limit") Integer var1, @Param(value="offset") Integer var2);

    @RequestLine(value="GET /teams/{name}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenTeam> getTeamByName(@Param(value="name") String var1);

    @RequestLine(value="GET /user")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenUser> getUser(@Param(value="token") String var1);

    @RequestLine(value="GET /users/{user_id}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenUser> getUserById(@Param(value="user_id") String var1);

    @RequestLine(value="GET /users?login={logins}", collectionFormat=CollectionFormat.CSV)
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenUserList> getUsersByLogin(@Param(value="logins") List<String> var1);

    @Deprecated
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    @RequestLine(value="PUT /channels/{channelId}?channel[status]={title}")
    public HystrixCommand<Object> updateTitle(@Param(value="token") String var1, @Param(value="channelId") String var2, @Param(value="title") String var3);

    @RequestLine(value="POST /videos?channel_id={channel_id}&title={title}&description={description}&game={game}&language={language}&tag_list={tag_list}&viewable={viewable}&viewable_at={viewable_at}", collectionFormat=CollectionFormat.CSV)
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenCreatedVideo> createVideo(@Param(value="token") String var1, @Param(value="channel_id") String var2, @Param(value="title") String var3, @Param(value="description") String var4, @Param(value="game") String var5, @Param(value="language") String var6, @Param(value="tag_list") List<String> var7, @Param(value="viewable") String var8, @Param(value="viewable_at") Instant var9);

    @RequestLine(value="PUT /upload/{video_id}?part={part}&upload_token={upload_token}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json", "Content-Type: application/x-www-form-urlencoded"})
    public HystrixCommand<Void> uploadVideoPart(URI var1, @Param(value="video_id") String var2, @Param(value="upload_token") String var3, @Param(value="part") int var4, byte[] var5);

    default public HystrixCommand<Void> uploadVideoPart(String videoId, String uploadToken, int partIndex, byte[] videoPart) {
        return this.uploadVideoPart(UPLOADS_BASE_URL, videoId, uploadToken, partIndex, videoPart);
    }

    @RequestLine(value="POST /upload/{video_id}/complete?upload_token={upload_token}")
    @Headers(value={"Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<Void> completeVideoUpload(URI var1, @Param(value="video_id") String var2, @Param(value="upload_token") String var3);

    default public HystrixCommand<Void> completeVideoUpload(String videoId, String uploadToken) {
        return this.completeVideoUpload(UPLOADS_BASE_URL, videoId, uploadToken);
    }

    @RequestLine(value="PUT /videos/{video_id}?description={description}&game={game}&language={language}&tag_list={tag_list}&title={title}", collectionFormat=CollectionFormat.CSV)
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<KrakenVideo> updateVideo(@Param(value="token") String var1, @Param(value="video_id") String var2, @Param(value="description") String var3, @Param(value="game") String var4, @Param(value="language") String var5, @Param(value="tag_list") List<String> var6, @Param(value="title") String var7);

    @RequestLine(value="DELETE /videos/{video_id}")
    @Headers(value={"Authorization: OAuth {token}", "Accept: application/vnd.twitchtv.v5+json"})
    public HystrixCommand<Void> deleteVideo(@Param(value="token") String var1, @Param(value="video_id") String var2);
}

