/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.helix.interceptor.TwitchHelixClientIdInterceptor;
import com.github.twitch4j.helix.interceptor.TwitchHelixDecoder;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.okhttp.OkHttpClient;
import io.github.bucket4j.Bucket;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixHttpClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixHttpClient.class);
    private final Client client;
    private final ScheduledExecutorService executor;
    private final TwitchHelixClientIdInterceptor interceptor;
    private final long timeout;

    public TwitchHelixHttpClient(OkHttpClient client, ScheduledThreadPoolExecutor executor, TwitchHelixClientIdInterceptor interceptor, Integer timeout) {
        this.client = client;
        this.executor = executor;
        this.interceptor = interceptor;
        this.timeout = timeout == null ? 60000L : timeout.longValue();
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        OAuth2Credential credential;
        String token = TwitchHelixDecoder.singleFirst((Collection)request.headers().get("Authorization"));
        if (token != null && token.startsWith("Bearer ") && (credential = (OAuth2Credential)this.interceptor.getAccessTokenCache().getIfPresent((Object)token.substring("Bearer ".length()))) != null) {
            Bucket bucket = this.interceptor.getOrInitializeBucket(this.interceptor.getKey(credential));
            if (bucket.tryConsume(1L)) {
                return this.client.execute(request, options);
            }
            try {
                return (Response)((CompletableFuture)bucket.asScheduler().consume(1L, this.executor).thenApplyAsync(v -> {
                    try {
                        return this.client.execute(request, options);
                    }
                    catch (IOException e) {
                        log.error("Helix API call execution failed", (Throwable)e);
                        return null;
                    }
                })).get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error("Throttled Helix API call timed-out before completion", (Throwable)e);
                return null;
            }
        }
        return this.client.execute(request, options);
    }
}

