/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixClientIdInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixClientIdInterceptor.class);
    private final TwitchHelixBuilder twitchAPIBuilder;
    private TwitchIdentityProvider twitchIdentityProvider;
    private final Cache<String, OAuth2Credential> accessTokenCache = Caffeine.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(10000L).build();
    private volatile OAuth2Credential defaultAuthToken;
    private String defaultClientId;

    public TwitchHelixClientIdInterceptor(TwitchHelixBuilder twitchHelixBuilder) {
        this.twitchAPIBuilder = twitchHelixBuilder;
        this.twitchIdentityProvider = new TwitchIdentityProvider(twitchHelixBuilder.getClientId(), twitchHelixBuilder.getClientSecret(), null);
        this.defaultClientId = this.twitchAPIBuilder.getClientId();
        this.defaultAuthToken = twitchHelixBuilder.getDefaultAuthToken();
        if (this.defaultAuthToken != null) {
            this.twitchIdentityProvider.getAdditionalCredentialInformation(this.defaultAuthToken).ifPresent(oauth -> {
                this.defaultClientId = (String)oauth.getContext().get("client_id");
            });
        }
    }

    public void apply(RequestTemplate template) {
        String clientId = this.defaultClientId;
        if (template.headers().containsKey("Authorization")) {
            String oauthToken = ((String)((Collection)template.headers().get("Authorization")).iterator().next()).substring("Bearer ".length());
            if (oauthToken.isEmpty()) {
                String clientSecret = this.twitchAPIBuilder.getClientSecret();
                if (this.defaultAuthToken == null && (StringUtils.isEmpty((CharSequence)clientId) || StringUtils.isEmpty((CharSequence)clientSecret) || clientSecret.charAt(0) == '*')) {
                    throw new RuntimeException("Necessary OAuth token was missing from Helix call, without the means to generate one!");
                }
                try {
                    oauthToken = this.getOrCreateAuthToken().getAccessToken();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to generate an app access token as no oauth token was passed to this Helix call", e);
                }
                template.removeHeader("Authorization");
                template.header("Authorization", new String[]{"Bearer " + oauthToken});
            } else {
                OAuth2Credential verifiedCredential = (OAuth2Credential)this.accessTokenCache.getIfPresent((Object)oauthToken);
                if (verifiedCredential == null) {
                    log.debug("Getting matching client-id for authorization token {}", (Object)oauthToken.substring(0, 5));
                    Optional requestedCredential = this.twitchIdentityProvider.getAdditionalCredentialInformation(new OAuth2Credential("twitch", oauthToken));
                    if (!requestedCredential.isPresent()) {
                        throw new RuntimeException("Failed to get the client_id for the provided authentication token, the authentication token may be invalid!");
                    }
                    verifiedCredential = (OAuth2Credential)requestedCredential.get();
                    this.accessTokenCache.put((Object)oauthToken, (Object)verifiedCredential);
                }
                clientId = (String)verifiedCredential.getContext().get("client_id");
            }
            log.debug("Setting new client-id {} for token {}", (Object)clientId, (Object)oauthToken.substring(0, 5));
        }
        template.header("Client-Id", new String[]{clientId});
        template.header("User-Agent", new String[]{this.twitchAPIBuilder.getUserAgent()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuth2Credential getOrCreateAuthToken() {
        if (this.defaultAuthToken == null) {
            TwitchHelixClientIdInterceptor twitchHelixClientIdInterceptor = this;
            synchronized (twitchHelixClientIdInterceptor) {
                if (this.defaultAuthToken == null) {
                    this.defaultAuthToken = this.twitchIdentityProvider.getAppAccessToken();
                    return this.defaultAuthToken;
                }
            }
        }
        return this.defaultAuthToken;
    }

    public void setTwitchIdentityProvider(TwitchIdentityProvider twitchIdentityProvider) {
        this.twitchIdentityProvider = twitchIdentityProvider;
    }
}

