/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.NonNull;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ModeratorEvent {
    @NonNull
    private String id;
    @NonNull
    private String eventType;
    @JsonProperty(value="event_timestamp")
    @NonNull
    private Instant timestamp;
    @NonNull
    private String version;
    @NonNull
    private ModeratorEventData eventData;

    @JsonIgnore
    @Deprecated
    public LocalDateTime getEventTimestamp() {
        return LocalDateTime.ofInstant(this.timestamp, ZoneOffset.UTC);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getEventType() {
        return this.eventType;
    }

    @NonNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public ModeratorEventData getEventData() {
        return this.eventData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeratorEvent)) {
            return false;
        }
        ModeratorEvent other = (ModeratorEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        ModeratorEventData this$eventData = this.getEventData();
        ModeratorEventData other$eventData = other.getEventData();
        return !(this$eventData == null ? other$eventData != null : !((Object)this$eventData).equals(other$eventData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModeratorEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        ModeratorEventData $eventData = this.getEventData();
        result = result * 59 + ($eventData == null ? 43 : ((Object)$eventData).hashCode());
        return result;
    }

    public String toString() {
        return "ModeratorEvent(id=" + this.getId() + ", eventType=" + this.getEventType() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ", eventData=" + this.getEventData() + ")";
    }

    private void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    private void setEventType(@NonNull String eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        this.eventType = eventType;
    }

    @JsonProperty(value="event_timestamp")
    private void setTimestamp(@NonNull Instant timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp is marked non-null but is null");
        }
        this.timestamp = timestamp;
    }

    private void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    private void setEventData(@NonNull ModeratorEventData eventData) {
        if (eventData == null) {
            throw new NullPointerException("eventData is marked non-null but is null");
        }
        this.eventData = eventData;
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModeratorEventData {
        @NonNull
        private String broadcasterId;
        @NonNull
        private String broadcasterName;
        @NonNull
        private String userId;
        @NonNull
        private String userName;

        @NonNull
        public String getBroadcasterId() {
            return this.broadcasterId;
        }

        @NonNull
        public String getBroadcasterName() {
            return this.broadcasterName;
        }

        @NonNull
        public String getUserId() {
            return this.userId;
        }

        @NonNull
        public String getUserName() {
            return this.userName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModeratorEventData)) {
                return false;
            }
            ModeratorEventData other = (ModeratorEventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$broadcasterId = this.getBroadcasterId();
            String other$broadcasterId = other.getBroadcasterId();
            if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
                return false;
            }
            String this$broadcasterName = this.getBroadcasterName();
            String other$broadcasterName = other.getBroadcasterName();
            if (this$broadcasterName == null ? other$broadcasterName != null : !this$broadcasterName.equals(other$broadcasterName)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModeratorEventData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $broadcasterId = this.getBroadcasterId();
            result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
            String $broadcasterName = this.getBroadcasterName();
            result = result * 59 + ($broadcasterName == null ? 43 : $broadcasterName.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            return result;
        }

        public String toString() {
            return "ModeratorEvent.ModeratorEventData(broadcasterId=" + this.getBroadcasterId() + ", broadcasterName=" + this.getBroadcasterName() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ")";
        }

        private void setBroadcasterId(@NonNull String broadcasterId) {
            if (broadcasterId == null) {
                throw new NullPointerException("broadcasterId is marked non-null but is null");
            }
            this.broadcasterId = broadcasterId;
        }

        private void setBroadcasterName(@NonNull String broadcasterName) {
            if (broadcasterName == null) {
                throw new NullPointerException("broadcasterName is marked non-null but is null");
            }
            this.broadcasterName = broadcasterName;
        }

        private void setUserId(@NonNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }

        private void setUserName(@NonNull String userName) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            this.userName = userName;
        }
    }
}

