/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Follow {
    private String fromId;
    private String fromName;
    private String toId;
    private String toName;
    @JsonProperty(value="followed_at")
    private Instant followedAtInstant;

    @JsonIgnore
    @Deprecated
    public LocalDateTime getFollowedAt() {
        return LocalDateTime.ofInstant(this.followedAtInstant, ZoneOffset.UTC);
    }

    public String getFromId() {
        return this.fromId;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getToId() {
        return this.toId;
    }

    public String getToName() {
        return this.toName;
    }

    public Instant getFollowedAtInstant() {
        return this.followedAtInstant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Follow)) {
            return false;
        }
        Follow other = (Follow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fromId = this.getFromId();
        String other$fromId = other.getFromId();
        if (this$fromId == null ? other$fromId != null : !this$fromId.equals(other$fromId)) {
            return false;
        }
        String this$fromName = this.getFromName();
        String other$fromName = other.getFromName();
        if (this$fromName == null ? other$fromName != null : !this$fromName.equals(other$fromName)) {
            return false;
        }
        String this$toId = this.getToId();
        String other$toId = other.getToId();
        if (this$toId == null ? other$toId != null : !this$toId.equals(other$toId)) {
            return false;
        }
        String this$toName = this.getToName();
        String other$toName = other.getToName();
        if (this$toName == null ? other$toName != null : !this$toName.equals(other$toName)) {
            return false;
        }
        Instant this$followedAtInstant = this.getFollowedAtInstant();
        Instant other$followedAtInstant = other.getFollowedAtInstant();
        return !(this$followedAtInstant == null ? other$followedAtInstant != null : !((Object)this$followedAtInstant).equals(other$followedAtInstant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Follow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromId = this.getFromId();
        result = result * 59 + ($fromId == null ? 43 : $fromId.hashCode());
        String $fromName = this.getFromName();
        result = result * 59 + ($fromName == null ? 43 : $fromName.hashCode());
        String $toId = this.getToId();
        result = result * 59 + ($toId == null ? 43 : $toId.hashCode());
        String $toName = this.getToName();
        result = result * 59 + ($toName == null ? 43 : $toName.hashCode());
        Instant $followedAtInstant = this.getFollowedAtInstant();
        result = result * 59 + ($followedAtInstant == null ? 43 : ((Object)$followedAtInstant).hashCode());
        return result;
    }

    public String toString() {
        return "Follow(fromId=" + this.getFromId() + ", fromName=" + this.getFromName() + ", toId=" + this.getToId() + ", toName=" + this.getToName() + ", followedAtInstant=" + this.getFollowedAtInstant() + ")";
    }

    private void setFromId(String fromId) {
        this.fromId = fromId;
    }

    private void setFromName(String fromName) {
        this.fromName = fromName;
    }

    private void setToId(String toId) {
        this.toId = toId;
    }

    private void setToName(String toName) {
        this.toName = toName;
    }

    @JsonProperty(value="followed_at")
    private void setFollowedAtInstant(Instant followedAtInstant) {
        this.followedAtInstant = followedAtInstant;
    }
}

